/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.IterableBitSet;
import common.IterableStateSet;
import common.iterable.FilteringIterable;
import common.iterable.IterableInt;
import explicit.Model;
import explicit.PredecessorRelation;
import explicit.StateValues;
import java.io.File;
import java.util.BitSet;
import java.util.List;
import java.util.PrimitiveIterator;
import parser.State;
import parser.VarList;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;

public abstract class ModelView
implements Model {
    protected BitSet deadlockStates = new BitSet();
    protected boolean fixedDeadlocks = false;
    protected PredecessorRelation predecessorRelation;

    public ModelView() {
    }

    public ModelView(ModelView modelView) {
        this.deadlockStates = (BitSet)modelView.deadlockStates.clone();
        this.fixedDeadlocks = modelView.fixedDeadlocks;
    }

    @Override
    public int getNumDeadlockStates() {
        return this.deadlockStates.cardinality();
    }

    public IterableInt getDeadlockStates() {
        return new IterableBitSet(this.deadlockStates);
    }

    @Override
    public StateValues getDeadlockStatesList() {
        return StateValues.createFromBitSet(this.deadlockStates, this);
    }

    @Override
    public int getFirstDeadlockState() {
        return this.deadlockStates.nextSetBit(0);
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.deadlockStates.get(n);
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        PrimitiveIterator.OfInt ofInt = this.findDeadlocks(new BitSet()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            this.deadlockStates.set(n);
        }
        if (bl && !this.fixedDeadlocks) {
            this.fixDeadlocks();
            this.fixedDeadlocks = true;
        }
    }

    public IterableInt findDeadlocks(BitSet bitSet) {
        IterableStateSet iterableStateSet = new IterableStateSet(bitSet, this.getNumStates(), true);
        return new FilteringIterable.OfInt(iterableStateSet, n -> !this.getSuccessorsIterator(n).hasNext());
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
        this.checkForDeadlocks(null);
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        PrimitiveIterator.OfInt ofInt = this.findDeadlocks(bitSet).iterator();
        if (ofInt.hasNext()) {
            throw new PrismException(this.getModelType() + " has a deadlock in state " + ofInt.nextInt());
        }
    }

    @Override
    public void exportToPrismExplicit(String string) throws PrismException {
        this.exportToPrismExplicitTra(string + ".tra");
    }

    @Override
    public void exportToPrismExplicitTra(String string) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToPrismExplicitTra(prismFileLog);
        }
    }

    @Override
    public void exportToPrismExplicitTra(File file) throws PrismException {
        this.exportToPrismExplicitTra(file.getPath());
    }

    @Override
    public void exportStates(int n, VarList varList, PrismLog prismLog) throws PrismException {
        int n2;
        List<State> list = this.getStatesList();
        if (list == null) {
            return;
        }
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("(");
        int n3 = varList.getNumVars();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.print(varList.getName(n2));
            if (n2 >= n3 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        if (n == 2) {
            prismLog.println("states=[");
        }
        int n4 = this.getNumStates();
        for (n2 = 0; n2 < n4; ++n2) {
            State state = list.get(n2);
            if (n != 2) {
                prismLog.println(n2 + ":" + state.toString());
                continue;
            }
            prismLog.println(state.toStringNoParentheses());
        }
        if (n == 2) {
            prismLog.println("];");
        }
    }

    @Override
    public boolean hasStoredPredecessorRelation() {
        return this.predecessorRelation != null;
    }

    @Override
    public PredecessorRelation getPredecessorRelation(PrismComponent prismComponent, boolean bl) {
        if (this.predecessorRelation != null) {
            return this.predecessorRelation;
        }
        PredecessorRelation predecessorRelation = PredecessorRelation.forModel(prismComponent, this);
        if (bl) {
            this.predecessorRelation = predecessorRelation;
        }
        return predecessorRelation;
    }

    @Override
    public void clearPredecessorRelation() {
        this.predecessorRelation = null;
    }

    protected abstract void fixDeadlocks();

    public boolean isVirtual() {
        return true;
    }
}

