/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Distribution;
import explicit.MDPSimple;
import explicit.STPG;
import explicit.rewards.MDPRewards;
import explicit.rewards.STPGRewards;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import prism.ModelType;

public class STPGExplicit
extends MDPSimple
implements STPG {
    protected List<Integer> stateOwners;

    public STPGExplicit() {
        this.stateOwners = new ArrayList<Integer>(0);
    }

    public STPGExplicit(int n) {
        super(n);
        this.stateOwners = new ArrayList<Integer>(n);
    }

    public STPGExplicit(STPGExplicit sTPGExplicit, int[] nArray) {
        super(sTPGExplicit, nArray);
        int n;
        this.stateOwners = new ArrayList<Integer>(this.numStates);
        for (n = 0; n < this.numStates; ++n) {
            this.stateOwners.add(0);
        }
        for (n = 0; n < this.numStates; ++n) {
            this.stateOwners.set(nArray[n], sTPGExplicit.stateOwners.get(n));
        }
    }

    public STPGExplicit(STPGExplicit sTPGExplicit) {
        super(sTPGExplicit);
        this.stateOwners = new ArrayList<Integer>(sTPGExplicit.stateOwners);
    }

    @Override
    public int addState() {
        return this.addState(1);
    }

    @Override
    public void addStates(int n) {
        super.addStates(n);
        for (int i = 0; i < n; ++i) {
            this.stateOwners.add(1);
        }
    }

    public int addState(int n) {
        super.addStates(1);
        this.stateOwners.add(n);
        return this.numStates - 1;
    }

    public void addStates(List<Integer> list) {
        super.addStates(list.size());
        this.stateOwners.addAll(list);
    }

    public void setPlayer(int n, int n2) {
        this.stateOwners.set(n, n2);
    }

    @Override
    public ModelType getModelType() {
        return ModelType.STPG;
    }

    @Override
    public int getPlayer(int n) {
        return this.stateOwners.get(n);
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return super.getNumTransitions(n, n2);
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n, int n2) {
        return super.getTransitionsIterator(n, n2);
    }

    @Override
    public boolean isChoiceNested(int n, int n2) {
        return false;
    }

    @Override
    public int getNumNestedChoices(int n, int n2) {
        return 0;
    }

    @Override
    public Object getNestedAction(int n, int n2, int n3) {
        return null;
    }

    @Override
    public int getNumNestedTransitions(int n, int n2, int n3) {
        return 0;
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getNestedTransitionsIterator(int n, int n2, int n3) {
        return null;
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, BitSet bitSet3) {
        boolean bl3 = false;
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            boolean bl4 = bl3 = this.getPlayer(i) == 1 ? bl : bl2;
            for (Distribution distribution : (List)this.trans.get(i)) {
                boolean bl5 = distribution.containsOneOf(bitSet2);
                if (bl3) {
                    if (bl5) continue;
                    bl4 = false;
                    continue;
                }
                if (!bl5) continue;
                bl4 = true;
            }
            bitSet3.set(i, bl4);
        }
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, BitSet bitSet4) {
        boolean bl3 = false;
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            boolean bl4 = bl3 = this.getPlayer(i) == 1 ? bl : bl2;
            for (Distribution distribution : (List)this.trans.get(i)) {
                boolean bl5;
                boolean bl6 = bl5 = distribution.containsOneOf(bitSet3) && distribution.isSubsetOf(bitSet2);
                if (bl3) {
                    if (bl5) continue;
                    bl4 = false;
                    continue;
                }
                if (!bl5) continue;
                bl4 = true;
            }
            bitSet4.set(i, bl4);
        }
    }

    @Override
    public void mvMultMinMax(double[] dArray, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray) {
        boolean bl4 = false;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                bl4 = this.getPlayer(i) == 1 ? bl : bl2;
                dArray2[i] = this.mvMultMinMaxSingle(i, dArray, bl4, nArray);
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                bl4 = this.getPlayer(n) == 1 ? bl : bl2;
                dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl4, nArray);
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl4 = this.getPlayer(n) == 1 ? bl : bl2;
                dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl4, nArray);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    @Override
    public double mvMultMinMaxSingle(int n, double[] dArray, boolean bl, boolean bl2) {
        boolean bl3 = this.getPlayer(n) == 1 ? bl : bl2;
        return this.mvMultMinMaxSingle(n, dArray, bl3, null);
    }

    @Override
    public List<Integer> mvMultMinMaxSingleChoices(int n, double[] dArray, boolean bl, boolean bl2, double d) {
        boolean bl3 = this.getPlayer(n) == 1 ? bl : bl2;
        return this.mvMultMinMaxSingleChoices(n, dArray, bl3, d);
    }

    @Override
    public double mvMultGSMinMax(double[] dArray, boolean bl, boolean bl2, BitSet bitSet, boolean bl3, boolean bl4) {
        double d = 0.0;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                double d2 = this.mvMultJacMinMaxSingle(i, dArray, bl, bl2);
                double d3 = bl4 ? Math.abs(d2 - dArray[i]) : Math.abs(d2 - dArray[i]) / d2;
                d = d3 > d ? d3 : d;
                dArray[i] = d2;
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                double d4 = this.mvMultJacMinMaxSingle(n, dArray, bl, bl2);
                double d5 = bl4 ? Math.abs(d4 - dArray[n]) : Math.abs(d4 - dArray[n]) / d4;
                d = d5 > d ? d5 : d;
                dArray[n] = d4;
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                double d6 = this.mvMultJacMinMaxSingle(n, dArray, bl, bl2);
                double d7 = bl4 ? Math.abs(d6 - dArray[n]) : Math.abs(d6 - dArray[n]) / d6;
                d = d7 > d ? d7 : d;
                dArray[n] = d6;
                n = bitSet.nextSetBit(n + 1);
            }
        }
        return d;
    }

    @Override
    public double mvMultJacMinMaxSingle(int n, double[] dArray, boolean bl, boolean bl2) {
        boolean bl3 = this.getPlayer(n) == 1 ? bl : bl2;
        return this.mvMultJacMinMaxSingle(n, dArray, bl3, null);
    }

    @Override
    public void mvMultRewMinMax(double[] dArray, STPGRewards sTPGRewards, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray) {
        boolean bl4 = false;
        MDPRewards mDPRewards = sTPGRewards.buildMDPRewards();
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                bl4 = this.getPlayer(i) == 1 ? bl : bl2;
                dArray2[i] = this.mvMultRewMinMaxSingle(i, dArray, mDPRewards, bl4, nArray, 1.0);
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                bl4 = this.getPlayer(n) == 1 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl4, nArray, 1.0);
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl4 = this.getPlayer(n) == 1 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl4, nArray, 1.0);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    @Override
    public double mvMultRewMinMaxSingle(int n, double[] dArray, STPGRewards sTPGRewards, boolean bl, boolean bl2, int[] nArray) {
        MDPRewards mDPRewards = sTPGRewards.buildMDPRewards();
        boolean bl3 = this.getPlayer(n) == 1 ? bl : bl2;
        return this.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl3, nArray);
    }

    @Override
    public List<Integer> mvMultRewMinMaxSingleChoices(int n, double[] dArray, STPGRewards sTPGRewards, boolean bl, boolean bl2, double d) {
        MDPRewards mDPRewards = sTPGRewards.buildMDPRewards();
        boolean bl3 = this.getPlayer(n) == 1 ? bl : bl2;
        return this.mvMultRewMinMaxSingleChoices(n, dArray, mDPRewards, bl3, d);
    }

    @Override
    public String toString() {
        Object object = "";
        object = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (i > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + i + "(P-" + this.getPlayer(i) + "): ";
            object = (String)object + "[";
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                Object object2;
                if (j > 0) {
                    object = (String)object + ",";
                }
                if ((object2 = this.getAction(i, j)) != null) {
                    object = (String)object + object2 + ":";
                }
                object = (String)object + ((List)this.trans.get(i)).get(j);
            }
            object = (String)object + "]";
        }
        object = (String)object + " ]\n";
        return object;
    }

    public double mvMultRewMinMaxSingle(int n, double[] dArray, MDPRewards mDPRewards, boolean bl, int[] nArray, double d) {
        int n2 = -1;
        double d2 = 0.0;
        boolean bl2 = true;
        int n3 = -1;
        List list = (List)this.trans.get(n);
        for (Distribution distribution : list) {
            double d3 = mDPRewards.getTransitionReward(n, ++n3);
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n4 = entry.getKey();
                double d4 = entry.getValue();
                d3 += d4 * dArray[n4] * d;
            }
            if (bl2 || bl && d3 < d2 || !bl && d3 > d2) {
                d2 = d3;
                if (nArray != null) {
                    n2 = n3;
                }
            }
            bl2 = false;
        }
        if (nArray != null & !bl2 && (nArray[n] == -1 || bl && d2 < dArray[n] || !bl && d2 > dArray[n] || this instanceof STPG)) {
            nArray[n] = n2;
        }
        return d2 += mDPRewards.getStateReward(n);
    }
}

