/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMC;
import explicit.DTMC;
import explicit.MDP;
import explicit.Model;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import parser.VarList;
import parser.type.Type;
import prism.ModelGenerator;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class ModelModelGenerator
implements ModelGenerator {
    private Model model;
    private ModelInfo modelInfo;
    private int sExplore = -1;
    private List<Transitions> trans = new ArrayList<Transitions>();

    public ModelModelGenerator(Model model, ModelInfo modelInfo) {
        this.model = model;
        this.modelInfo = modelInfo;
    }

    @Override
    public ModelType getModelType() {
        return this.model.getModelType();
    }

    @Override
    public List<String> getVarNames() {
        return this.modelInfo.getVarNames();
    }

    @Override
    public List<Type> getVarTypes() {
        return this.modelInfo.getVarTypes();
    }

    @Override
    public VarList createVarList() throws PrismException {
        return this.modelInfo.createVarList();
    }

    @Override
    public State getInitialState() throws PrismException {
        int n = this.model.getFirstInitialState();
        return this.model.getStatesList().get(n);
    }

    @Override
    public void exploreState(State state) throws PrismException {
        this.sExplore = this.model.getStatesList().indexOf(state);
        this.trans.clear();
        switch (this.model.getModelType()) {
            case CTMC: {
                this.storeTransitions(null, ((CTMC)this.model).getTransitionsIterator(this.sExplore));
                break;
            }
            case DTMC: {
                this.storeTransitions(null, ((DTMC)this.model).getTransitionsIterator(this.sExplore));
                break;
            }
            case MDP: {
                int n = ((MDP)this.model).getNumChoices(this.sExplore);
                for (int i = 0; i < n; ++i) {
                    Object object = ((MDP)this.model).getAction(this.sExplore, i);
                    this.storeTransitions(object, ((MDP)this.model).getTransitionsIterator(this.sExplore, i));
                }
                break;
            }
            default: {
                throw new PrismNotSupportedException("Model generation not supported for " + this.model.getModelType() + "s");
            }
        }
    }

    private void storeTransitions(Object object, Iterator<Map.Entry<Integer, Double>> iterator) {
        Transitions transitions = new Transitions();
        transitions.action = object;
        while (iterator.hasNext()) {
            Map.Entry<Integer, Double> entry = iterator.next();
            transitions.succs.add(entry.getKey());
            transitions.probs.add(entry.getValue());
        }
        this.trans.add(transitions);
    }

    @Override
    public int getNumChoices() throws PrismException {
        return this.trans.size();
    }

    @Override
    public int getNumTransitions(int n) throws PrismException {
        return this.trans.get((int)n).succs.size();
    }

    @Override
    public Object getTransitionAction(int n, int n2) throws PrismException {
        return this.trans.get((int)n).action;
    }

    @Override
    public double getTransitionProbability(int n, int n2) throws PrismException {
        return this.trans.get((int)n).probs.get(n2);
    }

    @Override
    public State computeTransitionTarget(int n, int n2) throws PrismException {
        return this.model.getStatesList().get(this.trans.get((int)n).succs.get(n2));
    }

    private class Transitions {
        Object action = null;
        List<Integer> succs = new ArrayList<Integer>();
        List<Double> probs = new ArrayList<Double>();
    }
}

