/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.FastAdaptiveUniformisation;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionTemporal;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.RewardStruct;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.Result;
import simulator.ModulesFileModelGenerator;

public class FastAdaptiveUniformisationModelChecker
extends PrismComponent {
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;
    private Values constantValues;
    private LabelList labelListModel;
    private LabelList labelListProp;

    public FastAdaptiveUniformisationModelChecker(PrismComponent prismComponent, ModulesFile modulesFile, PropertiesFile propertiesFile) throws PrismException {
        super(prismComponent);
        this.modulesFile = modulesFile;
        this.propertiesFile = propertiesFile;
        this.constantValues = new Values();
        this.constantValues.addValues(modulesFile.getConstantValues());
        if (propertiesFile != null) {
            this.constantValues.addValues(propertiesFile.getConstantValues());
        }
        this.labelListModel = modulesFile.getLabelList();
        this.labelListProp = propertiesFile.getLabelList();
    }

    public Result check(Expression expression) throws PrismException {
        long l = System.currentTimeMillis();
        Result result = this.checkExpression(expression);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nModel checking completed in " + (double)l / 1000.0 + " secs.");
        Object object = "Result";
        if (!"Result".equals(expression.getResultName())) {
            object = (String)object + " (" + expression.getResultName().toLowerCase() + ")";
        }
        object = (String)object + ": " + result;
        this.mainLog.print("\n" + (String)object + "\n");
        return result;
    }

    private Result checkExpression(Expression expression) throws PrismException {
        Result result;
        if (expression instanceof ExpressionProb) {
            result = this.checkExpressionProb((ExpressionProb)expression);
        } else if (expression instanceof ExpressionReward) {
            result = this.checkExpressionReward((ExpressionReward)expression);
        } else {
            throw new PrismNotSupportedException("Fast adaptive uniformisation not yet supported for this operator");
        }
        return result;
    }

    private Result checkExpressionProb(ExpressionProb expressionProb) throws PrismException {
        if (expressionProb.getProb() != null) {
            throw new PrismNotSupportedException("Fast adaptive uniformisation model checking currently only supports P=? properties");
        }
        if (!(expressionProb.getExpression() instanceof ExpressionTemporal)) {
            throw new PrismNotSupportedException("Fast adaptive uniformisation model checking currently only supports simple path operators");
        }
        ExpressionTemporal expressionTemporal = (ExpressionTemporal)expressionProb.getExpression();
        if (!expressionTemporal.isSimplePathFormula()) {
            throw new PrismNotSupportedException("Fast adaptive uniformisation window model checking currently only supports simple until operators");
        }
        double d = 0.0;
        if (expressionTemporal.getLowerBound() != null) {
            d = expressionTemporal.getLowerBound().evaluateDouble(this.constantValues);
        }
        if (expressionTemporal.getUpperBound() == null) {
            throw new PrismNotSupportedException("Fast adaptive uniformisation window model checking currently requires an upper time bound");
        }
        double d2 = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
        if (!expressionTemporal.hasBounds()) {
            throw new PrismNotSupportedException("Fast adaptive uniformisation window model checking currently only supports timed properties");
        }
        this.mainLog.println("Starting transient probability computation using fast adaptive uniformisation...");
        ModulesFileModelGenerator modulesFileModelGenerator = new ModulesFileModelGenerator(this.modulesFile, this);
        FastAdaptiveUniformisation fastAdaptiveUniformisation = new FastAdaptiveUniformisation(this, modulesFileModelGenerator);
        fastAdaptiveUniformisation.setConstantValues(this.constantValues);
        Expression expression = expressionTemporal.getOperand1();
        if (expression == null) {
            expression = Expression.True();
        }
        Expression expression2 = expressionTemporal.getOperand2();
        expression = (Expression)expression.expandPropRefsAndLabels(this.propertiesFile, this.labelListModel);
        expression = (Expression)expression.expandPropRefsAndLabels(this.propertiesFile, this.labelListProp);
        expression2 = (Expression)expression2.expandPropRefsAndLabels(this.propertiesFile, this.labelListModel);
        expression2 = (Expression)expression2.expandPropRefsAndLabels(this.propertiesFile, this.labelListProp);
        int n = expressionTemporal.getOperator();
        Expression expression3 = null;
        Expression expression4 = null;
        switch (n) {
            case 2: 
            case 3: {
                expression3 = Expression.Not(expression);
                break;
            }
            case 4: {
                expression3 = Expression.False();
                break;
            }
            default: {
                throw new PrismNotSupportedException("operator currently not supported for fast adaptive uniformisation");
            }
        }
        fastAdaptiveUniformisation.setSink(expression3);
        fastAdaptiveUniformisation.computeTransientProbsAdaptive(d);
        fastAdaptiveUniformisation.clearSinkStates();
        switch (n) {
            case 2: 
            case 3: {
                expression3 = Expression.Or(Expression.Not(expression), expression2);
                expression4 = expression2;
                break;
            }
            case 4: {
                expression3 = Expression.Not(expression2);
                expression4 = expression2;
                break;
            }
            default: {
                throw new PrismNotSupportedException("operator currently not supported for fast adaptive uniformisation");
            }
        }
        Values values = new Values();
        values.addValue("deadlock", "true");
        expression3.replaceVars(values);
        fastAdaptiveUniformisation.setAnalysisType(FastAdaptiveUniformisation.AnalysisType.REACH);
        fastAdaptiveUniformisation.setSink(expression3);
        fastAdaptiveUniformisation.setTarget(expression4);
        fastAdaptiveUniformisation.computeTransientProbsAdaptive(d2 - d);
        this.mainLog.println("\nTotal probability lost is : " + fastAdaptiveUniformisation.getTotalDiscreteLoss());
        this.mainLog.println("Maximal number of states stored during analysis : " + fastAdaptiveUniformisation.getMaxNumStates());
        return new Result(new Double(fastAdaptiveUniformisation.getValue()));
    }

    private Result checkExpressionReward(ExpressionReward expressionReward) throws PrismException {
        this.mainLog.println("Starting transient probability computation using fast adaptive uniformisation...");
        ModulesFileModelGenerator modulesFileModelGenerator = new ModulesFileModelGenerator(this.modulesFile, this);
        FastAdaptiveUniformisation fastAdaptiveUniformisation = new FastAdaptiveUniformisation(this, modulesFileModelGenerator);
        ExpressionTemporal expressionTemporal = (ExpressionTemporal)expressionReward.getExpression();
        switch (expressionTemporal.getOperator()) {
            case 12: {
                fastAdaptiveUniformisation.setAnalysisType(FastAdaptiveUniformisation.AnalysisType.REW_INST);
                break;
            }
            case 11: {
                fastAdaptiveUniformisation.setAnalysisType(FastAdaptiveUniformisation.AnalysisType.REW_CUMUL);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Currently only instantaneous or cumulative rewards are allowed.");
            }
        }
        double d = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
        RewardStruct rewardStruct = this.modulesFile.getRewardStruct(expressionReward.getRewardStructIndexByIndexObject(this.modulesFile.getRewardStructNames(), this.constantValues));
        fastAdaptiveUniformisation.setRewardStruct(rewardStruct);
        fastAdaptiveUniformisation.setConstantValues(this.constantValues);
        fastAdaptiveUniformisation.computeTransientProbsAdaptive(d);
        this.mainLog.println("\nTotal probability lost is : " + fastAdaptiveUniformisation.getTotalDiscreteLoss());
        this.mainLog.println("Maximal number of states stored during analysis : " + fastAdaptiveUniformisation.getMaxNumStates());
        return new Result(new Double(fastAdaptiveUniformisation.getValue()));
    }
}

