/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.ECComputer;
import explicit.NondetModel;
import explicit.SCCComputer;
import explicit.SCCConsumerStore;
import explicit.SubNondetModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import prism.PrismComponent;
import prism.PrismException;

public class ECComputerDefault
extends ECComputer {
    private NondetModel model;
    private List<BitSet> mecs = new ArrayList<BitSet>();
    private Set<BitSet> processedSCCs = new HashSet<BitSet>();

    public ECComputerDefault(PrismComponent prismComponent, NondetModel nondetModel) throws PrismException {
        super(prismComponent);
        this.model = nondetModel;
    }

    @Override
    public void computeMECStates() throws PrismException {
        this.mecs = this.findEndComponents(null, null);
    }

    @Override
    public void computeMECStates(BitSet bitSet) throws PrismException {
        this.mecs = this.findEndComponents(bitSet, null);
    }

    @Override
    public void computeMECStates(BitSet bitSet, BitSet bitSet2) throws PrismException {
        this.mecs = this.findEndComponents(bitSet, bitSet2);
    }

    @Override
    public List<BitSet> getMECStates() {
        return this.mecs;
    }

    private List<BitSet> findEndComponents(BitSet bitSet, BitSet bitSet2) throws PrismException {
        if (bitSet == null) {
            bitSet = new BitSet();
            bitSet.set(0, this.model.getNumStates());
        }
        List<BitSet> list = new ArrayList<BitSet>();
        if (bitSet.isEmpty()) {
            return list;
        }
        list.add(bitSet);
        boolean bl = true;
        while (bl) {
            bl = false;
            BitSet bitSet3 = (BitSet)list.remove(0);
            SubNondetModel subNondetModel = this.restrict(this.model, bitSet3);
            List<BitSet> list2 = this.translateStates(subNondetModel, this.computeSCCs(subNondetModel));
            list = this.replaceEWithSCCs(list, bitSet3, list2);
            bl = this.canLBeChanged(list, bitSet3);
        }
        if (bitSet2 != null) {
            int n = 0;
            while (n < list.size()) {
                if (!((BitSet)list.get(n)).intersects(bitSet2)) {
                    list.remove(n);
                    continue;
                }
                ++n;
            }
        }
        return list;
    }

    private boolean canLBeChanged(List<BitSet> list, BitSet bitSet) {
        this.processedSCCs.add(bitSet);
        for (int i = 0; i < list.size(); ++i) {
            if (this.processedSCCs.contains(list.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<BitSet> replaceEWithSCCs(List<BitSet> list, BitSet bitSet, List<BitSet> list2) {
        if (list2.size() > 0) {
            ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
            for (int i = 0; i < list2.size(); ++i) {
                if (list.contains(list2.get(i))) continue;
                arrayList.add(list2.get(i));
            }
            if (arrayList.size() > 0) {
                list.addAll(arrayList);
            }
        }
        return list;
    }

    private SubNondetModel restrict(NondetModel nondetModel, BitSet bitSet) {
        HashMap<Integer, BitSet> hashMap = new HashMap<Integer, BitSet>();
        BitSet bitSet2 = new BitSet();
        bitSet2.set(bitSet.nextSetBit(0));
        boolean bl = true;
        while (bl) {
            bl = false;
            hashMap.clear();
            for (int i = 0; i < nondetModel.getNumStates(); ++i) {
                BitSet bitSet3 = new BitSet();
                if (!bitSet.get(i)) continue;
                for (int j = 0; j < nondetModel.getNumChoices(i); ++j) {
                    if (!nondetModel.allSuccessorsInSet(i, j, bitSet)) continue;
                    bitSet3.set(j);
                }
                if (bitSet3.isEmpty()) {
                    bitSet.clear(i);
                    bl = true;
                }
                hashMap.put(i, bitSet3);
            }
        }
        return new SubNondetModel(nondetModel, bitSet, hashMap, bitSet2);
    }

    private List<BitSet> computeSCCs(NondetModel nondetModel) throws PrismException {
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, nondetModel, sCCConsumerStore);
        sCCComputer.computeSCCs();
        return sCCConsumerStore.getSCCs();
    }

    private List<BitSet> translateStates(SubNondetModel subNondetModel, List<BitSet> list) {
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        for (int i = 0; i < list.size(); ++i) {
            BitSet bitSet = list.get(i);
            BitSet bitSet2 = new BitSet();
            arrayList.add(bitSet2);
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bitSet2.set(subNondetModel.translateState(n));
                n = bitSet.nextSetBit(n + 1);
            }
        }
        return arrayList;
    }

    private boolean isMEC(BitSet bitSet) {
        if (bitSet.isEmpty()) {
            return false;
        }
        int n = bitSet.nextSetBit(0);
        while (n != -1) {
            boolean bl = false;
            for (int i = 0; i < this.model.getNumChoices(n); ++i) {
                if (!this.model.allSuccessorsInSet(n, i, bitSet)) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return true;
    }
}

