/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDProxy;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import org.apache.log4j.Logger;

public class GCDFactory {
    private static final Logger logger = Logger.getLogger(GCDFactory.class);

    protected GCDFactory() {
    }

    public static GreatestCommonDivisorAbstract<ModLong> getImplementation(ModLongRing modLongRing) {
        if (modLongRing.isField()) {
            GreatestCommonDivisorModEval<ModLong> greatestCommonDivisorModEval = new GreatestCommonDivisorModEval<ModLong>();
            return greatestCommonDivisorModEval;
        }
        GreatestCommonDivisorSubres<ModLong> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<ModLong>();
        return greatestCommonDivisorSubres;
    }

    public static GreatestCommonDivisorAbstract<ModLong> getProxy(ModLongRing modLongRing) {
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = modLongRing.isField() ? new GreatestCommonDivisorModEval() : new GreatestCommonDivisorSimple();
        return new GCDProxy<ModLong>(greatestCommonDivisorSubres, greatestCommonDivisorAbstract);
    }

    public static GreatestCommonDivisorAbstract<ModInteger> getImplementation(ModIntegerRing modIntegerRing) {
        if (modIntegerRing.isField()) {
            GreatestCommonDivisorModEval<ModInteger> greatestCommonDivisorModEval = new GreatestCommonDivisorModEval<ModInteger>();
            return greatestCommonDivisorModEval;
        }
        GreatestCommonDivisorSubres<ModInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<ModInteger>();
        return greatestCommonDivisorSubres;
    }

    public static GreatestCommonDivisorAbstract<ModInteger> getProxy(ModIntegerRing modIntegerRing) {
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = modIntegerRing.isField() ? new GreatestCommonDivisorModEval() : new GreatestCommonDivisorSimple();
        return new GCDProxy<ModInteger>(greatestCommonDivisorSubres, greatestCommonDivisorAbstract);
    }

    public static GreatestCommonDivisorAbstract<BigInteger> getImplementation(BigInteger bigInteger) {
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular();
        return greatestCommonDivisorModular;
    }

    public static GreatestCommonDivisorAbstract<BigInteger> getProxy(BigInteger bigInteger) {
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular();
        return new GCDProxy<BigInteger>(greatestCommonDivisorSubres, greatestCommonDivisorModular);
    }

    public static GreatestCommonDivisorAbstract<BigRational> getImplementation(BigRational bigRational) {
        GreatestCommonDivisorPrimitive<BigRational> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<BigRational>();
        return greatestCommonDivisorPrimitive;
    }

    public static GreatestCommonDivisorAbstract<BigRational> getProxy(BigRational bigRational) {
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple();
        return new GCDProxy<BigRational>(greatestCommonDivisorSubres, greatestCommonDivisorSimple);
    }

    public static <C extends GcdRingElem<C>> GreatestCommonDivisorAbstract<C> getImplementation(RingFactory<C> ringFactory) {
        logger.debug("fac = " + ringFactory.getClass().getName());
        RingFactory<C> ringFactory2 = ringFactory;
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = ringFactory2 instanceof BigInteger ? new GreatestCommonDivisorModular() : (ringFactory2 instanceof ModIntegerRing ? new GreatestCommonDivisorModEval() : (ringFactory2 instanceof ModLongRing ? new GreatestCommonDivisorModEval() : (ringFactory2 instanceof BigRational ? new GreatestCommonDivisorSubres() : (ringFactory.isField() ? new GreatestCommonDivisorSimple() : new GreatestCommonDivisorSubres()))));
        logger.debug("implementation = " + greatestCommonDivisorAbstract);
        return greatestCommonDivisorAbstract;
    }

    public static <C extends GcdRingElem<C>> GreatestCommonDivisorAbstract<C> getProxy(RingFactory<C> ringFactory) {
        if (ComputerThreads.NO_THREADS) {
            return GCDFactory.getImplementation(ringFactory);
        }
        logger.debug("fac = " + ringFactory.getClass().getName());
        RingFactory<C> ringFactory2 = ringFactory;
        GCDProxy<BigInteger> gCDProxy = ringFactory2 instanceof BigInteger ? new GCDProxy<BigInteger>(new GreatestCommonDivisorSubres(), new GreatestCommonDivisorModular()) : (ringFactory2 instanceof ModIntegerRing ? new GCDProxy(new GreatestCommonDivisorSimple(), new GreatestCommonDivisorModEval()) : (ringFactory2 instanceof ModLongRing ? new GCDProxy(new GreatestCommonDivisorSimple(), new GreatestCommonDivisorModEval()) : (ringFactory2 instanceof BigRational ? new GCDProxy(new GreatestCommonDivisorSubres(), new GreatestCommonDivisorSimple()) : (ringFactory.isField() ? new GCDProxy(new GreatestCommonDivisorSimple(), new GreatestCommonDivisorSubres()) : new GCDProxy(new GreatestCommonDivisorSubres(), new GreatestCommonDivisorPrimitive())))));
        logger.debug("ufd = " + gCDProxy);
        return gCDProxy;
    }
}

