/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.Factors;
import edu.jas.ufd.FactorsList;
import edu.jas.ufd.FactorsMap;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.PartialFraction;
import edu.jas.ufd.PolyUfdUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class FactorAbsolute<C extends GcdRingElem<C>>
extends FactorAbstract<C> {
    private static final Logger logger = Logger.getLogger(FactorAbsolute.class);
    private final boolean debug = logger.isDebugEnabled();

    protected FactorAbsolute() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAbsolute(RingFactory<C> ringFactory) {
        super(ringFactory);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    public boolean isAbsoluteIrreducible(GenPolynomial<C> genPolynomial) {
        if (!this.isIrreducible(genPolynomial)) {
            return false;
        }
        Factors<C> factors = this.factorsAbsoluteIrreducible(genPolynomial);
        if (factors.afac == null) {
            return true;
        }
        if (factors.afactors.size() > 2) {
            return false;
        }
        boolean bl = false;
        for (GenPolynomial genPolynomial2 : factors.afactors) {
            if (!genPolynomial2.isConstant()) continue;
            bl = true;
        }
        return bl;
    }

    public FactorsMap<C> baseFactorsAbsolute(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap treeMap = new TreeMap();
        if (genPolynomial.isZERO()) {
            return new FactorsMap<C>(genPolynomial, treeMap);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (genPolynomial.degree(0) <= 1L) {
            treeMap.put(genPolynomial, 1L);
            return new FactorsMap<C>(genPolynomial, treeMap);
        }
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.baseFactors(genPolynomial);
        if (this.debug && !this.isFactorization(genPolynomial, sortedMap)) {
            System.out.println("facs   = " + sortedMap);
            throw new ArithmeticException("isFactorization = false");
        }
        if (logger.isInfoEnabled()) {
            logger.info("all K factors = " + sortedMap);
        }
        TreeMap treeMap2 = new TreeMap();
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<C> genPolynomial2 = entry.getKey();
            Long l = entry.getValue();
            if (genPolynomial2.degree(0) <= 1L) {
                treeMap.put(genPolynomial2, l);
                continue;
            }
            Factors<C> factors = this.baseFactorsAbsoluteIrreducible(genPolynomial2);
            treeMap2.put(factors, l);
        }
        return new FactorsMap<C>(genPolynomial, treeMap, treeMap2);
    }

    public FactorsList<C> baseFactorsAbsoluteSquarefree(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList arrayList = new ArrayList();
        if (genPolynomial.isZERO()) {
            return new FactorsList<C>(genPolynomial, arrayList);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (genPolynomial.degree(0) <= 1L) {
            arrayList.add(genPolynomial);
            return new FactorsList<C>(genPolynomial, arrayList);
        }
        List<GenPolynomial<C>> list = this.baseFactorsSquarefree(genPolynomial);
        if (this.debug && !this.isFactorization(genPolynomial, list)) {
            throw new ArithmeticException("isFactorization = false");
        }
        if (logger.isInfoEnabled()) {
            logger.info("all K factors = " + list);
        }
        ArrayList arrayList2 = new ArrayList();
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2.degree(0) <= 1L) {
                arrayList.add(genPolynomial2);
                continue;
            }
            Factors<C> factors = this.baseFactorsAbsoluteIrreducible(genPolynomial2);
            if (logger.isInfoEnabled()) {
                logger.info("K(alpha) factors = " + factors);
            }
            arrayList2.add(factors);
        }
        return new FactorsList<C>(genPolynomial, arrayList, arrayList2);
    }

    public Factors<C> baseFactorsAbsoluteIrreducible(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        if (genPolynomial.isZERO()) {
            return new Factors<C>(genPolynomial);
        }
        GenPolynomialRing<C> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (genPolynomial.degree(0) <= 1L) {
            return new Factors<C>(genPolynomial);
        }
        String[] stringArray = genPolynomialRing.newVars("z_");
        genPolynomialRing = genPolynomialRing.copy();
        stringArray = genPolynomialRing.setVars(stringArray);
        GenPolynomial genPolynomial2 = genPolynomialRing.copy(genPolynomial);
        AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(genPolynomial2, true);
        if (logger.isInfoEnabled()) {
            logger.info("K(alpha) = " + algebraicNumberRing);
            logger.info("K(alpha) = " + algebraicNumberRing.toScript());
        }
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(algebraicNumberRing, genPolynomial2.ring.nvar, genPolynomial2.ring.tord, stringArray);
        GenPolynomial genPolynomial3 = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing2, genPolynomial);
        if (logger.isInfoEnabled()) {
            logger.info("P over K(alpha) = " + genPolynomial3);
        }
        FactorAbstract factorAbstract = FactorFactory.getImplementation(algebraicNumberRing);
        List list = factorAbstract.baseFactorsSquarefree(genPolynomial3);
        if (logger.isInfoEnabled()) {
            logger.info("factors over K(alpha) = " + list);
        }
        ArrayList arrayList = new ArrayList(list.size());
        ArrayList arrayList2 = new ArrayList();
        for (GenPolynomial genPolynomial4 : list) {
            if (genPolynomial4.degree(0) <= 1L) {
                arrayList.add(genPolynomial4);
                continue;
            }
            FactorAbsolute factorAbsolute = (FactorAbsolute)FactorFactory.getImplementation(algebraicNumberRing);
            Factors factors = factorAbsolute.baseFactorsAbsoluteIrreducible(genPolynomial4);
            arrayList2.add(factors);
        }
        if (arrayList2.size() == 0) {
            arrayList2 = null;
        }
        return new Factors<C>(genPolynomial, algebraicNumberRing, genPolynomial3, arrayList, arrayList2);
    }

    public PartialFraction<C> baseAlgebraicPartialFraction(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException(" P == null or P == 0");
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new IllegalArgumentException(" A == null or A == 0");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (genPolynomial2.degree(0) <= 1L) {
            arrayList.add(genPolynomial.leadingBaseCoefficient());
            arrayList2.add(genPolynomial2);
            return new PartialFraction<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
        }
        List<GenPolynomial<C>> list = this.baseFactorsSquarefree(genPolynomial2);
        List<GenPolynomial<C>> list2 = this.engine.basePartialFraction(genPolynomial, list);
        GenPolynomial<C> genPolynomial3 = list2.remove(0);
        if (!genPolynomial3.isZERO()) {
            throw new ArithmeticException(" A0 != 0: deg(A)>= deg(P)");
        }
        int n = 0;
        for (GenPolynomial<C> genPolynomial4 : list) {
            GenPolynomial<C> genPolynomial5 = list2.get(n++);
            if (genPolynomial4.degree(0) <= 1L) {
                arrayList.add(genPolynomial5.leadingBaseCoefficient());
                arrayList2.add(genPolynomial4);
                continue;
            }
            PartialFraction<C> partialFraction = this.baseAlgebraicPartialFractionIrreducibleAbsolute(genPolynomial5, genPolynomial4);
            arrayList.addAll(partialFraction.cfactors);
            arrayList2.addAll(partialFraction.cdenom);
            arrayList3.addAll(partialFraction.afactors);
            arrayList4.addAll(partialFraction.adenom);
        }
        return new PartialFraction<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
    }

    @Deprecated
    public PartialFraction<C> baseAlgebraicPartialFractionIrreducible(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException(" P == null or P == 0");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        ArrayList<C> arrayList = new ArrayList<C>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (genPolynomial2.degree(0) <= 1L) {
            arrayList.add(genPolynomial.leadingBaseCoefficient());
            arrayList2.add(genPolynomial2);
            return new PartialFraction<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        String[] stringArray = new String[]{"t"};
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing.coFac, 1, genPolynomialRing.tord, stringArray);
        GenPolynomial genPolynomial4 = genPolynomialRing2.univariate(0);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing, genPolynomialRing2);
        GenPolynomial genPolynomial5 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial);
        GenPolynomial genPolynomial6 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial2);
        GenPolynomial genPolynomial7 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial3);
        GenPolynomialRing genPolynomialRing4 = genPolynomial6.ring;
        GenPolynomial genPolynomial8 = ((GenPolynomial)genPolynomialRing4.getONE()).multiply(genPolynomial4);
        GenPolynomial genPolynomial9 = genPolynomial5.subtract(genPolynomial8.multiply(genPolynomial7));
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = null;
        GenPolynomial genPolynomial10 = greatestCommonDivisorSubres.recursiveUnivariateResultant(genPolynomial6, genPolynomial9);
        GenPolynomial genPolynomial11 = genPolynomial10.leadingBaseCoefficient();
        SortedMap sortedMap = this.baseFactors(genPolynomial11);
        for (GenPolynomial genPolynomial12 : sortedMap.keySet()) {
            GenPolynomial genPolynomial13;
            if (genPolynomial12.isConstant()) continue;
            stringArray = genPolynomialRing.newVars("z_");
            genPolynomialRing = genPolynomialRing.copy();
            genPolynomialRing.setVars(stringArray);
            genPolynomial12 = genPolynomialRing.copy(genPolynomial12);
            AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(genPolynomial12, true);
            logger.debug("afac = " + algebraicNumberRing.toScript());
            AlgebraicNumber algebraicNumber = algebraicNumberRing.getGenerator();
            GenPolynomialRing genPolynomialRing5 = new GenPolynomialRing(algebraicNumberRing, genPolynomial6.ring);
            GenPolynomial genPolynomial14 = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing5, genPolynomial2);
            GenPolynomial genPolynomial15 = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing5, genPolynomial3);
            GenPolynomial genPolynomial16 = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing5, genPolynomial);
            GenPolynomial genPolynomial17 = genPolynomial16.subtract(genPolynomial15.multiply(algebraicNumber));
            if (greatestCommonDivisorAbstract == null) {
                greatestCommonDivisorAbstract = GCDFactory.getImplementation(algebraicNumberRing);
            }
            if ((genPolynomial13 = greatestCommonDivisorAbstract.baseGcd(genPolynomial14, genPolynomial17)).isConstant()) continue;
            arrayList3.add(algebraicNumber);
            arrayList4.add(genPolynomial13);
            if (genPolynomial2.degree(0) != 2L || genPolynomial13.degree(0) != 1L) continue;
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>>[] genPolynomialArray = PolyUtil.basePseudoQuotientRemainder(genPolynomial14, genPolynomial13);
            GenPolynomial genPolynomial18 = genPolynomialArray[0];
            if (!genPolynomialArray[1].isZERO()) {
                throw new ArithmeticException("remainder not zero");
            }
            arrayList3.add(algebraicNumber.negate());
            arrayList4.add(genPolynomial18);
        }
        return new PartialFraction<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
    }

    public PartialFraction<C> baseAlgebraicPartialFractionIrreducibleAbsolute(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException(" P == null or P == 0");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        ArrayList<C> arrayList = new ArrayList<C>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (genPolynomial2.degree(0) <= 1L) {
            arrayList.add(genPolynomial.leadingBaseCoefficient());
            arrayList2.add(genPolynomial2);
            return new PartialFraction<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
        }
        Factors factors = this.factorsAbsoluteIrreducible(genPolynomial2);
        List list = factors.getFactors();
        GenPolynomial genPolynomial3 = factors.apoly;
        GenPolynomial genPolynomial4 = PolyUtil.convertToRecAlgebraicCoefficients(1, genPolynomial3.ring, genPolynomial);
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = GCDFactory.getProxy(factors.afac);
        List list2 = greatestCommonDivisorAbstract.basePartialFraction(genPolynomial4, list);
        GenPolynomial genPolynomial5 = list2.remove(0);
        if (!genPolynomial5.isZERO()) {
            throw new ArithmeticException(" A0 != 0: deg(A)>= deg(P)");
        }
        int n = 0;
        for (GenPolynomial genPolynomial6 : list) {
            GenPolynomial genPolynomial7 = list2.get(n++);
            if (genPolynomial6.degree(0) <= 1L) {
                arrayList3.add(genPolynomial7.leadingBaseCoefficient());
                arrayList4.add(genPolynomial6);
                continue;
            }
            System.out.println("fa = " + genPolynomial6);
            Factors<AlgebraicNumber<C>> factors2 = factors.getFactor(genPolynomial6);
            System.out.println("faf = " + factors2);
            List list3 = factors2.getFactors();
            GenPolynomial genPolynomial8 = PolyUtil.convertToRecAlgebraicCoefficients(1, factors2.apoly.ring, genPolynomial7);
            GreatestCommonDivisorAbstract greatestCommonDivisorAbstract2 = GCDFactory.getImplementation(factors2.afac);
            List list4 = greatestCommonDivisorAbstract2.basePartialFraction(genPolynomial8, list3);
            System.out.println("algeb part frac = " + list4);
            GenPolynomial genPolynomial9 = list4.remove(0);
            if (!genPolynomial9.isZERO()) {
                throw new ArithmeticException(" A0 != 0: deg(A)>= deg(P)");
            }
            int n2 = 0;
            for (GenPolynomial genPolynomial10 : list3) {
                GenPolynomial genPolynomial11 = list4.get(n2++);
                System.out.println("faa = " + genPolynomial10);
                System.out.println("ana = " + genPolynomial11);
                if (genPolynomial10.degree(0) > 1L) {
                    throw new ArithmeticException(" faa not linear");
                }
                GenPolynomial genPolynomial12 = genPolynomial11;
                GenPolynomial genPolynomial13 = genPolynomial10;
                arrayList3.add(genPolynomial12.leadingBaseCoefficient());
                arrayList4.add(genPolynomial13);
            }
        }
        return new PartialFraction<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
    }

    public FactorsMap<C> factorsAbsolute(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap treeMap = new TreeMap();
        if (genPolynomial.isZERO()) {
            return new FactorsMap<C>(genPolynomial, treeMap);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseFactorsAbsolute(genPolynomial);
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (genPolynomial.degree() <= 1L) {
            treeMap.put(genPolynomial, 1L);
            return new FactorsMap<C>(genPolynomial, treeMap);
        }
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.factors(genPolynomial);
        if (this.debug && !this.isFactorization(genPolynomial, sortedMap)) {
            throw new ArithmeticException("isFactorization = false");
        }
        if (logger.isInfoEnabled()) {
            logger.info("all K factors = " + sortedMap);
        }
        TreeMap treeMap2 = new TreeMap();
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<C> genPolynomial2 = entry.getKey();
            Long l = entry.getValue();
            if (genPolynomial2.degree() <= 1L) {
                treeMap.put(genPolynomial2, l);
                continue;
            }
            Factors<C> factors = this.factorsAbsoluteIrreducible(genPolynomial2);
            if (factors.afac == null) {
                treeMap.put(genPolynomial2, l);
                continue;
            }
            treeMap2.put(factors, l);
        }
        return new FactorsMap<C>(genPolynomial, treeMap, treeMap2);
    }

    public FactorsList<C> factorsAbsoluteSquarefree(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList arrayList = new ArrayList();
        if (genPolynomial.isZERO()) {
            return new FactorsList<C>(genPolynomial, arrayList);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseFactorsAbsoluteSquarefree(genPolynomial);
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (genPolynomial.degree() <= 1L) {
            arrayList.add(genPolynomial);
            return new FactorsList<C>(genPolynomial, arrayList);
        }
        List<GenPolynomial<C>> list = this.factorsSquarefree(genPolynomial);
        if (this.debug && !this.isFactorization(genPolynomial, list)) {
            throw new ArithmeticException("isFactorization = false");
        }
        if (logger.isInfoEnabled()) {
            logger.info("all K factors = " + list);
        }
        ArrayList arrayList2 = new ArrayList();
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2.degree() <= 1L) {
                arrayList.add(genPolynomial2);
                continue;
            }
            Factors<C> factors = this.factorsAbsoluteIrreducible(genPolynomial2);
            if (this.debug) {
                logger.info("K(alpha) factors = " + factors);
            }
            if (factors.afac == null) {
                arrayList.add(genPolynomial2);
                continue;
            }
            arrayList2.add(factors);
        }
        return new FactorsList<C>(genPolynomial, arrayList, arrayList2);
    }

    public Factors<C> factorsAbsoluteIrreducible(GenPolynomial<C> genPolynomial) {
        RingElem ringElem;
        Object object;
        Serializable serializable;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        if (genPolynomial.isZERO()) {
            return new Factors<C>(genPolynomial);
        }
        Serializable serializable2 = genPolynomial.ring;
        if (serializable2.nvar <= 1) {
            return this.baseFactorsAbsoluteIrreducible(genPolynomial);
        }
        if (!serializable2.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients");
        }
        if (genPolynomial.degree() <= 1L) {
            return new Factors<C>(genPolynomial);
        }
        RingElem<GenPolynomial<C>> ringElem2 = genPolynomial;
        RingFactory ringFactory = serializable2.coFac;
        long l = ringFactory.characteristic().longValue();
        if (l == 0L) {
            l = Long.MAX_VALUE;
        }
        long l2 = 0L;
        for (int i = 0; i < serializable2.nvar - 1; ++i) {
            GenPolynomial genPolynomial2;
            l2 = 0L;
            serializable = serializable2.contract(1);
            object = new String[]{serializable2.getVars()[serializable2.nvar - 1]};
            GenPolynomialRing genPolynomialRing = new GenPolynomialRing(serializable, 1, serializable2.tord, (String[])object);
            GenPolynomial genPolynomial3 = PolyUtil.recursive(genPolynomialRing, ringElem2);
            do {
                if (l2 >= l) {
                    throw new ArithmeticException("elements of prime field exhausted: " + l);
                }
                ringElem = (GcdRingElem)ringFactory.fromInteger(l2);
                genPolynomial2 = PolyUtil.evaluateMainRecursive(serializable, genPolynomial3, ringElem);
                ++l2;
            } while (!this.isSquarefree(genPolynomial2));
            ringElem2 = genPolynomial2;
            serializable2 = serializable;
        }
        ringElem2 = ((GenPolynomial)ringElem2).monic();
        if (this.debug) {
            logger.info("P(" + l2 + ") = " + ringElem2);
        }
        if (this.debug && !this.isSquarefree(ringElem2)) {
            throw new ArithmeticException("not irreducible up = " + ringElem2);
        }
        if (((GenPolynomial)ringElem2).degree(0) <= 1L) {
            return new Factors<C>(genPolynomial);
        }
        List<GenPolynomial<C>> list = this.baseFactorsSquarefree(ringElem2);
        serializable = this.baseFactorsAbsoluteSquarefree((GenPolynomial<C>)ringElem2);
        object = ((FactorsList)serializable).findExtensionField();
        long l3 = ((GenPolynomial)ringElem2).degree(0);
        for (int i = 0; i < list.size(); ++i) {
            ringElem = list.get(i);
            long l4 = ((GenPolynomial)ringElem).degree(0);
            if (1L > l4 || l4 > l3) continue;
            ringElem2 = ringElem;
            l3 = ((GenPolynomial)ringElem2).degree(0);
        }
        if (((GenPolynomial)ringElem2).degree(0) <= 1L) {
            return new Factors<C>(genPolynomial);
        }
        if (this.debug) {
            logger.info("field extension by " + ringElem2);
        }
        List<Object> list2 = new ArrayList();
        ringElem = serializable2.newVars("z_");
        serializable2 = serializable2.copy();
        serializable2.setVars((String[])ringElem);
        Object object2 = object;
        int n = ((AlgebraicNumberRing)object2).depth();
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(object2, genPolynomial.ring.nvar, genPolynomial.ring.tord, genPolynomial.ring.getVars());
        GenPolynomial genPolynomial4 = PolyUtil.convertToRecAlgebraicCoefficients(n, genPolynomialRing, genPolynomial);
        FactorAbstract factorAbstract = FactorFactory.getImplementation(object2);
        list2 = factorAbstract.factorsSquarefree(genPolynomial4);
        if (this.debug) {
            logger.info("K(alpha) factors multi = " + list2);
        }
        if (list2.size() <= 1) {
            return new Factors<C>(genPolynomial);
        }
        GenPolynomial<AlgebraicNumber> genPolynomial5 = (GenPolynomial<AlgebraicNumber>)list2.get(0);
        AlgebraicNumber algebraicNumber = (AlgebraicNumber)genPolynomial5.leadingBaseCoefficient();
        if (!algebraicNumber.isONE()) {
            GenPolynomial<AlgebraicNumber> genPolynomial6 = (GenPolynomial<AlgebraicNumber>)list2.get(1);
            list2.remove(genPolynomial5);
            list2.remove(genPolynomial6);
            genPolynomial5 = genPolynomial5.divide(algebraicNumber);
            genPolynomial6 = genPolynomial6.multiply(algebraicNumber);
            list2.add(genPolynomial5);
            list2.add(genPolynomial6);
        }
        return new Factors<C>(genPolynomial, object2, genPolynomial4, list2);
    }

    public boolean isAbsoluteFactorization(Factors<C> factors) {
        boolean bl;
        if (factors == null) {
            throw new IllegalArgumentException("facs may not be null");
        }
        if (factors.afac == null) {
            return true;
        }
        GenPolynomial genPolynomial = factors.apoly;
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomial genPolynomial2 = genPolynomialRing.getONE();
        for (GenPolynomial object : factors.afactors) {
            genPolynomial2 = genPolynomial2.multiply(object);
        }
        boolean bl2 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
        if (bl) {
            return bl;
        }
        if (factors.arfactors == null) {
            return false;
        }
        for (Factors factors2 : factors.arfactors) {
            genPolynomial2 = genPolynomial2.multiply(factors2.poly);
        }
        boolean bl3 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
        if (!bl) {
            System.out.println("\nFactors: " + factors);
            System.out.println("fa = " + genPolynomial);
            System.out.println("t = " + genPolynomial2);
        }
        return bl;
    }

    public boolean isAbsoluteFactorization(FactorsList<C> factorsList) {
        boolean bl;
        if (factorsList == null) {
            throw new IllegalArgumentException("facs may not be null");
        }
        GenPolynomial genPolynomial = factorsList.poly;
        GenPolynomial genPolynomial2 = genPolynomial.ring.getONE();
        for (GenPolynomial comparable : factorsList.factors) {
            genPolynomial2 = genPolynomial2.multiply(comparable);
        }
        if (genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate())) {
            return true;
        }
        if (factorsList.afactors == null) {
            return false;
        }
        for (Factors factors : factorsList.afactors) {
            if (!this.isAbsoluteFactorization(factors)) {
                return false;
            }
            genPolynomial2 = genPolynomial2.multiply(factorsList.poly);
        }
        boolean bl2 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
        if (!bl) {
            System.out.println("\nFactorsList: " + factorsList);
            System.out.println("P = " + genPolynomial);
            System.out.println("t = " + genPolynomial2);
        }
        return bl;
    }

    public boolean isAbsoluteFactorization(FactorsMap<C> factorsMap) {
        boolean bl;
        GenPolynomial genPolynomial;
        long l;
        Comparable comparable;
        if (factorsMap == null) {
            throw new IllegalArgumentException("facs may not be null");
        }
        GenPolynomial genPolynomial2 = factorsMap.poly;
        GenPolynomial genPolynomial3 = genPolynomial2.ring.getONE();
        for (Map.Entry entry : factorsMap.factors.entrySet()) {
            comparable = entry.getKey();
            l = entry.getValue();
            genPolynomial = Power.positivePower(comparable, l);
            genPolynomial3 = genPolynomial3.multiply(genPolynomial);
        }
        if (genPolynomial2.equals(genPolynomial3) || genPolynomial2.equals(genPolynomial3.negate())) {
            return true;
        }
        if (factorsMap.afactors == null) {
            return false;
        }
        for (Map.Entry entry : factorsMap.afactors.entrySet()) {
            comparable = (Factors)entry.getKey();
            if (!this.isAbsoluteFactorization((Factors<C>)comparable)) {
                return false;
            }
            l = entry.getValue();
            genPolynomial = Power.positivePower(((Factors)comparable).poly, l);
            genPolynomial3 = genPolynomial3.multiply(genPolynomial);
        }
        boolean bl2 = bl = genPolynomial2.equals(genPolynomial3) || genPolynomial2.equals(genPolynomial3.negate());
        if (!bl) {
            System.out.println("\nFactorsMap: " + factorsMap);
            System.out.println("P = " + genPolynomial2);
            System.out.println("t = " + genPolynomial3);
        }
        return bl;
    }
}

