/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.AlgFromRealCoeff;
import edu.jas.root.CoeffToComplex;
import edu.jas.root.CoeffToComplexFromComplex;
import edu.jas.root.CoeffToReAlg;
import edu.jas.root.CoeffToReal;
import edu.jas.root.CoeffToRecReAlg;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.PolyToReAlg;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealFromAlgCoeff;
import edu.jas.structure.GcdRingElem;
import org.apache.log4j.Logger;

public class PolyUtilRoot {
    private static final Logger logger = Logger.getLogger(PolyUtilRoot.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        if (debug) {
            logger.info("afac = " + realAlgebraicRing);
        }
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToReAlg(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToRecAlgebraicCoefficients(int n, GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToRecReAlg(n, realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertRecursiveToAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new PolyToReAlg(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<AlgebraicNumber<C>> algebraicFromRealCoefficients(GenPolynomialRing<AlgebraicNumber<C>> genPolynomialRing, GenPolynomial<RealAlgebraicNumber<C>> genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new AlgFromRealCoeff(algebraicNumberRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> realFromAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RealFromAlgCoeff(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToRealCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToReal(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<ComplexAlgebraicNumber<C>> convertToComplexCoefficients(GenPolynomialRing<ComplexAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        ComplexAlgebraicRing complexAlgebraicRing = (ComplexAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToComplex(complexAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<ComplexAlgebraicNumber<C>> convertToComplexCoefficientsFromComplex(GenPolynomialRing<ComplexAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<Complex<C>> genPolynomial) {
        ComplexAlgebraicRing complexAlgebraicRing = (ComplexAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToComplexFromComplex(complexAlgebraicRing));
    }
}

