/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgToPoly;
import edu.jas.poly.AlgebToCompl;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.AnyToComplex;
import edu.jas.poly.CoeffToAlg;
import edu.jas.poly.CoeffToRecAlg;
import edu.jas.poly.CompRatToDec;
import edu.jas.poly.ComplToAlgeb;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.DistToRec;
import edu.jas.poly.EvalMain;
import edu.jas.poly.EvalMainPol;
import edu.jas.poly.ExpVector;
import edu.jas.poly.FromInteger;
import edu.jas.poly.FromIntegerPoly;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.ImagPart;
import edu.jas.poly.ImagPartComplex;
import edu.jas.poly.ModSymToInt;
import edu.jas.poly.ModToInt;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyToAlg;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RatToCompl;
import edu.jas.poly.RatToDec;
import edu.jas.poly.RatToInt;
import edu.jas.poly.RatToIntFactor;
import edu.jas.poly.RatToIntPoly;
import edu.jas.poly.RealPart;
import edu.jas.poly.RealPartComplex;
import edu.jas.poly.RecToDist;
import edu.jas.poly.TermOrder;
import edu.jas.poly.ToComplex;
import edu.jas.poly.Word;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import edu.jas.util.ListUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class PolyUtil {
    private static final Logger logger = Logger.getLogger(PolyUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursive(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial.isZERO()) {
            return element;
        }
        int n = genPolynomialRing.nvar;
        GenPolynomial<RingElem> genPolynomial2 = genPolynomialRing.getZEROCoefficient();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = expVector.contract(0, n);
            ExpVector expVector3 = expVector.contract(n, expVector.length() - n);
            GenPolynomial<RingElem> genPolynomial3 = (GenPolynomial<RingElem>)sortedMap.get(expVector2);
            if (genPolynomial3 == null) {
                genPolynomial3 = genPolynomial2;
            }
            genPolynomial3 = genPolynomial3.sum(ringElem, expVector3);
            sortedMap.put(expVector2, genPolynomial3);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> distribute(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial.isZERO()) {
            return element;
        }
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            for (Map.Entry entry2 : genPolynomial2.val.entrySet()) {
                ExpVector expVector2 = entry2.getKey();
                RingElem ringElem = (RingElem)entry2.getValue();
                ExpVector expVector3 = expVector.combine(expVector2);
                assert (sortedMap.get(expVector3) == null);
                sortedMap.put(expVector3, ringElem);
            }
        }
        return element;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> recursive(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, List<GenPolynomial<C>> list) {
        return ListUtil.map(list, new DistToRec<C>(genPolynomialRing));
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> distribute(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<GenPolynomial<C>>> list) {
        return ListUtil.map(list, new RecToDist<C>(genPolynomialRing));
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<edu.jas.arith.BigInteger> integerFromModularCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ModSymToInt());
    }

    public static <C extends RingElem<C> & Modular> List<GenPolynomial<edu.jas.arith.BigInteger>> integerFromModularCoefficients(final GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing, List<GenPolynomial<C>> list) {
        return ListUtil.map(list, new UnaryFunctor<GenPolynomial<C>, GenPolynomial<edu.jas.arith.BigInteger>>(){

            @Override
            public GenPolynomial<edu.jas.arith.BigInteger> eval(GenPolynomial<C> genPolynomial) {
                return PolyUtil.integerFromModularCoefficients((GenPolynomialRing<edu.jas.arith.BigInteger>)genPolynomialRing, genPolynomial);
            }
        });
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<edu.jas.arith.BigInteger> integerFromModularCoefficientsPositive(GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ModToInt());
    }

    public static GenPolynomial<edu.jas.arith.BigInteger> integerFromRationalCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing, GenPolynomial<BigRational> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        BigInteger bigInteger = null;
        int n = 0;
        for (BigRational bigRational : genPolynomial.val.values()) {
            BigInteger bigInteger2 = bigRational.denominator();
            if (bigInteger == null) {
                bigInteger = bigInteger2;
                n = bigInteger2.signum();
                continue;
            }
            BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
            bigInteger = bigInteger.multiply(bigInteger2.divide(bigInteger3));
        }
        if (n < 0) {
            bigInteger = bigInteger.negate();
        }
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RatToInt(bigInteger));
    }

    public static Object[] integerFromRationalCoefficientsFactor(GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing, GenPolynomial<BigRational> genPolynomial) {
        Object[] objectArray = new Object[3];
        if (genPolynomial == null || genPolynomial.isZERO()) {
            objectArray[0] = BigInteger.ONE;
            objectArray[1] = BigInteger.ZERO;
            objectArray[2] = genPolynomialRing.getZERO();
            return objectArray;
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        int n = 0;
        int n2 = 0;
        for (BigRational bigRational : genPolynomial.val.values()) {
            BigInteger bigInteger3 = bigRational.numerator();
            BigInteger bigInteger4 = bigRational.denominator();
            if (bigInteger2 == null) {
                bigInteger2 = bigInteger4;
                n = bigInteger4.signum();
            } else {
                BigInteger bigInteger5 = bigInteger2.gcd(bigInteger4);
                bigInteger2 = bigInteger2.multiply(bigInteger4.divide(bigInteger5));
            }
            if (bigInteger == null) {
                bigInteger = bigInteger3;
                n2 = bigInteger3.signum();
                continue;
            }
            bigInteger = bigInteger.gcd(bigInteger3);
        }
        if (n < 0) {
            bigInteger2 = bigInteger2.negate();
        }
        if (n2 < 0) {
            bigInteger = bigInteger.negate();
        }
        objectArray[0] = bigInteger;
        objectArray[1] = bigInteger2;
        objectArray[2] = PolyUtil.map(genPolynomialRing, genPolynomial, new RatToIntFactor(bigInteger, bigInteger2));
        return objectArray;
    }

    public static List<GenPolynomial<edu.jas.arith.BigInteger>> integerFromRationalCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing, List<GenPolynomial<BigRational>> list) {
        return ListUtil.map(list, new RatToIntPoly(genPolynomialRing));
    }

    public static <C extends RingElem<C>> GenPolynomial<C> fromIntegerCoefficients(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new FromInteger(genPolynomialRing.coFac));
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> fromIntegerCoefficients(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<edu.jas.arith.BigInteger>> list) {
        return ListUtil.map(list, new FromIntegerPoly<C>(genPolynomialRing));
    }

    public static <C extends RingElem<C> & Rational> GenPolynomial<BigDecimal> decimalFromRational(GenPolynomialRing<BigDecimal> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RatToDec());
    }

    public static <C extends RingElem<C> & Rational> GenPolynomial<Complex<BigDecimal>> complexDecimalFromRational(GenPolynomialRing<Complex<BigDecimal>> genPolynomialRing, GenPolynomial<Complex<C>> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CompRatToDec(genPolynomialRing.coFac));
    }

    public static GenPolynomial<BigRational> realPart(GenPolynomialRing<BigRational> genPolynomialRing, GenPolynomial<BigComplex> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RealPart());
    }

    public static GenPolynomial<BigRational> imaginaryPart(GenPolynomialRing<BigRational> genPolynomialRing, GenPolynomial<BigComplex> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ImagPart());
    }

    public static <C extends RingElem<C>> GenPolynomial<C> realPartFromComplex(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<Complex<C>> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RealPartComplex());
    }

    public static <C extends RingElem<C>> GenPolynomial<C> imaginaryPartFromComplex(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<Complex<C>> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ImagPartComplex());
    }

    public static <C extends RingElem<C>> GenPolynomial<Complex<C>> toComplex(GenPolynomialRing<Complex<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ToComplex(genPolynomialRing.coFac));
    }

    public static GenPolynomial<BigComplex> complexFromRational(GenPolynomialRing<BigComplex> genPolynomialRing, GenPolynomial<BigRational> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RatToCompl());
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Complex<C>> complexFromAny(GenPolynomialRing<Complex<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        ComplexRing complexRing = (ComplexRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new AnyToComplex(complexRing));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> fromAlgebraicCoefficients(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new AlgToPoly());
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToAlg(algebraicNumberRing));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToRecAlgebraicCoefficients(int n, GenPolynomialRing<AlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToRecAlg(n, algebraicNumberRing));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertRecursiveToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new PolyToAlg(algebraicNumberRing));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Complex<C>> complexFromAlgebraic(GenPolynomialRing<Complex<C>> genPolynomialRing, GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        ComplexRing complexRing = (ComplexRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new AlgebToCompl(complexRing));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> algebraicFromComplex(GenPolynomialRing<AlgebraicNumber<C>> genPolynomialRing, GenPolynomial<Complex<C>> genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ComplToAlgeb(algebraicNumberRing));
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<C> chineseRemainder(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, C c, GenPolynomial<C> genPolynomial2) {
        RingElem ringElem;
        ExpVector expVector;
        ModularRingFactory modularRingFactory = (ModularRingFactory)genPolynomialRing.coFac;
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        Element element2 = genPolynomial.copy();
        SortedMap sortedMap = ((GenPolynomial)element2).val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial2.getMap();
        SortedMap sortedMap3 = ((GenPolynomial)element).val;
        RingElem ringElem2 = null;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            expVector = entry.getKey();
            ringElem = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector);
            if (ringElem3 != null) {
                sortedMap.remove(expVector);
                ringElem2 = modularRingFactory.chineseRemainder(ringElem3, c, ringElem);
                if (ringElem2.isZERO()) continue;
                sortedMap3.put(expVector, ringElem2);
                continue;
            }
            ringElem2 = modularRingFactory.chineseRemainder((RingElem)genPolynomial.ring.coFac.getZERO(), c, ringElem);
            if (ringElem2.isZERO()) continue;
            sortedMap3.put(expVector, ringElem2);
        }
        for (Map.Entry<ExpVector, C> entry : sortedMap.entrySet()) {
            expVector = entry.getKey();
            ringElem = (RingElem)entry.getValue();
            ringElem2 = modularRingFactory.chineseRemainder(ringElem, c, (RingElem)genPolynomial2.ring.coFac.getZERO());
            if (ringElem2.isZERO()) continue;
            sortedMap3.put(expVector, ringElem2);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> monic(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        C c = genPolynomial.leadingBaseCoefficient().leadingBaseCoefficient();
        if (!c.isUnit()) {
            return genPolynomial;
        }
        RingElem ringElem = (RingElem)c.inverse();
        GenPolynomial<RingElem> genPolynomial2 = (GenPolynomial<RingElem>)genPolynomial.ring.coFac.getONE();
        genPolynomial2 = genPolynomial2.multiply(ringElem);
        return genPolynomial.multiply((GenPolynomial<GenPolynomial<RingElem>>)genPolynomial2);
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> monic(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        Object c = ((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).leadingBaseCoefficient();
        if (!c.isUnit()) {
            return genSolvablePolynomial;
        }
        RingElem ringElem = (RingElem)c.inverse();
        GenPolynomial<RingElem> genPolynomial = (GenPolynomial<RingElem>)genSolvablePolynomial.ring.coFac.getONE();
        genPolynomial = genPolynomial.multiply(ringElem);
        return genSolvablePolynomial.multiplyLeft(genPolynomial);
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> monic(List<GenPolynomial<C>> list) {
        return ListUtil.map(list, new UnaryFunctor<GenPolynomial<C>, GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> eval(GenPolynomial<C> genPolynomial) {
                if (genPolynomial == null) {
                    return null;
                }
                return genPolynomial.monic();
            }
        });
    }

    public static <C extends RingElem<C>> List<GenWordPolynomial<C>> wordMonic(List<GenWordPolynomial<C>> list) {
        return ListUtil.map(list, new UnaryFunctor<GenWordPolynomial<C>, GenWordPolynomial<C>>(){

            @Override
            public GenWordPolynomial<C> eval(GenWordPolynomial<C> genWordPolynomial) {
                if (genWordPolynomial == null) {
                    return null;
                }
                return genWordPolynomial.monic();
            }
        });
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> monicRec(List<GenPolynomial<GenPolynomial<C>>> list) {
        return ListUtil.map(list, new UnaryFunctor<GenPolynomial<GenPolynomial<C>>, GenPolynomial<GenPolynomial<C>>>(){

            @Override
            public GenPolynomial<GenPolynomial<C>> eval(GenPolynomial<GenPolynomial<C>> genPolynomial) {
                if (genPolynomial == null) {
                    return null;
                }
                return PolyUtil.monic(genPolynomial);
            }
        });
    }

    public static <C extends RingElem<C>> List<ExpVector> leadingExpVector(List<GenPolynomial<C>> list) {
        return ListUtil.map(list, new UnaryFunctor<GenPolynomial<C>, ExpVector>(){

            @Override
            public ExpVector eval(GenPolynomial<C> genPolynomial) {
                if (genPolynomial == null) {
                    return null;
                }
                return genPolynomial.leadingExpVector();
            }
        });
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> extendCoefficients(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial, int n, long l) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial.isZERO()) {
            return element;
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry entry : genPolynomial.val.entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getValue();
            GenPolynomial genPolynomial3 = genPolynomial2.extend(genPolynomialRing2, n, l);
            sortedMap.put(expVector, genPolynomial3);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> extendCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> genSolvablePolynomialRing, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, int n, long l) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomialRing.getZERO()).copy();
        if (genSolvablePolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genSolvablePolynomialRing.coFac;
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        for (Map.Entry entry : genSolvablePolynomial.val.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getValue();
            GenPolynomial genPolynomial3 = genPolynomial2.extend(genPolynomialRing, n, l);
            sortedMap.put(expVector, genPolynomial3);
        }
        return genPolynomial;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> toRecursive(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial.isZERO()) {
            return element;
        }
        GenPolynomial genPolynomial2 = genPolynomialRing.getONECoefficient();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Monomial<C> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            Object c = monomial.c;
            GenPolynomial<C> genPolynomial3 = genPolynomial2.multiply(c);
            sortedMap.put(expVector, genPolynomial3);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> toRecursive(GenSolvablePolynomialRing<GenPolynomial<C>> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomialRing.getZERO()).copy();
        if (genSolvablePolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial2 = (GenPolynomial)genSolvablePolynomialRing.getONECoefficient();
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        for (Monomial monomial : genSolvablePolynomial) {
            ExpVector expVector = monomial.e;
            Object c = monomial.c;
            GenPolynomial genPolynomial3 = genPolynomial2.multiply(c);
            sortedMap.put(expVector, genPolynomial3);
        }
        return genPolynomial;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseRemainderPoly(GenPolynomial<C> genPolynomial, C c) {
        if (c == null || c.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + c);
        }
        Element element = ((GenPolynomial)genPolynomial.ring.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            C c2 = ringElem.remainder(c);
            sortedMap.put(expVector, c2);
        }
        return element;
    }

    @Deprecated
    public static <C extends RingElem<C>> GenPolynomial<C> basePseudoRemainder(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        return PolyUtil.baseSparsePseudoRemainder(genPolynomial, genPolynomial2);
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseSparsePseudoRemainder(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial.toString() + " division by zero " + genPolynomial2);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isConstant()) {
            return genPolynomial.ring.getZERO();
        }
        C c = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial<Object> genPolynomial3 = genPolynomial;
        while (!genPolynomial3.isZERO() && (expVector = genPolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial<Object> genPolynomial4;
            C c2 = genPolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            RingElem ringElem = (RingElem)c2.remainder(c);
            if (ringElem.isZERO()) {
                RingElem ringElem2 = (RingElem)c2.divide(c);
                genPolynomial4 = genPolynomial2.multiply(ringElem2, expVector);
            } else {
                genPolynomial3 = genPolynomial3.multiply(c);
                genPolynomial4 = genPolynomial2.multiply((RingElem)c2, expVector);
            }
            genPolynomial3 = genPolynomial3.subtract((C)genPolynomial4);
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDensePseudoRemainder(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isConstant()) {
            return genPolynomial.ring.getZERO();
        }
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        C c = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector = genPolynomial2.leadingExpVector();
        GenPolynomial<Object> genPolynomial3 = genPolynomial;
        for (long i = l; i >= l2; --i) {
            if (genPolynomial3.isZERO()) {
                return genPolynomial3;
            }
            long l3 = genPolynomial3.degree(0);
            if (i == l3) {
                ExpVector expVector2 = genPolynomial3.leadingExpVector();
                C c2 = genPolynomial3.leadingBaseCoefficient();
                expVector2 = expVector2.subtract(expVector);
                genPolynomial3 = genPolynomial3.multiply(c);
                GenPolynomial<C> genPolynomial4 = genPolynomial2.multiply(c2, expVector2);
                genPolynomial3 = genPolynomial3.subtract((C)genPolynomial4);
                continue;
            }
            genPolynomial3 = genPolynomial3.multiply(c);
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDensePseudoQuotient(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        C c = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector = genPolynomial2.leadingExpVector();
        GenPolynomial<C> genPolynomial3 = genPolynomial.ring.getZERO();
        GenPolynomial<Object> genPolynomial4 = genPolynomial;
        for (long i = l; i >= l2; --i) {
            if (genPolynomial4.isZERO()) {
                return genPolynomial3;
            }
            long l3 = genPolynomial4.degree(0);
            if (i == l3) {
                ExpVector expVector2 = genPolynomial4.leadingExpVector();
                C c2 = genPolynomial4.leadingBaseCoefficient();
                expVector2 = expVector2.subtract(expVector);
                genPolynomial4 = genPolynomial4.multiply(c);
                GenPolynomial<C> genPolynomial5 = genPolynomial2.multiply(c2, expVector2);
                genPolynomial4 = genPolynomial4.subtract((C)genPolynomial5);
                genPolynomial3 = genPolynomial3.multiply(c);
                genPolynomial3 = genPolynomial3.sum(c2, expVector2);
                continue;
            }
            genPolynomial3 = genPolynomial3.multiply(c);
            genPolynomial4 = genPolynomial4.multiply(c);
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> basePseudoDivide(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial.toString() + " division by zero " + genPolynomial2);
        }
        if (genPolynomial.isZERO() || genPolynomial2.isONE()) {
            return genPolynomial;
        }
        C c = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial<Object> genPolynomial3 = genPolynomial;
        GenPolynomial genPolynomial4 = ((GenPolynomial)genPolynomial2.ring.getZERO()).copy();
        while (!genPolynomial3.isZERO() && (expVector = genPolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial genPolynomial5;
            C c2 = genPolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            RingElem ringElem = (RingElem)c2.remainder(c);
            if (ringElem.isZERO()) {
                RingElem ringElem2 = (RingElem)c2.divide(c);
                genPolynomial4 = genPolynomial4.sum(ringElem2, expVector);
                genPolynomial5 = genPolynomial2.multiply(ringElem2, expVector);
            } else {
                genPolynomial4 = genPolynomial4.multiply(c);
                genPolynomial4 = genPolynomial4.sum(c2, expVector);
                genPolynomial3 = genPolynomial3.multiply(c);
                genPolynomial5 = genPolynomial2.multiply((RingElem)c2, expVector);
            }
            genPolynomial3 = genPolynomial3.subtract((C)genPolynomial5);
        }
        return genPolynomial4;
    }

    public static <C extends RingElem<C>> GenPolynomial<C>[] basePseudoQuotientRemainder(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial.toString() + " division by zero " + genPolynomial2);
        }
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{null, null};
        if (genPolynomial.isZERO() || genPolynomial2.isONE()) {
            genPolynomialArray[0] = genPolynomial;
            genPolynomialArray[1] = genPolynomial2.ring.getZERO();
            return genPolynomialArray;
        }
        C c = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial<Object> genPolynomial3 = genPolynomial;
        GenPolynomial genPolynomial4 = ((GenPolynomial)genPolynomial2.ring.getZERO()).copy();
        while (!genPolynomial3.isZERO() && (expVector = genPolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial genPolynomial5;
            C c2 = genPolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            RingElem ringElem = (RingElem)c2.remainder(c);
            if (ringElem.isZERO()) {
                RingElem ringElem2 = (RingElem)c2.divide(c);
                genPolynomial4 = genPolynomial4.sum(ringElem2, expVector);
                genPolynomial5 = genPolynomial2.multiply(ringElem2, expVector);
            } else {
                genPolynomial4 = genPolynomial4.multiply(c);
                genPolynomial4 = genPolynomial4.sum(c2, expVector);
                genPolynomial3 = genPolynomial3.multiply(c);
                genPolynomial5 = genPolynomial2.multiply((RingElem)c2, expVector);
            }
            genPolynomial3 = genPolynomial3.subtract((C)genPolynomial5);
        }
        genPolynomialArray[0] = genPolynomial4;
        genPolynomialArray[1] = genPolynomial3;
        return genPolynomialArray;
    }

    public static <C extends RingElem<C>> boolean isBasePseudoQuotientRemainder(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3, GenPolynomial<C> genPolynomial4) {
        GenPolynomial<GenPolynomial<RingElem>> genPolynomial5 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial2).sum((GenPolynomial<GenPolynomial<C>>)genPolynomial4);
        GenPolynomial<Object> genPolynomial6 = genPolynomial;
        C c = genPolynomial2.leadingBaseCoefficient();
        long l = genPolynomial.degree(0) - genPolynomial2.degree(0) + 1L;
        l = l > 0L ? l : -l + 2L;
        for (long i = 0L; i <= l; ++i) {
            if (genPolynomial6.equals(genPolynomial5) || ((GenPolynomial)genPolynomial6.negate()).equals(genPolynomial5)) {
                return true;
            }
            genPolynomial6 = genPolynomial6.multiply(c);
        }
        GenPolynomial<GenPolynomial<RingElem>> genPolynomial7 = genPolynomial;
        genPolynomial5 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial2);
        for (long i = 0L; i <= l; ++i) {
            genPolynomial6 = genPolynomial7.subtract((GenPolynomial<RingElem>)genPolynomial4);
            if (genPolynomial6.equals(genPolynomial5) || ((GenPolynomial)genPolynomial6.negate()).equals(genPolynomial5)) {
                return true;
            }
            genPolynomial7 = genPolynomial7.multiply((GenPolynomial<RingElem>)c);
        }
        GenPolynomial<C> genPolynomial8 = genPolynomial.leadingBaseCoefficient();
        genPolynomial5 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial2).sum((GenPolynomial<GenPolynomial<C>>)genPolynomial4);
        GenPolynomial<C> genPolynomial9 = genPolynomial5.leadingBaseCoefficient();
        GenPolynomial<C> genPolynomial10 = genPolynomial8.gcd((C)genPolynomial9);
        RingElem ringElem = genPolynomial8.multiply((C)genPolynomial9);
        RingElem ringElem2 = ringElem.divide(genPolynomial10);
        RingElem ringElem3 = (RingElem)ringElem2.divide(genPolynomial8);
        RingElem ringElem4 = ringElem2.divide(genPolynomial9);
        return genPolynomial.multiply((GenPolynomial<RingElem>)ringElem3).equals(genPolynomial5.multiply((GenPolynomial<RingElem>)ringElem4));
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDivide(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException("division by zero " + genPolynomial + ", " + genPolynomial2);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial;
        }
        Element element = ((GenPolynomial)genPolynomial.ring.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            GenPolynomial<C> genPolynomial3 = entry.getValue();
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial4 = PolyUtil.basePseudoDivide(genPolynomial3, genPolynomial2);
            if (!genPolynomial4.isZERO()) {
                sortedMap.put(expVector, genPolynomial4);
                continue;
            }
            System.out.println("rDiv, P  = " + genPolynomial);
            System.out.println("rDiv, c1 = " + genPolynomial3);
            System.out.println("rDiv, s  = " + genPolynomial2);
            System.out.println("rDiv, c  = " + genPolynomial4);
            throw new RuntimeException("something is wrong");
        }
        return element;
    }

    public static <C extends RingElem<C>> GenWordPolynomial<GenPolynomial<C>> recursiveDivide(GenWordPolynomial<GenPolynomial<C>> genWordPolynomial, GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new ArithmeticException("division by zero " + genWordPolynomial + ", " + genPolynomial);
        }
        if (genWordPolynomial.isZERO()) {
            return genWordPolynomial;
        }
        if (genPolynomial.isONE()) {
            return genWordPolynomial;
        }
        Element element = ((GenWordPolynomial)genWordPolynomial.ring.getZERO()).copy();
        SortedMap sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, GenPolynomial<C>> entry : genWordPolynomial.getMap().entrySet()) {
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            Word word = entry.getKey();
            GenPolynomial<C> genPolynomial3 = PolyUtil.basePseudoDivide(genPolynomial2, genPolynomial);
            if (!genPolynomial3.isZERO()) {
                sortedMap.put(word, genPolynomial3);
                continue;
            }
            System.out.println("rDiv, P  = " + genWordPolynomial);
            System.out.println("rDiv, c1 = " + genPolynomial2);
            System.out.println("rDiv, s  = " + genPolynomial);
            System.out.println("rDiv, c  = " + genPolynomial3);
            throw new RuntimeException("something is wrong");
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> baseRecursiveDivide(GenPolynomial<GenPolynomial<C>> genPolynomial, C c) {
        if (c == null || c.isZERO()) {
            throw new ArithmeticException("division by zero " + genPolynomial + ", " + c);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (c.isONE()) {
            return genPolynomial;
        }
        Element element = ((GenPolynomial)genPolynomial.ring.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial3 = PolyUtil.coefficientBasePseudoDivide(genPolynomial2, c);
            if (!genPolynomial3.isZERO()) {
                sortedMap.put(expVector, genPolynomial3);
                continue;
            }
            System.out.println("pu, c1 = " + genPolynomial2);
            System.out.println("pu, s  = " + c);
            System.out.println("pu, c  = " + genPolynomial3);
            throw new RuntimeException("something is wrong");
        }
        return element;
    }

    @Deprecated
    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursivePseudoRemainder(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        return PolyUtil.recursiveSparsePseudoRemainder(genPolynomial, genPolynomial2);
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveSparsePseudoRemainder(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isConstant()) {
            return genPolynomial.ring.getZERO();
        }
        GenPolynomial<C> genPolynomial3 = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial4 = genPolynomial;
        while (!genPolynomial4.isZERO() && (expVector = genPolynomial4.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial<GenPolynomial<C>> genPolynomial5;
            GenPolynomial<C> genPolynomial6 = genPolynomial4.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenPolynomial<C> genPolynomial7 = genPolynomial3;
            if (genPolynomial7.isZERO()) {
                GenPolynomial<C> genPolynomial8 = PolyUtil.basePseudoDivide(genPolynomial6, genPolynomial3);
                genPolynomial5 = genPolynomial2.multiply(genPolynomial8, expVector);
            } else {
                genPolynomial4 = genPolynomial4.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
                genPolynomial5 = genPolynomial2.multiply(genPolynomial6, expVector);
            }
            genPolynomial4 = genPolynomial4.subtract(genPolynomial5);
        }
        return genPolynomial4;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDensePseudoRemainder(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isConstant()) {
            return genPolynomial.ring.getZERO();
        }
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        GenPolynomial<C> genPolynomial3 = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector = genPolynomial2.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial4 = genPolynomial;
        for (long i = l; i >= l2; --i) {
            if (genPolynomial4.isZERO()) {
                return genPolynomial4;
            }
            long l3 = genPolynomial4.degree(0);
            if (i == l3) {
                ExpVector expVector2 = genPolynomial4.leadingExpVector();
                GenPolynomial<C> genPolynomial5 = genPolynomial4.leadingBaseCoefficient();
                expVector2 = expVector2.subtract(expVector);
                genPolynomial4 = genPolynomial4.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
                GenPolynomial<GenPolynomial<C>> genPolynomial6 = genPolynomial2.multiply(genPolynomial5, expVector2);
                genPolynomial4 = genPolynomial4.subtract(genPolynomial6);
                continue;
            }
            genPolynomial4 = genPolynomial4.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
        }
        return genPolynomial4;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursivePseudoDivide(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial;
        }
        GenPolynomial<C> genPolynomial3 = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial4 = genPolynomial;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial5 = ((GenPolynomial)genPolynomial2.ring.getZERO()).copy();
        while (!genPolynomial4.isZERO() && (expVector = genPolynomial4.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial<GenPolynomial<C>> genPolynomial6;
            GenPolynomial<C> genPolynomial7 = genPolynomial4.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenPolynomial<C> genPolynomial8 = PolyUtil.baseSparsePseudoRemainder(genPolynomial7, genPolynomial3);
            if (genPolynomial8.isZERO() && !genPolynomial3.isConstant()) {
                GenPolynomial<C> genPolynomial9 = PolyUtil.basePseudoDivide(genPolynomial7, genPolynomial3);
                genPolynomial5 = genPolynomial5.sum(genPolynomial9, expVector);
                genPolynomial6 = genPolynomial2.multiply(genPolynomial9, expVector);
            } else {
                genPolynomial5 = genPolynomial5.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial3);
                genPolynomial5 = genPolynomial5.sum(genPolynomial7, expVector);
                genPolynomial4 = genPolynomial4.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
                genPolynomial6 = genPolynomial2.multiply(genPolynomial7, expVector);
            }
            genPolynomial4 = genPolynomial4.subtract(genPolynomial6);
        }
        return genPolynomial5;
    }

    public static <C extends RingElem<C>> boolean isRecursivePseudoQuotientRemainder(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2, GenPolynomial<GenPolynomial<C>> genPolynomial3, GenPolynomial<GenPolynomial<C>> genPolynomial4) {
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> genPolynomial5 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>>)genPolynomial2).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)genPolynomial4);
        GenPolynomial<GenPolynomial<Object>> genPolynomial6 = genPolynomial;
        GenPolynomial<C> genPolynomial7 = genPolynomial2.leadingBaseCoefficient();
        long l = genPolynomial.degree(0) - genPolynomial2.degree(0) + 1L;
        l = l > 0L ? l : -l + 2L;
        for (long i = 0L; i <= l; ++i) {
            if (genPolynomial6.equals(genPolynomial5)) {
                return true;
            }
            genPolynomial6 = genPolynomial6.multiply((GenPolynomial<Object>)genPolynomial7);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>> genPolynomial8 = genPolynomial;
        genPolynomial5 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>>)genPolynomial2);
        for (long i = 0L; i <= l; ++i) {
            genPolynomial6 = genPolynomial8.subtract((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)genPolynomial4);
            if (genPolynomial6.equals(genPolynomial5)) {
                return true;
            }
            genPolynomial8 = genPolynomial8.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)genPolynomial7);
        }
        GenPolynomial<C> genPolynomial9 = genPolynomial.leadingBaseCoefficient();
        genPolynomial5 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>>)genPolynomial2).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)genPolynomial4);
        GenPolynomial<GenPolynomial<C>> genPolynomial10 = genPolynomial5.leadingBaseCoefficient();
        return genPolynomial.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)genPolynomial10).equals(genPolynomial5.multiply((GenPolynomial<GenPolynomial<GenPolynomial<Object>>>)((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial9)));
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> coefficientPseudoDivide(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        Element element = ((GenPolynomial)genPolynomial.ring.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            GenPolynomial<C> genPolynomial3;
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial4 = entry.getValue();
            GenPolynomial<C> genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial2);
            if (debug && !(genPolynomial3 = genPolynomial4.remainder(genPolynomial2)).isZERO()) {
                logger.info("divide x = " + genPolynomial3);
                throw new ArithmeticException(" no exact division: " + genPolynomial4 + "/" + genPolynomial2);
            }
            if (genPolynomial5.isZERO()) {
                System.out.println(" no exact division: " + genPolynomial4 + "/" + genPolynomial2);
                continue;
            }
            sortedMap.put(expVector, genPolynomial5);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> coefficientBasePseudoDivide(GenPolynomial<C> genPolynomial, C c) {
        if (c == null || c.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + c);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        Element element = ((GenPolynomial)genPolynomial.ring.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            C c2;
            ExpVector expVector = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            C c3 = ringElem.divide(c);
            if (debug && !(c2 = ringElem.remainder(c)).isZERO()) {
                logger.info("divide x = " + c2);
                throw new ArithmeticException(" no exact division: " + ringElem + "/" + c);
            }
            if (c3.isZERO()) {
                System.out.println(" no exact division: " + ringElem + "/" + c);
                continue;
            }
            sortedMap.put(expVector, c3);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDeriviative(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            long l = expVector.getVal(0);
            if (l <= 0L) continue;
            RingElem ringElem = (RingElem)ringFactory.fromInteger(l);
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = ringElem2.multiply(ringElem);
            if (ringElem3 == null || ringElem3.isZERO()) continue;
            ExpVector expVector2 = ExpVector.create(1, 0, l - 1L);
            sortedMap.put(expVector2, ringElem3);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDeriviative(GenPolynomial<C> genPolynomial, int n) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (n < 0 || genPolynomialRing.nvar <= n) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " deriviative variable out of bound " + n);
        }
        int n2 = genPolynomialRing.nvar - 1 - n;
        RingFactory ringFactory = genPolynomialRing.coFac;
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            long l = expVector.getVal(n2);
            if (l <= 0L) continue;
            RingElem ringElem = (RingElem)ringFactory.fromInteger(l);
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = ringElem2.multiply(ringElem);
            if (ringElem3 == null || ringElem3.isZERO()) continue;
            ExpVector expVector2 = expVector.subst(n2, l - 1L);
            sortedMap.put(expVector2, ringElem3);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseIntegral(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            long l = expVector.getVal(0);
            RingElem ringElem = (RingElem)ringFactory.fromInteger(++l);
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = ringElem2.divide(ringElem);
            if (ringElem3 == null || ringElem3.isZERO()) continue;
            ExpVector expVector2 = ExpVector.create(1, 0, l);
            sortedMap.put(expVector2, ringElem3);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDeriviative(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        RingFactory ringFactory = genPolynomialRing2.coFac;
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            long l = expVector.getVal(0);
            if (l <= 0L) continue;
            RingElem ringElem = (RingElem)ringFactory.fromInteger(l);
            GenPolynomial<RingElem> genPolynomial2 = entry.getValue();
            GenPolynomial<RingElem> genPolynomial3 = genPolynomial2.multiply(ringElem);
            if (genPolynomial3 == null || genPolynomial3.isZERO()) continue;
            ExpVector expVector2 = ExpVector.create(1, 0, l - 1L);
            sortedMap.put(expVector2, genPolynomial3);
        }
        return element;
    }

    public static edu.jas.arith.BigInteger factorBound(ExpVector expVector) {
        BigInteger bigInteger;
        int n = 0;
        BigInteger bigInteger2 = BigInteger.ONE;
        if (expVector == null || expVector.isZERO()) {
            return edu.jas.arith.BigInteger.ONE;
        }
        for (int i = 0; i < expVector.length(); ++i) {
            if (expVector.getVal(i) <= 0L) continue;
            n = (int)((long)n + (2L * expVector.getVal(i) - 1L));
            bigInteger = new BigInteger("" + (expVector.getVal(i) - 1L));
            bigInteger2 = bigInteger2.multiply(bigInteger);
        }
        n += bigInteger2.bitCount() + 1;
        bigInteger = new BigInteger("2");
        bigInteger = bigInteger.shiftLeft(n /= 2);
        edu.jas.arith.BigInteger bigInteger3 = new edu.jas.arith.BigInteger(bigInteger);
        return bigInteger3;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateMainRecursive(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial, C c) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        if (genPolynomial.ring.nvar != 1) {
            throw new IllegalArgumentException("evaluateMain no univariate polynomial");
        }
        if (c == null || c.isZERO()) {
            return genPolynomial.trailingBaseCoefficient();
        }
        SortedMap<ExpVector, GenPolynomial<C>> sortedMap = genPolynomial.getMap();
        GenPolynomial<Object> genPolynomial2 = null;
        long l = -1L;
        long l2 = -1L;
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            l2 = expVector.getVal(0);
            if (genPolynomial2 == null) {
                genPolynomial2 = (GenPolynomial<C>)entry.getValue();
            } else {
                for (long i = l2; i < l; ++i) {
                    genPolynomial2 = genPolynomial2.multiply((Object)c);
                }
                genPolynomial2 = genPolynomial2.sum((Object)((GenPolynomial)entry.getValue()));
            }
            l = l2;
        }
        for (long i = 0L; i < l2; ++i) {
            genPolynomial2 = genPolynomial2.multiply((Object)c);
        }
        return genPolynomial2;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateMain(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, C c) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        GenPolynomialRing<GenPolynomial<C>> genPolynomialRing2 = new GenPolynomialRing<GenPolynomial<C>>(genPolynomialRing, 1);
        if (genPolynomialRing2.nvar + genPolynomialRing.nvar != genPolynomial.ring.nvar) {
            throw new IllegalArgumentException("evaluateMain number of variabes mismatch");
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        return PolyUtil.evaluateMainRecursive(genPolynomialRing, genPolynomial2, c);
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> evaluateMain(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, C c) {
        return ListUtil.map(list, new EvalMainPol<C>(genPolynomialRing, c));
    }

    public static <C extends RingElem<C>> C evaluateMain(RingFactory<C> ringFactory, GenPolynomial<C> genPolynomial, C c) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return (C)((RingElem)ringFactory.getZERO());
        }
        if (genPolynomial.ring.nvar != 1) {
            throw new IllegalArgumentException("evaluateMain no univariate polynomial");
        }
        if (c == null || c.isZERO()) {
            return genPolynomial.trailingBaseCoefficient();
        }
        SortedMap<ExpVector, C> sortedMap = genPolynomial.getMap();
        MonoidElem<AbelianGroupElem> monoidElem = null;
        long l = -1L;
        long l2 = -1L;
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            l2 = expVector.getVal(0);
            if (monoidElem == null) {
                monoidElem = (RingElem)entry.getValue();
            } else {
                for (long i = l2; i < l; ++i) {
                    monoidElem = (RingElem)monoidElem.multiply(c);
                }
                monoidElem = (RingElem)monoidElem.sum((AbelianGroupElem)entry.getValue());
            }
            l = l2;
        }
        for (long i = 0L; i < l2; ++i) {
            monoidElem = monoidElem.multiply(c);
        }
        return (C)monoidElem;
    }

    public static <C extends RingElem<C>> List<C> evaluateMain(RingFactory<C> ringFactory, List<GenPolynomial<C>> list, C c) {
        return ListUtil.map(list, new EvalMain<C>(ringFactory, c));
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluate(GenPolynomialRing<C> genPolynomialRing, GenPolynomialRing<GenPolynomial<C>> genPolynomialRing2, GenPolynomialRing<GenPolynomial<C>> genPolynomialRing3, GenPolynomialRing<C> genPolynomialRing4, GenPolynomial<C> genPolynomial, C c) {
        if (genPolynomialRing2.nvar != 1) {
            throw new IllegalArgumentException("evaluate coefficient ring not univariate");
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        Map<ExpVector, GenPolynomial<C>> map = genPolynomial.contract(genPolynomialRing);
        GenPolynomialRing genPolynomialRing5 = (GenPolynomialRing)genPolynomialRing2.coFac;
        Element element = ((GenPolynomial)genPolynomialRing3.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : map.entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            GenPolynomial<GenPolynomial<C>> genPolynomial3 = PolyUtil.recursive(genPolynomialRing2, genPolynomial2);
            GenPolynomial<C> genPolynomial4 = PolyUtil.evaluateMainRecursive(genPolynomialRing5, genPolynomial3, c);
            if (genPolynomial4 == null || genPolynomial4.isZERO()) continue;
            sortedMap.put(expVector, genPolynomial4);
        }
        GenPolynomial<C> genPolynomial5 = PolyUtil.distribute(genPolynomialRing4, element);
        return genPolynomial5;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateFirst(GenPolynomialRing<C> genPolynomialRing, GenPolynomialRing<C> genPolynomialRing2, GenPolynomial<C> genPolynomial, C c) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing2.getZERO();
        }
        Map<ExpVector, GenPolynomial<C>> map = genPolynomial.contract(genPolynomialRing);
        Element element = ((GenPolynomial)genPolynomialRing2.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : map.entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            Object c2 = PolyUtil.evaluateMain(genPolynomialRing.coFac, genPolynomial2, c);
            if (c2 == null || c2.isZERO()) continue;
            sortedMap.put(expVector, c2);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateFirstRec(GenPolynomialRing<C> genPolynomialRing, GenPolynomialRing<C> genPolynomialRing2, GenPolynomial<GenPolynomial<C>> genPolynomial, C c) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing2.getZERO();
        }
        SortedMap<ExpVector, GenPolynomial<C>> sortedMap = genPolynomial.getMap();
        Element element = ((GenPolynomial)genPolynomialRing2.getZERO()).copy();
        SortedMap sortedMap2 = ((GenPolynomial)element).val;
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getValue();
            Object c2 = PolyUtil.evaluateMain(genPolynomialRing.coFac, genPolynomial2, c);
            if (c2 == null || c2.isZERO()) continue;
            sortedMap2.put(expVector, c2);
        }
        return element;
    }

    @Deprecated
    public static <C extends RingElem<C>> C evaluateAll(RingFactory<C> ringFactory, GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, List<C> list) {
        return PolyUtil.evaluateAll(ringFactory, genPolynomial, list);
    }

    public static <C extends RingElem<C>> C evaluateAll(RingFactory<C> ringFactory, GenPolynomial<C> genPolynomial, List<C> list) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return (C)((RingElem)ringFactory.getZERO());
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (list == null || list.size() != genPolynomialRing.nvar) {
            throw new IllegalArgumentException("evaluate tuple size not equal to number of variables");
        }
        if (genPolynomialRing.nvar == 0) {
            return genPolynomial.trailingBaseCoefficient();
        }
        if (genPolynomialRing.nvar == 1) {
            return (C)PolyUtil.evaluateMain(ringFactory, genPolynomial, (RingElem)list.get(0));
        }
        RingElem ringElem = (RingElem)ringFactory.getZERO();
        GenPolynomial<Object> genPolynomial2 = genPolynomial;
        for (int i = 0; i < genPolynomialRing.nvar - 1; ++i) {
            GenPolynomialRing<C> genPolynomialRing2 = new GenPolynomialRing<C>(ringFactory, 1);
            GenPolynomialRing<C> genPolynomialRing3 = new GenPolynomialRing<C>(ringFactory, genPolynomialRing.nvar - 1 - i);
            RingElem ringElem2 = (RingElem)list.get(i);
            GenPolynomial<RingElem> genPolynomial3 = PolyUtil.evaluateFirst(genPolynomialRing2, genPolynomialRing3, genPolynomial2, ringElem2);
            if (genPolynomial3.isZERO()) {
                return (C)ringElem;
            }
            genPolynomial2 = genPolynomial3;
        }
        RingElem ringElem3 = (RingElem)list.get(genPolynomialRing.nvar - 1);
        ringElem = PolyUtil.evaluateMain(ringFactory, genPolynomial2, ringElem3);
        return (C)ringElem;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> substituteMain(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        return PolyUtil.substituteUnivariate(genPolynomial, genPolynomial2);
    }

    public static <C extends RingElem<C>> GenPolynomial<C> substituteUnivariate(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial == null || genPolynomial2 == null) {
            return null;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomial f");
        }
        if (genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return genPolynomial;
        }
        if (genPolynomial2.ring.nvar > 1) {
            genPolynomialRing = genPolynomial2.ring;
        }
        SortedMap<ExpVector, C> sortedMap = genPolynomial.getMap();
        GenPolynomial<RingElem<GenPolynomial<RingElem>>> genPolynomial3 = null;
        long l = -1L;
        long l2 = -1L;
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            l2 = expVector.getVal(0);
            if (genPolynomial3 == null) {
                genPolynomial3 = ((GenPolynomial)genPolynomialRing.getZERO()).sum((RingElem)entry.getValue());
            } else {
                for (long i = l2; i < l; ++i) {
                    genPolynomial3 = genPolynomial3.multiply((RingElem<GenPolynomial<RingElem>>)genPolynomial2);
                }
                genPolynomial3 = genPolynomial3.sum((RingElem)entry.getValue());
            }
            l = l2;
        }
        for (long i = 0L; i < l2; ++i) {
            genPolynomial3 = genPolynomial3.multiply((RingElem<GenPolynomial<RingElem>>)genPolynomial2);
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> seriesOfTaylor(GenPolynomial<C> genPolynomial, C c) {
        if (genPolynomial == null) {
            return null;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO();
        Object c2 = PolyUtil.evaluateMain(genPolynomialRing.coFac, genPolynomial, c);
        genPolynomial2 = genPolynomial2.sum(c2);
        long l = 1L;
        long l2 = 0L;
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial);
        while (!genPolynomial3.isZERO()) {
            c2 = PolyUtil.evaluateMain(genPolynomialRing.coFac, genPolynomial3, c);
            GenPolynomial genPolynomial4 = genPolynomialRing.univariate(0, l2);
            genPolynomial4 = genPolynomial4.multiply(c2);
            genPolynomial4 = genPolynomial4.divide(genPolynomialRing.fromInteger(l *= ++l2));
            genPolynomial2 = genPolynomial2.sum(genPolynomial4);
            genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial3);
        }
        return genPolynomial2;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> interpolate(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<C> genPolynomial2, C c, GenPolynomial<C> genPolynomial3, C c2) {
        RingElem ringElem;
        ExpVector expVector;
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        Element element2 = genPolynomial.copy();
        SortedMap sortedMap = ((GenPolynomial)element2).val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial3.getMap();
        SortedMap sortedMap3 = ((GenPolynomial)element).val;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        RingFactory ringFactory = genPolynomialRing2.coFac;
        GenPolynomial<RingElem> genPolynomial4 = null;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            expVector = entry.getKey();
            ringElem = (RingElem)entry.getValue();
            GenPolynomial genPolynomial5 = (GenPolynomial)sortedMap.get(expVector);
            if (genPolynomial5 != null) {
                sortedMap.remove(expVector);
                genPolynomial4 = PolyUtil.interpolate(genPolynomialRing2, genPolynomial5, genPolynomial2, c, ringElem, c2);
                if (genPolynomial4.isZERO()) continue;
                sortedMap3.put(expVector, genPolynomial4);
                continue;
            }
            genPolynomial4 = PolyUtil.interpolate(genPolynomialRing2, genPolynomialRing2.getZERO(), genPolynomial2, c, ringElem, c2);
            if (genPolynomial4.isZERO()) continue;
            sortedMap3.put(expVector, genPolynomial4);
        }
        for (Map.Entry<ExpVector, C> entry : sortedMap.entrySet()) {
            expVector = entry.getKey();
            ringElem = (GenPolynomial)entry.getValue();
            genPolynomial4 = PolyUtil.interpolate(genPolynomialRing2, ringElem, genPolynomial2, c, (RingElem)ringFactory.getZERO(), c2);
            if (genPolynomial4.isZERO()) continue;
            sortedMap3.put(expVector, genPolynomial4);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> interpolate(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, C c, C object, C c2) {
        Object c3 = PolyUtil.evaluateMain(genPolynomialRing.coFac, genPolynomial, c2);
        RingElem ringElem = (RingElem)object.subtract(c3);
        if (ringElem.isZERO()) {
            return genPolynomial;
        }
        c3 = ringElem.multiply(c);
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = genPolynomial2.multiply(c3);
        genPolynomial3 = genPolynomial3.sum(genPolynomial);
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> switchVariables(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2.coFac, genPolynomialRing);
        AbelianGroupElem abelianGroupElem = genPolynomialRing3.getZERO();
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing3, genPolynomialRing2);
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing4.getZERO()).copy();
        if (genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        for (Monomial<GenPolynomial<C>> monomial : genPolynomial) {
            GenPolynomial genPolynomial3 = (GenPolynomial)monomial.c;
            for (Monomial monomial2 : genPolynomial3) {
                GenPolynomial genPolynomial4 = ((GenPolynomial)abelianGroupElem).sum(monomial2.c, monomial.e);
                genPolynomial2 = genPolynomial2.sum(genPolynomial4, monomial2.e);
            }
        }
        return genPolynomial2;
    }

    public static <C extends RingElem<C>> long totalDegreeLeadingTerm(List<GenPolynomial<C>> list) {
        long l = 0L;
        for (GenPolynomial<C> genPolynomial : list) {
            long l2 = genPolynomial.leadingExpVector().totalDeg();
            if (l >= l2) continue;
            l = l2;
        }
        return l;
    }

    public static <C extends RingElem<C>> long totalDegree(List<GenPolynomial<C>> list) {
        long l = 0L;
        for (GenPolynomial<C> genPolynomial : list) {
            long l2 = genPolynomial.totalDegree();
            if (l >= l2) continue;
            l = l2;
        }
        return l;
    }

    public static <C extends RingElem<C>> long maxDegree(List<GenPolynomial<C>> list) {
        long l = 0L;
        for (GenPolynomial<C> genPolynomial : list) {
            long l2 = genPolynomial.degree();
            if (l >= l2) continue;
            l = l2;
        }
        return l;
    }

    public static <C extends RingElem<C>> long coeffMaxDegree(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial.isZERO()) {
            return 0L;
        }
        long l = 0L;
        for (GenPolynomial<C> genPolynomial2 : genPolynomial.getMap().values()) {
            long l2 = genPolynomial2.degree();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public static <C extends RingElem<C>, D extends RingElem<D>> GenPolynomial<D> map(GenPolynomialRing<D> genPolynomialRing, GenPolynomial<C> genPolynomial, UnaryFunctor<C, D> unaryFunctor) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Monomial<C> monomial : genPolynomial) {
            RingElem ringElem = (RingElem)unaryFunctor.eval(monomial.c);
            if (ringElem == null || ringElem.isZERO()) continue;
            sortedMap.put(monomial.e, ringElem);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<C>>> toProductGen(GenPolynomialRing<Product<C>> genPolynomialRing, List<GenPolynomial<C>> list) {
        ArrayList<GenPolynomial<Product<C>>> arrayList = new ArrayList<GenPolynomial<Product<C>>>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            GenPolynomial<Product<C>> genPolynomial2 = PolyUtil.toProductGen(genPolynomialRing, genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Product<C>> toProductGen(GenPolynomialRing<Product<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        ProductRing productRing = (ProductRing)ringFactory;
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GcdRingElem gcdRingElem = (GcdRingElem)entry.getValue();
            Product<GcdRingElem> product = PolyUtil.toProductGen(productRing, gcdRingElem);
            if (product.isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, product);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> Product<C> toProductGen(ProductRing<C> productRing, C c) {
        TreeMap<Integer, C> treeMap = new TreeMap<Integer, C>();
        for (int i = 0; i < productRing.length(); ++i) {
            RingFactory<C> ringFactory = productRing.getFactory(i);
            C c2 = ringFactory.copy(c);
            if (c2 == null || c2.isZERO()) continue;
            treeMap.put(i, c2);
        }
        return new Product<C>(productRing, treeMap);
    }

    public static <C extends RingElem<C>> Product<GenPolynomial<C>> toProduct(ProductRing<GenPolynomial<C>> productRing, C c, ExpVector expVector) {
        TreeMap<Integer, GenPolynomial<C>> treeMap = new TreeMap<Integer, GenPolynomial<C>>();
        for (int i = 0; i < expVector.length(); ++i) {
            RingFactory<GenPolynomial<C>> ringFactory = productRing.getFactory(i);
            GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ringFactory;
            long l = expVector.getVal(i);
            GenPolynomial<C> genPolynomial = l == 0L ? genPolynomialRing.getONE() : genPolynomialRing.univariate(0, l);
            genPolynomial = genPolynomial.multiply(c);
            treeMap.put(i, genPolynomial);
        }
        return new Product<GenPolynomial<C>>(productRing, treeMap);
    }

    public static <C extends RingElem<C>> Product<GenPolynomial<C>> toProduct(ProductRing<GenPolynomial<C>> productRing, GenPolynomial<C> genPolynomial) {
        Product<GenPolynomial<RingElem>> product = productRing.getZERO();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return product;
        }
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            Product<GenPolynomial<RingElem>> product2 = PolyUtil.toProduct(productRing, ringElem, expVector);
            product = product.sum(product2);
        }
        return product;
    }

    public static Product<ModInteger> toProduct(ProductRing<ModInteger> productRing, edu.jas.arith.BigInteger bigInteger) {
        TreeMap<Integer, ModInteger> treeMap = new TreeMap<Integer, ModInteger>();
        for (int i = 0; i < productRing.length(); ++i) {
            RingFactory<ModInteger> ringFactory = productRing.getFactory(i);
            ModIntegerRing modIntegerRing = (ModIntegerRing)ringFactory;
            ModInteger modInteger = modIntegerRing.fromInteger(bigInteger.getVal());
            if (modInteger.isZERO()) continue;
            treeMap.put(i, modInteger);
        }
        return new Product<ModInteger>(productRing, treeMap);
    }

    public static GenPolynomial<Product<ModInteger>> toProduct(GenPolynomialRing<Product<ModInteger>> genPolynomialRing, GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        ProductRing productRing = (ProductRing)ringFactory;
        for (Map.Entry<ExpVector, edu.jas.arith.BigInteger> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            edu.jas.arith.BigInteger bigInteger = entry.getValue();
            Product<ModInteger> product = PolyUtil.toProduct(productRing, bigInteger);
            if (product.isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, product);
        }
        return element;
    }

    public static List<GenPolynomial<Product<ModInteger>>> toProduct(GenPolynomialRing<Product<ModInteger>> genPolynomialRing, List<GenPolynomial<edu.jas.arith.BigInteger>> list) {
        ArrayList<GenPolynomial<Product<ModInteger>>> arrayList = new ArrayList<GenPolynomial<Product<ModInteger>>>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        for (GenPolynomial<edu.jas.arith.BigInteger> genPolynomial : list) {
            GenPolynomial<Product<ModInteger>> genPolynomial2 = PolyUtil.toProduct(genPolynomialRing, genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> intersect(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        GenPolynomialRing genPolynomialRing2 = list.get((int)0).ring;
        int n = genPolynomialRing2.nvar - genPolynomialRing.nvar;
        if (n <= 0) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            Map<ExpVector, GenPolynomial<C>> map = null;
            map = genPolynomial.contract(genPolynomialRing);
            if (logger.isDebugEnabled()) {
                logger.debug("intersect contract m = " + map);
            }
            if (map.size() != 1) continue;
            for (Map.Entry<ExpVector, GenPolynomial<C>> entry : map.entrySet()) {
                ExpVector expVector = entry.getKey();
                if (!expVector.isZERO()) continue;
                arrayList.add(entry.getValue());
            }
        }
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.contract(n);
        if (genPolynomialRing3.equals(genPolynomialRing)) {
            return arrayList;
        }
        logger.warn("tfac != R: tfac = " + genPolynomialRing3.toScript() + ", R = " + genPolynomialRing.toScript() + ", pfac = " + genPolynomialRing2.toScript());
        return arrayList;
    }

    public static <C extends RingElem<C>> List<GenSolvablePolynomial<C>> intersect(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = PolynomialList.castToList(list);
        GenSolvablePolynomialRing<C> genSolvablePolynomialRing2 = genSolvablePolynomialRing;
        List<GenPolynomial<C>> list3 = PolyUtil.intersect(genSolvablePolynomialRing2, list2);
        return PolynomialList.castToSolvableList(list3);
    }

    public static <C extends RingElem<C>> GenPolynomial<C> removeUnusedUpperVariables(GenPolynomial<C> genPolynomial) {
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return genPolynomial;
        }
        int[] nArray = genPolynomial.degreeVector().dependencyOnVariables();
        if (genPolynomialRing.nvar == nArray.length) {
            return genPolynomial;
        }
        if (nArray.length == 0) {
            GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing.coFac, 0);
            GenPolynomial genPolynomial2 = new GenPolynomial(genPolynomialRing2, genPolynomial.leadingBaseCoefficient());
            return genPolynomial2;
        }
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        if (n == 0) {
            return genPolynomial;
        }
        int n3 = n;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing.contract(n3);
        Map<ExpVector, GenPolynomial<C>> map = genPolynomial.contract(genPolynomialRing3);
        if (map.size() != 1) {
            System.out.println("upper ex, l = " + n + ", r = " + n2 + ", p = " + genPolynomial + ", fac = " + genPolynomialRing.toScript());
            throw new RuntimeException("this should not happen " + map);
        }
        GenPolynomial<C> genPolynomial3 = map.values().iterator().next();
        n3 = genPolynomialRing.nvar - 1 - n2;
        if (n3 == 0) {
            return genPolynomial3;
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> removeUnusedLowerVariables(GenPolynomial<C> genPolynomial) {
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return genPolynomial;
        }
        int[] nArray = genPolynomial.degreeVector().dependencyOnVariables();
        if (genPolynomialRing.nvar == nArray.length) {
            return genPolynomial;
        }
        if (nArray.length == 0) {
            GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing.coFac, 0);
            GenPolynomial genPolynomial2 = new GenPolynomial(genPolynomialRing2, genPolynomial.leadingBaseCoefficient());
            return genPolynomial2;
        }
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        if (n2 == genPolynomialRing.nvar - 1) {
            return genPolynomial;
        }
        int n3 = n2 + 1;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing.recursive(n3);
        GenPolynomial genPolynomial3 = PolyUtil.recursive(genPolynomialRing3, genPolynomial);
        if (genPolynomial3.length() != genPolynomial.length()) {
            System.out.println("lower ex, l = " + n + ", r = " + n2 + ", p = " + genPolynomial + ", fac = " + genPolynomialRing.toScript());
            throw new RuntimeException("this should not happen " + genPolynomial3);
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(ringFactory, genPolynomialRing3);
        Element element = ((GenPolynomial)genPolynomialRing4.getZERO()).copy();
        for (Monomial monomial : genPolynomial3) {
            ExpVector expVector = monomial.e;
            GenPolynomial genPolynomial4 = (GenPolynomial)monomial.c;
            if (!genPolynomial4.isConstant()) {
                throw new RuntimeException("this can not happen " + genPolynomial4);
            }
            Object c = genPolynomial4.leadingBaseCoefficient();
            ((GenPolynomial)element).doPutToMap(expVector, c);
        }
        return element;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> removeUnusedMiddleVariables(GenPolynomial<C> genPolynomial) {
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 2) {
            return genPolynomial;
        }
        int[] nArray = genPolynomial.degreeVector().dependencyOnVariables();
        if (genPolynomialRing.nvar == nArray.length) {
            return genPolynomial;
        }
        if (nArray.length == 0) {
            GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing.coFac, 0);
            GenPolynomial genPolynomial2 = new GenPolynomial(genPolynomialRing2, genPolynomial.leadingBaseCoefficient());
            return genPolynomial2;
        }
        ExpVector expVector = genPolynomial.leadingExpVector();
        if (nArray.length == 1) {
            TermOrder termOrder = new TermOrder(genPolynomialRing.tord.getEvord());
            int n = nArray[0];
            String string = expVector.indexVarName(n, genPolynomialRing.getVars());
            String[] stringArray = new String[]{string};
            GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing.coFac, termOrder, stringArray);
            Element element = ((GenPolynomial)genPolynomialRing3.getZERO()).copy();
            for (Monomial<C> monomial : genPolynomial) {
                ExpVector expVector2 = monomial.e;
                ExpVector expVector3 = ExpVector.create(1, 0, expVector2.getVal(n));
                ((GenPolynomial)element).doPutToMap(expVector3, monomial.c);
            }
            return element;
        }
        GenPolynomialRing genPolynomialRing4 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial3 = PolyUtil.recursive(genPolynomialRing4, genPolynomial);
        int n = nArray[0];
        int n2 = genPolynomialRing.nvar - nArray[1];
        TermOrder termOrder = new TermOrder(genPolynomialRing.tord.getEvord());
        String[] stringArray = genPolynomialRing.getVars();
        String[] stringArray2 = new String[n2 + 1];
        for (int i = 0; i < n2; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n2] = expVector.indexVarName(n, stringArray);
        GenPolynomialRing genPolynomialRing5 = new GenPolynomialRing(genPolynomialRing.coFac, termOrder, stringArray2);
        GenPolynomialRing genPolynomialRing6 = genPolynomialRing5.recursive(1);
        GenPolynomialRing genPolynomialRing7 = (GenPolynomialRing)genPolynomialRing6.coFac;
        Element element = ((GenPolynomial)genPolynomialRing6.getZERO()).copy();
        for (Monomial monomial : genPolynomial3) {
            ExpVector expVector4 = monomial.e;
            GenPolynomial genPolynomial4 = (GenPolynomial)monomial.c;
            Map map = genPolynomial4.contract(genPolynomialRing7);
            for (Map.Entry entry : map.entrySet()) {
                ExpVector expVector5 = entry.getKey();
                if (expVector5.isZERO()) {
                    GenPolynomial genPolynomial5 = entry.getValue();
                    ((GenPolynomial)element).doPutToMap(expVector4, genPolynomial5);
                    continue;
                }
                throw new RuntimeException("this should not happen " + map);
            }
        }
        GenPolynomial genPolynomial6 = PolyUtil.distribute(genPolynomialRing5, element);
        return genPolynomial6;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> selectWithVariable(List<GenPolynomial<C>> list, int n) {
        for (GenPolynomial<C> genPolynomial : list) {
            int[] nArray = genPolynomial.leadingExpVector().dependencyOnVariables();
            if (nArray.length != 1 || nArray[0] != n) continue;
            return genPolynomial;
        }
        return null;
    }
}

