/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBHybridExerClient;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.HybridReducerClientEC;
import edu.jas.gb.HybridReducerServerEC;
import edu.jas.gb.MiReducerServer;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import edu.jas.util.DistThreadPool;
import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseDistributedHybridEC<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    public static final Logger logger = Logger.getLogger(GroebnerBaseDistributedHybridEC.class);
    public final boolean debug = logger.isDebugEnabled();
    protected final int threads;
    protected static final int DEFAULT_THREADS = 2;
    protected final int threadsPerNode;
    protected static final int DEFAULT_THREADS_PER_NODE = 1;
    protected final transient ThreadPool pool;
    protected static final int DEFAULT_PORT = 55711;
    protected final int DHT_PORT;
    protected final String mfile;
    protected final int port;
    private final transient DistThreadPool dtp;
    private final transient DistHashTableServer<Integer> dhts;
    public static final Integer pairTag = 1;
    public static final Integer resultTag = 2;
    public static final Integer ackTag = 3;

    public GroebnerBaseDistributedHybridEC(String string) {
        this(string, 2, 55711);
    }

    public GroebnerBaseDistributedHybridEC(String string, int n) {
        this(string, n, new ThreadPool(n), 55711);
    }

    public GroebnerBaseDistributedHybridEC(String string, int n, int n2) {
        this(string, n, new ThreadPool(n), n2);
    }

    public GroebnerBaseDistributedHybridEC(String string, int n, int n2, int n3) {
        this(string, n, n2, new ThreadPool(n), n3);
    }

    public GroebnerBaseDistributedHybridEC(String string, int n, ThreadPool threadPool, int n2) {
        this(string, n, 1, threadPool, n2);
    }

    public GroebnerBaseDistributedHybridEC(String string, int n, int n2, PairList<C> pairList, int n3) {
        this(string, n, n2, new ThreadPool(n), pairList, n3);
    }

    public GroebnerBaseDistributedHybridEC(String string, int n, int n2, ThreadPool threadPool, int n3) {
        this(string, n, n2, threadPool, new OrderedPairlist(), n3);
    }

    public GroebnerBaseDistributedHybridEC(String string, int n, int n2, ThreadPool threadPool, PairList<C> pairList, int n3) {
        super(new ReductionPar(), pairList);
        this.threads = n;
        this.mfile = string == null || string.length() == 0 ? "../util/machines" : string;
        if (n < 1) {
            n = 1;
        }
        this.threadsPerNode = n2;
        if (threadPool == null) {
            threadPool = new ThreadPool(n);
        }
        this.pool = threadPool;
        this.port = n3;
        logger.info("machine file " + string + ", port = " + n3);
        this.dtp = new DistThreadPool(this.threads, this.mfile);
        logger.info("running " + this.dtp);
        this.DHT_PORT = this.dtp.getEC().getMasterPort() + 100;
        this.dhts = new DistHashTableServer(this.DHT_PORT);
        this.dhts.init();
        logger.info("running " + this.dhts);
    }

    @Override
    public void terminate() {
        this.terminate(true);
    }

    public void terminate(boolean bl) {
        this.pool.terminate();
        this.dtp.terminate(bl);
        logger.debug("dhts.terminate()");
        this.dhts.terminate();
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.monic(list2)).size() <= 1) {
            return list2;
        }
        if (!list2.get((int)0).ring.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        String string = this.dtp.getEC().getMasterHost();
        GBHybridExerClient gBHybridExerClient = new GBHybridExerClient(string, this.threadsPerNode, this.port, this.DHT_PORT);
        for (int i = 0; i < this.threads; ++i) {
            this.dtp.addJob(gBHybridExerClient);
        }
        List<GenPolynomial<C>> list3 = this.GBMaster(n, list2);
        return list3;
    }

    List<GenPolynomial<C>> GBMaster(int n, List<GenPolynomial<C>> list) {
        int n2;
        GenPolynomial genPolynomial;
        long l = System.currentTimeMillis();
        ChannelFactory channelFactory = new ChannelFactory(this.port);
        channelFactory.init();
        List<GenPolynomial<C>> list2 = list;
        if (list2.isEmpty()) {
            throw new IllegalArgumentException("empty polynomial list not allowed");
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        PairList<C> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.put(list2);
        logger.info("start " + pairList);
        DistHashTable distHashTable = new DistHashTable("localhost", this.DHT_PORT);
        distHashTable.init();
        List list3 = pairList.getList();
        for (int i = 0; i < list3.size(); ++i) {
            genPolynomial = distHashTable.put(i, list3.get(i));
            if (genPolynomial == null) continue;
            logger.info("double polynomials " + i + ", nn = " + genPolynomial + ", al(i) = " + list3.get(i));
        }
        Terminator terminator = new Terminator(this.threads * this.threadsPerNode);
        logger.info("using pool = " + this.pool);
        for (n2 = 0; n2 < this.threads; ++n2) {
            genPolynomial = new HybridReducerServerEC(this.threadsPerNode, terminator, channelFactory, distHashTable, pairList);
            this.pool.addJob((Runnable)((Object)genPolynomial));
        }
        logger.info("main loop waiting " + terminator);
        terminator.waitDone();
        n2 = distHashTable.size();
        logger.info("#distributed list = " + n2);
        list2 = pairList.getList();
        if (n2 != list2.size()) {
            logger.info("#distributed list = " + distHashTable.size() + " #pairlist list = " + list2.size());
        }
        for (GenPolynomial genPolynomial2 : distHashTable.getValueList()) {
            if (!this.debug || genPolynomial2 == null || genPolynomial2.isZERO()) continue;
            logger.debug("final q = " + genPolynomial2.leadingExpVector());
        }
        logger.debug("distributed list end");
        long l2 = System.currentTimeMillis();
        List<GenPolynomial<C>> list4 = this.minimalGB(list2);
        l2 = System.currentTimeMillis() - l2;
        logger.debug("parallel gbmi time = " + l2);
        list2 = list4;
        logger.debug("server cf.terminate()");
        channelFactory.terminate();
        logger.debug("server theList.terminate() " + distHashTable.size());
        distHashTable.clear();
        distHashTable.terminate();
        l = System.currentTimeMillis() - l;
        logger.info("server GB end, time = " + l + ", " + pairList.toString());
        return list2;
    }

    public static <C extends RingElem<C>> void clientPart(String string, int n, int n2, int n3) throws IOException {
        ChannelFactory channelFactory = new ChannelFactory(n2 + 10);
        channelFactory.init();
        logger.info("clientPart connecting to " + string + ", port = " + n2 + ", dhtport = " + n3);
        SocketChannel socketChannel = channelFactory.getChannel(string, n2);
        TaggedSocketChannel taggedSocketChannel = new TaggedSocketChannel(socketChannel);
        taggedSocketChannel.init();
        DistHashTable distHashTable = new DistHashTable(string, n3);
        distHashTable.init();
        ThreadPool threadPool = new ThreadPool(n);
        logger.info("client using pool = " + threadPool);
        for (int i = 0; i < n; ++i) {
            HybridReducerClientEC hybridReducerClientEC = new HybridReducerClientEC(taggedSocketChannel, distHashTable);
            threadPool.addJob(hybridReducerClientEC);
        }
        logger.debug("clients submitted");
        threadPool.terminate();
        logger.debug("client pool.terminate()");
        taggedSocketChannel.close();
        logger.debug("client pairChannel.close()");
        distHashTable.terminate();
        channelFactory.terminate();
        logger.info("client cf.terminate()");
        socketChannel.close();
        logger.info("client channel.close()");
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial<C> genPolynomial;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        ListIterator<GenPolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = listIterator.next();
            if (genPolynomial.length() == 0) continue;
            arrayList.add(genPolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenPolynomial<Object> genPolynomial2;
            genPolynomial = arrayList.remove(0);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        Collections.reverse(arrayList);
        MiReducerServer[] miReducerServerArray = new MiReducerServer[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genPolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            miReducerServerArray[n] = new MiReducerServer(arrayList3, genPolynomial);
            this.pool.addJob(miReducerServerArray[n]);
            ++n;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < miReducerServerArray.length; ++n) {
            genPolynomial = miReducerServerArray[n].getNF();
            arrayList2.add(genPolynomial);
        }
        return arrayList2;
    }
}

