/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigRational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public final class BigComplex
implements StarRingElem<BigComplex>,
GcdRingElem<BigComplex>,
RingFactory<BigComplex> {
    public final BigRational re;
    public final BigRational im;
    private static final Random random = new Random();
    private static final Logger logger = Logger.getLogger(BigComplex.class);
    public static final BigComplex ZERO = new BigComplex();
    public static final BigComplex ONE = new BigComplex(BigRational.ONE);
    public static final BigComplex I = new BigComplex(BigRational.ZERO, BigRational.ONE);

    public BigComplex(BigRational bigRational, BigRational bigRational2) {
        this.re = bigRational;
        this.im = bigRational2;
    }

    public BigComplex(BigRational bigRational) {
        this(bigRational, BigRational.ZERO);
    }

    public BigComplex(long l) {
        this(new BigRational(l), BigRational.ZERO);
    }

    public BigComplex() {
        this(BigRational.ZERO);
    }

    public BigComplex(String string) throws NumberFormatException {
        if (string == null || string.length() == 0) {
            this.re = BigRational.ZERO;
            this.im = BigRational.ZERO;
            return;
        }
        int n = (string = string.trim()).indexOf("i");
        if (n < 0) {
            this.re = new BigRational(string);
            this.im = BigRational.ZERO;
            return;
        }
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        String string3 = "";
        if (n < string.length()) {
            string3 = string.substring(n + 1, string.length());
        }
        this.re = new BigRational(string2.trim());
        this.im = new BigRational(string3.trim());
    }

    public BigComplex factory() {
        return this;
    }

    @Override
    public List<BigComplex> generators() {
        ArrayList<BigComplex> arrayList = new ArrayList<BigComplex>(2);
        arrayList.add(this.getONE());
        arrayList.add(this.getIMAG());
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigComplex copy() {
        return new BigComplex(this.re, this.im);
    }

    @Override
    public BigComplex copy(BigComplex bigComplex) {
        return new BigComplex(bigComplex.re, bigComplex.im);
    }

    @Override
    public BigComplex getZERO() {
        return ZERO;
    }

    @Override
    public BigComplex getONE() {
        return ONE;
    }

    public BigComplex getIMAG() {
        return I;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigComplex fromInteger(BigInteger bigInteger) {
        return new BigComplex(new BigRational(bigInteger));
    }

    @Override
    public BigComplex fromInteger(long l) {
        return new BigComplex(new BigRational(l));
    }

    public BigRational getRe() {
        return this.re;
    }

    public BigRational getIm() {
        return this.im;
    }

    public String toString() {
        String string = "" + this.re;
        int n = this.im.compareTo(BigRational.ZERO);
        if (n == 0) {
            return string;
        }
        string = string + "i" + this.im;
        return string;
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.im.isZERO();
        if (bl) {
            stringBuffer.append(this.re.toScript());
            return stringBuffer.toString();
        }
        boolean bl2 = this.re.isZERO();
        if (bl2) {
            if (!this.im.isONE()) {
                if (this.im.signum() > 0) {
                    stringBuffer.append(this.im.toScript() + "*");
                } else {
                    stringBuffer.append("-");
                    BigRational bigRational = this.im.negate();
                    if (!bigRational.isONE()) {
                        stringBuffer.append(bigRational.toScript() + "*");
                    }
                }
            }
        } else {
            stringBuffer.append(this.re.toScript());
            if (this.im.signum() > 0) {
                stringBuffer.append("+");
                if (!this.im.isONE()) {
                    stringBuffer.append(this.im.toScript() + "*");
                }
            } else {
                stringBuffer.append("-");
                BigRational bigRational = this.im.negate();
                if (!bigRational.isONE()) {
                    stringBuffer.append(bigRational.toScript() + "*");
                }
            }
        }
        stringBuffer.append("I");
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return "CC()";
    }

    public static boolean isCZERO(BigComplex bigComplex) {
        if (bigComplex == null) {
            return false;
        }
        return bigComplex.isZERO();
    }

    @Override
    public boolean isZERO() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ZERO);
    }

    public static boolean isCONE(BigComplex bigComplex) {
        if (bigComplex == null) {
            return false;
        }
        return bigComplex.isONE();
    }

    @Override
    public boolean isONE() {
        return this.re.equals(BigRational.ONE) && this.im.equals(BigRational.ZERO);
    }

    public boolean isIMAG() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ONE);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BigComplex)) {
            return false;
        }
        BigComplex bigComplex = (BigComplex)object;
        return this.re.equals(bigComplex.re) && this.im.equals(bigComplex.im);
    }

    @Override
    public int hashCode() {
        return 37 * this.re.hashCode() + this.im.hashCode();
    }

    @Override
    public int compareTo(BigComplex bigComplex) {
        int n = this.re.compareTo(bigComplex.re);
        if (n != 0) {
            return n;
        }
        return this.im.compareTo(bigComplex.im);
    }

    @Override
    public int signum() {
        int n = this.re.signum();
        if (n != 0) {
            return n;
        }
        return this.im.signum();
    }

    @Override
    public BigComplex sum(BigComplex bigComplex) {
        return new BigComplex(this.re.sum(bigComplex.re), this.im.sum(bigComplex.im));
    }

    public static BigComplex CSUM(BigComplex bigComplex, BigComplex bigComplex2) {
        if (bigComplex == null) {
            return null;
        }
        return bigComplex.sum(bigComplex2);
    }

    public static BigComplex CDIF(BigComplex bigComplex, BigComplex bigComplex2) {
        if (bigComplex == null) {
            return null;
        }
        return bigComplex.subtract(bigComplex2);
    }

    @Override
    public BigComplex subtract(BigComplex bigComplex) {
        return new BigComplex(this.re.subtract(bigComplex.re), this.im.subtract(bigComplex.im));
    }

    public static BigComplex CNEG(BigComplex bigComplex) {
        if (bigComplex == null) {
            return null;
        }
        return bigComplex.negate();
    }

    @Override
    public BigComplex negate() {
        return new BigComplex(this.re.negate(), this.im.negate());
    }

    public static BigComplex CCON(BigComplex bigComplex) {
        if (bigComplex == null) {
            return null;
        }
        return bigComplex.conjugate();
    }

    @Override
    public BigComplex conjugate() {
        return new BigComplex(this.re, this.im.negate());
    }

    @Override
    public BigComplex norm() {
        BigRational bigRational = this.re.multiply(this.re);
        bigRational = bigRational.sum(this.im.multiply(this.im));
        return new BigComplex(bigRational);
    }

    @Override
    public BigComplex abs() {
        BigComplex bigComplex = this.norm();
        logger.error("abs() square root missing");
        return bigComplex;
    }

    public static BigRational CABS(BigComplex bigComplex) {
        if (bigComplex == null) {
            return null;
        }
        return bigComplex.abs().re;
    }

    public static BigComplex CPROD(BigComplex bigComplex, BigComplex bigComplex2) {
        if (bigComplex == null) {
            return null;
        }
        return bigComplex.multiply(bigComplex2);
    }

    @Override
    public BigComplex multiply(BigComplex bigComplex) {
        return new BigComplex(this.re.multiply(bigComplex.re).subtract(this.im.multiply(bigComplex.im)), this.re.multiply(bigComplex.im).sum(this.im.multiply(bigComplex.re)));
    }

    public static BigComplex CINV(BigComplex bigComplex) {
        if (bigComplex == null) {
            return null;
        }
        return bigComplex.inverse();
    }

    @Override
    public BigComplex inverse() {
        BigRational bigRational = this.norm().re.inverse();
        return new BigComplex(this.re.multiply(bigRational), this.im.multiply(bigRational.negate()));
    }

    @Override
    public BigComplex remainder(BigComplex bigComplex) {
        if (bigComplex.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public static BigComplex CQ(BigComplex bigComplex, BigComplex bigComplex2) {
        if (bigComplex == null) {
            return null;
        }
        return bigComplex.divide(bigComplex2);
    }

    @Override
    public BigComplex divide(BigComplex bigComplex) {
        return this.multiply(bigComplex.inverse());
    }

    public BigComplex[] quotientRemainder(BigComplex bigComplex) {
        return new BigComplex[]{this.divide(bigComplex), ZERO};
    }

    @Override
    public BigComplex random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigComplex random(int n, Random random) {
        BigRational bigRational = BigRational.ONE.random(n, random);
        BigRational bigRational2 = BigRational.ONE.random(n, random);
        return new BigComplex(bigRational, bigRational2);
    }

    public static BigComplex CRAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public BigComplex parse(String string) {
        return new BigComplex(string);
    }

    @Override
    public BigComplex parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public BigComplex gcd(BigComplex bigComplex) {
        if (bigComplex == null || bigComplex.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigComplex;
        }
        return ONE;
    }

    public BigComplex[] egcd(BigComplex bigComplex) {
        BigComplex[] bigComplexArray = new BigComplex[]{null, null, null};
        if (bigComplex == null || bigComplex.isZERO()) {
            bigComplexArray[0] = this;
            return bigComplexArray;
        }
        if (this.isZERO()) {
            bigComplexArray[0] = bigComplex;
            return bigComplexArray;
        }
        BigComplex bigComplex2 = new BigComplex(new BigRational(1L, 2L));
        bigComplexArray[0] = ONE;
        bigComplexArray[1] = this.inverse().multiply(bigComplex2);
        bigComplexArray[2] = bigComplex.inverse().multiply(bigComplex2);
        return bigComplexArray;
    }
}

