/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.IterableDouble;
import common.iterable.IterableInt;
import common.iterable.IterableLong;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class MappingIterator<S, T>
implements Iterator<T> {
    protected final Iterator<S> iterator;

    public MappingIterator(Iterable<S> iterable) {
        this(iterable.iterator());
    }

    public MappingIterator(Iterator<S> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public static PrimitiveIterator.OfInt toInt(Iterable<Integer> iterable) {
        return MappingIterator.toInt(iterable.iterator());
    }

    public static PrimitiveIterator.OfInt toInt(Iterator<Integer> iterator) {
        if (iterator instanceof PrimitiveIterator.OfInt) {
            return (PrimitiveIterator.OfInt)iterator;
        }
        return new ToInt<Integer>(iterator, Integer::intValue);
    }

    public static PrimitiveIterator.OfDouble toDouble(Iterable<Double> iterable) {
        return MappingIterator.toDouble(iterable.iterator());
    }

    public static PrimitiveIterator.OfDouble toDouble(Iterator<Double> iterator) {
        if (iterator instanceof PrimitiveIterator.OfDouble) {
            return (PrimitiveIterator.OfDouble)iterator;
        }
        return new ToDouble<Double>(iterator, Double::doubleValue);
    }

    public static PrimitiveIterator.OfLong toLong(Iterable<Long> iterable) {
        return MappingIterator.toLong(iterable.iterator());
    }

    public static PrimitiveIterator.OfLong toLong(Iterator<Long> iterator) {
        if (iterator instanceof PrimitiveIterator.OfLong) {
            return (PrimitiveIterator.OfLong)iterator;
        }
        return new ToLong<Long>(iterator, Long::longValue);
    }

    public static class FromLongToLong
    extends MappingIterator<Long, Long>
    implements PrimitiveIterator.OfLong {
        protected LongUnaryOperator function;

        public FromLongToLong(IterableLong iterableLong, LongUnaryOperator longUnaryOperator) {
            this(iterableLong.iterator(), longUnaryOperator);
        }

        public FromLongToLong(PrimitiveIterator.OfLong ofLong, LongUnaryOperator longUnaryOperator) {
            super(ofLong);
            this.function = longUnaryOperator;
        }

        @Override
        public long nextLong() {
            return this.function.applyAsLong(((PrimitiveIterator.OfLong)this.iterator).nextLong());
        }
    }

    public static class FromLongToDouble
    extends MappingIterator<Long, Double>
    implements PrimitiveIterator.OfDouble {
        protected LongToDoubleFunction function;

        public FromLongToDouble(IterableLong iterableLong, LongToDoubleFunction longToDoubleFunction) {
            this(iterableLong.iterator(), longToDoubleFunction);
        }

        public FromLongToDouble(PrimitiveIterator.OfLong ofLong, LongToDoubleFunction longToDoubleFunction) {
            super(ofLong);
            this.function = longToDoubleFunction;
        }

        @Override
        public double nextDouble() {
            return this.function.applyAsDouble(((PrimitiveIterator.OfLong)this.iterator).nextLong());
        }
    }

    public static class FromLongToInt
    extends MappingIterator<Long, Integer>
    implements PrimitiveIterator.OfInt {
        protected LongToIntFunction function;

        public FromLongToInt(IterableLong iterableLong, LongToIntFunction longToIntFunction) {
            this(iterableLong.iterator(), longToIntFunction);
        }

        public FromLongToInt(PrimitiveIterator.OfLong ofLong, LongToIntFunction longToIntFunction) {
            super(ofLong);
            this.function = longToIntFunction;
        }

        @Override
        public int nextInt() {
            return this.function.applyAsInt(((PrimitiveIterator.OfLong)this.iterator).nextLong());
        }
    }

    public static class FromLong<T>
    extends MappingIterator<Long, T> {
        protected LongFunction<T> function;

        public FromLong(IterableLong iterableLong, LongFunction<T> longFunction) {
            this(iterableLong.iterator(), longFunction);
        }

        public FromLong(PrimitiveIterator.OfLong ofLong, LongFunction<T> longFunction) {
            super(ofLong);
            this.function = longFunction;
        }

        @Override
        public T next() {
            return this.function.apply(((PrimitiveIterator.OfLong)this.iterator).nextLong());
        }
    }

    public static class FromDoubleToLong
    extends MappingIterator<Double, Long>
    implements PrimitiveIterator.OfLong {
        protected DoubleToLongFunction function;

        public FromDoubleToLong(IterableDouble iterableDouble, DoubleToLongFunction doubleToLongFunction) {
            this(iterableDouble.iterator(), doubleToLongFunction);
        }

        public FromDoubleToLong(PrimitiveIterator.OfDouble ofDouble, DoubleToLongFunction doubleToLongFunction) {
            super(ofDouble);
            this.function = doubleToLongFunction;
        }

        @Override
        public long nextLong() {
            return this.function.applyAsLong(((PrimitiveIterator.OfDouble)this.iterator).nextDouble());
        }
    }

    public static class FromDoubleToDouble
    extends MappingIterator<Double, Double>
    implements PrimitiveIterator.OfDouble {
        protected DoubleUnaryOperator function;

        public FromDoubleToDouble(IterableDouble iterableDouble, DoubleUnaryOperator doubleUnaryOperator) {
            this(iterableDouble.iterator(), doubleUnaryOperator);
        }

        public FromDoubleToDouble(PrimitiveIterator.OfDouble ofDouble, DoubleUnaryOperator doubleUnaryOperator) {
            super(ofDouble);
            this.function = doubleUnaryOperator;
        }

        @Override
        public double nextDouble() {
            return this.function.applyAsDouble(((PrimitiveIterator.OfDouble)this.iterator).nextDouble());
        }
    }

    public static class FromDoubleToInt
    extends MappingIterator<Double, Integer>
    implements PrimitiveIterator.OfInt {
        protected DoubleToIntFunction function;

        public FromDoubleToInt(IterableDouble iterableDouble, DoubleToIntFunction doubleToIntFunction) {
            this(iterableDouble.iterator(), doubleToIntFunction);
        }

        public FromDoubleToInt(PrimitiveIterator.OfDouble ofDouble, DoubleToIntFunction doubleToIntFunction) {
            super(ofDouble);
            this.function = doubleToIntFunction;
        }

        @Override
        public int nextInt() {
            return this.function.applyAsInt(((PrimitiveIterator.OfDouble)this.iterator).nextDouble());
        }
    }

    public static class FromDouble<T>
    extends MappingIterator<Double, T> {
        protected DoubleFunction<T> function;

        public FromDouble(IterableDouble iterableDouble, DoubleFunction<T> doubleFunction) {
            this(iterableDouble.iterator(), doubleFunction);
        }

        public FromDouble(PrimitiveIterator.OfDouble ofDouble, DoubleFunction<T> doubleFunction) {
            super(ofDouble);
            this.function = doubleFunction;
        }

        @Override
        public T next() {
            return this.function.apply(((PrimitiveIterator.OfDouble)this.iterator).nextDouble());
        }
    }

    public static class FromIntToLong
    extends MappingIterator<Integer, Long>
    implements PrimitiveIterator.OfLong {
        protected IntToLongFunction function;

        public FromIntToLong(IterableInt iterableInt, IntToLongFunction intToLongFunction) {
            this(iterableInt.iterator(), intToLongFunction);
        }

        public FromIntToLong(PrimitiveIterator.OfInt ofInt, IntToLongFunction intToLongFunction) {
            super(ofInt);
            this.function = intToLongFunction;
        }

        @Override
        public long nextLong() {
            return this.function.applyAsLong(((PrimitiveIterator.OfInt)this.iterator).nextInt());
        }
    }

    public static class FromIntToDouble
    extends MappingIterator<Integer, Double>
    implements PrimitiveIterator.OfDouble {
        protected IntToDoubleFunction function;

        public FromIntToDouble(IterableInt iterableInt, IntToDoubleFunction intToDoubleFunction) {
            this(iterableInt.iterator(), intToDoubleFunction);
        }

        public FromIntToDouble(PrimitiveIterator.OfInt ofInt, IntToDoubleFunction intToDoubleFunction) {
            super(ofInt);
            this.function = intToDoubleFunction;
        }

        @Override
        public double nextDouble() {
            return this.function.applyAsDouble(((PrimitiveIterator.OfInt)this.iterator).nextInt());
        }
    }

    public static class FromIntToInt
    extends MappingIterator<Integer, Integer>
    implements PrimitiveIterator.OfInt {
        protected IntUnaryOperator function;

        public FromIntToInt(IterableInt iterableInt, IntUnaryOperator intUnaryOperator) {
            this(iterableInt.iterator(), intUnaryOperator);
        }

        public FromIntToInt(PrimitiveIterator.OfInt ofInt, IntUnaryOperator intUnaryOperator) {
            super(ofInt);
            this.function = intUnaryOperator;
        }

        @Override
        public int nextInt() {
            return this.function.applyAsInt(((PrimitiveIterator.OfInt)this.iterator).nextInt());
        }
    }

    public static class FromInt<T>
    extends MappingIterator<Integer, T> {
        protected IntFunction<T> function;

        public FromInt(IterableInt iterableInt, IntFunction<T> intFunction) {
            this(iterableInt.iterator(), intFunction);
        }

        public FromInt(PrimitiveIterator.OfInt ofInt, IntFunction<T> intFunction) {
            super(ofInt);
            this.function = intFunction;
        }

        @Override
        public T next() {
            return this.function.apply(((PrimitiveIterator.OfInt)this.iterator).nextInt());
        }
    }

    public static class ToLong<S>
    extends MappingIterator<S, Long>
    implements PrimitiveIterator.OfLong {
        protected ToLongFunction<? super S> function;

        public ToLong(Iterable<S> iterable, ToLongFunction<? super S> toLongFunction) {
            this(iterable.iterator(), toLongFunction);
        }

        public ToLong(Iterator<S> iterator, ToLongFunction<? super S> toLongFunction) {
            super(iterator);
            this.function = toLongFunction;
        }

        @Override
        public long nextLong() {
            return this.function.applyAsLong(this.iterator.next());
        }
    }

    public static class ToDouble<S>
    extends MappingIterator<S, Double>
    implements PrimitiveIterator.OfDouble {
        protected ToDoubleFunction<? super S> function;

        public ToDouble(Iterable<S> iterable, ToDoubleFunction<? super S> toDoubleFunction) {
            this(iterable.iterator(), toDoubleFunction);
        }

        public ToDouble(Iterator<S> iterator, ToDoubleFunction<? super S> toDoubleFunction) {
            super(iterator);
            this.function = toDoubleFunction;
        }

        @Override
        public double nextDouble() {
            return this.function.applyAsDouble(this.iterator.next());
        }
    }

    public static class ToInt<S>
    extends MappingIterator<S, Integer>
    implements PrimitiveIterator.OfInt {
        protected ToIntFunction<? super S> function;

        public ToInt(Iterable<S> iterable, ToIntFunction<? super S> toIntFunction) {
            this(iterable.iterator(), toIntFunction);
        }

        public ToInt(Iterator<S> iterator, ToIntFunction<? super S> toIntFunction) {
            super(iterator);
            this.function = toIntFunction;
        }

        @Override
        public int nextInt() {
            return this.function.applyAsInt(this.iterator.next());
        }
    }

    public static class From<S, T>
    extends MappingIterator<S, T> {
        protected final Function<? super S, T> function;

        public From(Iterable<S> iterable, Function<? super S, T> function) {
            this(iterable.iterator(), function);
        }

        public From(Iterator<S> iterator, Function<? super S, T> function) {
            super(iterator);
            this.function = function;
        }

        @Override
        public T next() {
            return this.function.apply(this.iterator.next());
        }
    }
}

