/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.iterable.FilteringIterator;
import common.iterable.MappingIterator;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public class IteratorTools {
    public static int count(Iterable<?> iterable) {
        return IteratorTools.count(iterable.iterator());
    }

    public static int count(Iterator<?> iterator) {
        if (iterator instanceof PrimitiveIterator.OfInt) {
            return IteratorTools.count((PrimitiveIterator.OfInt)iterator);
        }
        if (iterator instanceof PrimitiveIterator.OfLong) {
            return IteratorTools.count((PrimitiveIterator.OfLong)iterator);
        }
        if (iterator instanceof PrimitiveIterator.OfDouble) {
            return IteratorTools.count((PrimitiveIterator.OfDouble)iterator);
        }
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public static int count(PrimitiveIterator.OfInt ofInt) {
        int n = 0;
        while (ofInt.hasNext()) {
            ++n;
            ofInt.nextInt();
        }
        return n;
    }

    public static int count(PrimitiveIterator.OfLong ofLong) {
        int n = 0;
        while (ofLong.hasNext()) {
            ++n;
            ofLong.nextLong();
        }
        return n;
    }

    public static int count(PrimitiveIterator.OfDouble ofDouble) {
        int n = 0;
        while (ofDouble.hasNext()) {
            ++n;
            ofDouble.nextDouble();
        }
        return n;
    }

    public static <T> int count(Iterable<T> iterable, Predicate<? super T> predicate) {
        return IteratorTools.count(iterable.iterator(), predicate);
    }

    public static <T> int count(Iterator<T> iterator, Predicate<? super T> predicate) {
        if (iterator instanceof PrimitiveIterator.OfInt && predicate instanceof IntPredicate) {
            return IteratorTools.count(new FilteringIterator.OfInt((PrimitiveIterator.OfInt)iterator, (IntPredicate)((Object)predicate)));
        }
        if (iterator instanceof PrimitiveIterator.OfLong && predicate instanceof LongPredicate) {
            return IteratorTools.count(new FilteringIterator.OfLong((PrimitiveIterator.OfLong)iterator, (LongPredicate)((Object)predicate)));
        }
        if (iterator instanceof PrimitiveIterator.OfDouble && predicate instanceof DoublePredicate) {
            return IteratorTools.count(new FilteringIterator.OfDouble((PrimitiveIterator.OfDouble)iterator, (DoublePredicate)((Object)predicate)));
        }
        return IteratorTools.count(new FilteringIterator.Of<T>(iterator, predicate));
    }

    public static int sumInt(Iterator<Integer> iterator) {
        return IteratorTools.sum(MappingIterator.toInt(iterator));
    }

    public static int sum(PrimitiveIterator.OfInt ofInt) {
        int n = 0;
        while (ofInt.hasNext()) {
            n += ofInt.nextInt();
        }
        return n;
    }

    public static long sumLong(Iterator<Long> iterator) {
        return IteratorTools.sum(MappingIterator.toLong(iterator));
    }

    public static long sum(PrimitiveIterator.OfLong ofLong) {
        long l = 0L;
        while (ofLong.hasNext()) {
            l += ofLong.nextLong();
        }
        return l;
    }

    public static double sumDouble(Iterator<Double> iterator) {
        return IteratorTools.sum(MappingIterator.toDouble(iterator));
    }

    public static double sum(PrimitiveIterator.OfDouble ofDouble) {
        double d = 0.0;
        while (ofDouble.hasNext()) {
            d += ofDouble.nextDouble();
        }
        return d;
    }
}

