/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabinDD;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import jdd.JDDVars;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class AcceptanceRabin
extends ArrayList<RabinPair>
implements AcceptanceOmega {
    @Override
    public AcceptanceRabin clone() {
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        for (RabinPair rabinPair : this) {
            acceptanceRabin.add(rabinPair.clone());
        }
        return acceptanceRabin;
    }

    @Override
    public boolean isBSCCAccepting(BitSet bitSet) {
        for (RabinPair rabinPair : this) {
            if (!rabinPair.isBSCCAccepting(bitSet)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lift(AcceptanceOmega.LiftBitSet liftBitSet) {
        for (RabinPair rabinPair : this) {
            rabinPair.L = liftBitSet.lift(rabinPair.L);
            rabinPair.K = liftBitSet.lift(rabinPair.K);
        }
    }

    public AcceptanceStreett complementToStreett() {
        AcceptanceStreett acceptanceStreett = new AcceptanceStreett();
        for (RabinPair rabinPair : this) {
            BitSet bitSet = (BitSet)rabinPair.getK().clone();
            BitSet bitSet2 = (BitSet)rabinPair.getL().clone();
            AcceptanceStreett.StreettPair streettPair = new AcceptanceStreett.StreettPair(bitSet, bitSet2);
            acceptanceStreett.add(streettPair);
        }
        return acceptanceStreett;
    }

    public AcceptanceGeneric complementToGeneric() {
        return this.toAcceptanceGeneric().complementToGeneric();
    }

    @Override
    public AcceptanceOmega complement(int n, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.STREETT)) {
            return this.complementToStreett();
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    public AcceptanceRabin or(AcceptanceRabin acceptanceRabin) {
        AcceptanceRabin acceptanceRabin2 = new AcceptanceRabin();
        for (RabinPair rabinPair : this) {
            acceptanceRabin2.add(rabinPair.clone());
        }
        for (RabinPair rabinPair : acceptanceRabin) {
            acceptanceRabin2.add(rabinPair.clone());
        }
        return acceptanceRabin2;
    }

    @Override
    public AcceptanceRabinDD toAcceptanceDD(JDDVars jDDVars) {
        return new AcceptanceRabinDD(this, jDDVars);
    }

    @Override
    public AcceptanceGeneric toAcceptanceGeneric() {
        if (this.size() == 0) {
            return new AcceptanceGeneric(false);
        }
        AcceptanceGeneric acceptanceGeneric = null;
        for (RabinPair rabinPair : this) {
            AcceptanceGeneric acceptanceGeneric2 = rabinPair.toAcceptanceGeneric();
            if (acceptanceGeneric == null) {
                acceptanceGeneric = acceptanceGeneric2;
                continue;
            }
            acceptanceGeneric = new AcceptanceGeneric(AcceptanceGeneric.ElementType.OR, acceptanceGeneric, acceptanceGeneric2);
        }
        return acceptanceGeneric;
    }

    @Override
    public String getSignatureForState(int n) {
        Object object = "";
        for (int i = 0; i < this.size(); ++i) {
            RabinPair rabinPair = (RabinPair)this.get(i);
            object = (String)object + rabinPair.getSignatureForState(n, i);
        }
        return object;
    }

    @Override
    public String getSignatureForStateHOA(int n) {
        Object object = "";
        for (int i = 0; i < this.size(); ++i) {
            RabinPair rabinPair = (RabinPair)this.get(i);
            if (rabinPair.getL().get(n)) {
                object = (String)object + (((String)object).isEmpty() ? "" : " ") + i * 2;
            }
            if (!rabinPair.getK().get(n)) continue;
            object = (String)object + (((String)object).isEmpty() ? "" : " ") + (i * 2 + 1);
        }
        if (!((String)object).isEmpty()) {
            object = "{" + (String)object + "}";
        }
        return object;
    }

    @Override
    public String toString() {
        Object object = "";
        for (RabinPair rabinPair : this) {
            object = (String)object + rabinPair.toString();
        }
        return object;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Rabin pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.RABIN;
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public void outputHOAHeader(PrintStream printStream) {
        printStream.println("acc-name: Rabin " + this.size());
        printStream.print("Acceptance: " + this.size() * 2 + " ");
        if (this.size() == 0) {
            printStream.println("f");
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                printStream.print(" | ");
            }
            printStream.print("( Fin(" + 2 * i + ") & Inf(" + (2 * i + 1) + ") )");
        }
        printStream.println();
    }

    public static class RabinPair {
        private BitSet L;
        private BitSet K;

        public RabinPair(BitSet bitSet, BitSet bitSet2) {
            this.L = bitSet;
            this.K = bitSet2;
        }

        public BitSet getL() {
            return this.L;
        }

        public BitSet getK() {
            return this.K;
        }

        public boolean isBSCCAccepting(BitSet bitSet) {
            if (this.L.intersects(bitSet)) {
                return false;
            }
            return this.K.intersects(bitSet);
        }

        public AcceptanceGeneric toAcceptanceGeneric() {
            AcceptanceGeneric acceptanceGeneric = new AcceptanceGeneric(AcceptanceGeneric.ElementType.FIN, (BitSet)this.L.clone());
            AcceptanceGeneric acceptanceGeneric2 = new AcceptanceGeneric(AcceptanceGeneric.ElementType.INF, (BitSet)this.K.clone());
            return new AcceptanceGeneric(AcceptanceGeneric.ElementType.AND, acceptanceGeneric, acceptanceGeneric2);
        }

        public String getSignatureForState(int n, int n2) {
            if (this.L.get(n)) {
                return "-" + n2;
            }
            if (this.K.get(n)) {
                return "+" + n2;
            }
            return "";
        }

        public RabinPair clone() {
            return new RabinPair((BitSet)this.L.clone(), (BitSet)this.K.clone());
        }

        public String toString() {
            return "(" + this.L + "," + this.K + ")";
        }
    }
}

