/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGenRabin;
import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceGenericDD;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import java.util.ArrayList;
import java.util.PrimitiveIterator;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismNotSupportedException;

public class AcceptanceGenRabinDD
extends ArrayList<GenRabinPairDD>
implements AcceptanceOmegaDD {
    public AcceptanceGenRabinDD() {
    }

    public AcceptanceGenRabinDD(AcceptanceGenRabin acceptanceGenRabin, JDDVars jDDVars) {
        for (AcceptanceGenRabin.GenRabinPair genRabinPair : acceptanceGenRabin) {
            int n;
            JDDNode jDDNode = JDD.Constant(0.0);
            Object object = IterableBitSet.getSetBits(genRabinPair.getL()).iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                jDDNode = JDD.SetVectorElement(jDDNode, jDDVars, n, 1.0);
            }
            object = new ArrayList();
            n = genRabinPair.getNumK();
            for (int i = 0; i < n; ++i) {
                JDDNode jDDNode2 = JDD.Constant(0.0);
                PrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(genRabinPair.getK(i)).iterator();
                while (ofInt.hasNext()) {
                    int n2 = (Integer)ofInt.next();
                    jDDNode2 = JDD.SetVectorElement(jDDNode2, jDDVars, n2, 1.0);
                }
                ((ArrayList)object).add(jDDNode2);
            }
            GenRabinPairDD genRabinPairDD = new GenRabinPairDD(jDDNode, (ArrayList<JDDNode>)object);
            this.add(genRabinPairDD);
        }
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        for (GenRabinPairDD genRabinPairDD : this) {
            if (!genRabinPairDD.isBSCCAccepting(jDDNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AcceptanceGenRabinDD clone() {
        AcceptanceGenRabinDD acceptanceGenRabinDD = new AcceptanceGenRabinDD();
        for (GenRabinPairDD genRabinPairDD : this) {
            acceptanceGenRabinDD.add(genRabinPairDD.clone());
        }
        return acceptanceGenRabinDD;
    }

    @Override
    public void intersect(JDDNode jDDNode) {
        for (GenRabinPairDD genRabinPairDD : this) {
            genRabinPairDD.intersect(jDDNode);
        }
    }

    @Override
    public void clear() {
        for (GenRabinPairDD genRabinPairDD : this) {
            genRabinPairDD.clear();
        }
        super.clear();
    }

    @Override
    public String toString() {
        Object object = "";
        for (GenRabinPairDD genRabinPairDD : this) {
            object = (String)object + genRabinPairDD.toString();
        }
        return object;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Generalized Rabin pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.GENERALIZED_RABIN;
    }

    @Override
    public AcceptanceOmegaDD complement(AcceptanceType ... acceptanceTypeArray) throws PrismNotSupportedException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    @Override
    public AcceptanceGenericDD toAcceptanceGeneric() {
        if (this.size() == 0) {
            return new AcceptanceGenericDD(false);
        }
        AcceptanceGenericDD acceptanceGenericDD = null;
        for (GenRabinPairDD genRabinPairDD : this) {
            AcceptanceGenericDD acceptanceGenericDD2 = genRabinPairDD.toAcceptanceGeneric();
            if (acceptanceGenericDD == null) {
                acceptanceGenericDD = acceptanceGenericDD2;
                continue;
            }
            acceptanceGenericDD = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.OR, acceptanceGenericDD, acceptanceGenericDD2);
        }
        return acceptanceGenericDD;
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    public static class GenRabinPairDD
    implements Cloneable {
        private JDDNode L;
        private ArrayList<JDDNode> K_list;

        public GenRabinPairDD(JDDNode jDDNode, ArrayList<JDDNode> arrayList) {
            this.L = jDDNode;
            this.K_list = arrayList;
        }

        public void clear() {
            if (this.L != null) {
                JDD.Deref(this.L);
            }
            for (JDDNode jDDNode : this.K_list) {
                JDD.Deref(jDDNode);
            }
        }

        public JDDNode getL() {
            return this.L.copy();
        }

        public int getNumK() {
            return this.K_list.size();
        }

        public JDDNode getK(int n) {
            return this.K_list.get(n).copy();
        }

        public GenRabinPairDD clone() {
            ArrayList<JDDNode> arrayList = new ArrayList<JDDNode>();
            for (JDDNode jDDNode : this.K_list) {
                arrayList.add(jDDNode.copy());
            }
            return new GenRabinPairDD(this.getL(), arrayList);
        }

        public boolean isBSCCAccepting(JDDNode jDDNode) {
            if (JDD.AreIntersecting(this.L, jDDNode)) {
                return false;
            }
            for (JDDNode jDDNode2 : this.K_list) {
                if (JDD.AreIntersecting(jDDNode2, jDDNode)) continue;
                return false;
            }
            return true;
        }

        public AcceptanceGenericDD toAcceptanceGeneric() {
            AcceptanceGenericDD acceptanceGenericDD = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.FIN, this.L.copy());
            if (this.getNumK() == 0) {
                return acceptanceGenericDD;
            }
            AcceptanceGenericDD acceptanceGenericDD2 = null;
            for (JDDNode jDDNode : this.K_list) {
                AcceptanceGenericDD acceptanceGenericDD3 = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.INF, jDDNode.copy());
                if (acceptanceGenericDD2 == null) {
                    acceptanceGenericDD2 = acceptanceGenericDD3;
                    continue;
                }
                acceptanceGenericDD2 = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.AND, acceptanceGenericDD2, acceptanceGenericDD3);
            }
            return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.AND, acceptanceGenericDD, acceptanceGenericDD2);
        }

        public void intersect(JDDNode jDDNode) {
            this.L = JDD.And(this.L, jDDNode.copy());
            for (int i = 0; i < this.K_list.size(); ++i) {
                this.K_list.set(i, JDD.And(this.K_list.get(i), jDDNode.copy()));
            }
        }

        public String toString() {
            String string = "(" + this.L;
            for (JDDNode jDDNode : this.K_list) {
                string = string + "," + jDDNode;
            }
            string = string + ")";
            return string;
        }
    }
}

