/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceBuchiDD;
import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import java.io.PrintStream;
import java.util.BitSet;
import jdd.JDDVars;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class AcceptanceBuchi
implements AcceptanceOmega {
    private BitSet acceptingStates = new BitSet();

    public AcceptanceBuchi() {
    }

    public AcceptanceBuchi(BitSet bitSet) {
        this.acceptingStates = bitSet;
    }

    public BitSet getAcceptingStates() {
        return this.acceptingStates;
    }

    public void setAcceptingStates(BitSet bitSet) {
        this.acceptingStates = bitSet;
    }

    @Override
    public AcceptanceBuchi clone() {
        return new AcceptanceBuchi((BitSet)this.acceptingStates.clone());
    }

    @Override
    public boolean isBSCCAccepting(BitSet bitSet) {
        return bitSet.intersects(this.acceptingStates);
    }

    public AcceptanceRabin toRabin(int n) {
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        acceptanceRabin.add(new AcceptanceRabin.RabinPair(new BitSet(), (BitSet)this.acceptingStates.clone()));
        return acceptanceRabin;
    }

    public AcceptanceStreett toStreett(int n) {
        AcceptanceStreett acceptanceStreett = new AcceptanceStreett();
        BitSet bitSet = new BitSet();
        bitSet.set(0, n);
        acceptanceStreett.add(new AcceptanceStreett.StreettPair(bitSet, (BitSet)this.acceptingStates.clone()));
        return acceptanceStreett;
    }

    public AcceptanceRabin complementToRabin(int n) {
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        BitSet bitSet = new BitSet();
        bitSet.set(0, n);
        acceptanceRabin.add(new AcceptanceRabin.RabinPair((BitSet)this.acceptingStates.clone(), bitSet));
        return acceptanceRabin;
    }

    public AcceptanceStreett complementToStreett(int n) {
        AcceptanceStreett acceptanceStreett = new AcceptanceStreett();
        acceptanceStreett.add(new AcceptanceStreett.StreettPair((BitSet)this.acceptingStates.clone(), new BitSet()));
        return acceptanceStreett;
    }

    public AcceptanceGeneric complementToGeneric() {
        return this.toAcceptanceGeneric().complementToGeneric();
    }

    @Override
    public AcceptanceOmega complement(int n, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.RABIN)) {
            return this.complementToRabin(n);
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.STREETT)) {
            return this.complementToStreett(n);
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    @Override
    public void lift(AcceptanceOmega.LiftBitSet liftBitSet) {
        this.acceptingStates = liftBitSet.lift(this.acceptingStates);
    }

    @Override
    public AcceptanceBuchiDD toAcceptanceDD(JDDVars jDDVars) {
        return new AcceptanceBuchiDD(this, jDDVars);
    }

    @Override
    public AcceptanceGeneric toAcceptanceGeneric() {
        return new AcceptanceGeneric(AcceptanceGeneric.ElementType.INF, (BitSet)this.acceptingStates.clone());
    }

    @Override
    public String getSignatureForState(int n) {
        return this.acceptingStates.get(n) ? "!" : " ";
    }

    @Override
    public String getSignatureForStateHOA(int n) {
        if (this.acceptingStates.get(n)) {
            return "{0}";
        }
        return "";
    }

    public String toString() {
        return this.acceptingStates.toString();
    }

    @Override
    public String getSizeStatistics() {
        return this.acceptingStates.cardinality() + " accepting states";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.BUCHI;
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public void outputHOAHeader(PrintStream printStream) {
        printStream.println("acc-name: Buchi");
        printStream.println("Acceptance: 1 Inf(0)");
    }
}

