/*
 * Decompiled with CFR 0.152.
 */
package Path_finding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spg.PrismAPI.PrismParamAPI;
import org.spg.utils.PrismAPIUtilities;

public class TransitionMatrix {
    private ArrayList<ArrayList<Integer>> transition_states = new ArrayList();
    private ArrayList<String> model_parameters = new ArrayList();
    private int number_states;
    private int number_transitions;

    public TransitionMatrix(String model_path, String property_path) throws Exception {
        PrismParamAPI api = new PrismParamAPI();
        api.loadParamModel(PrismAPIUtilities.readModelFile((String)model_path));
        api.setPropertiesFile(property_path);
        String transMatrix = api.getParametricTransitionMatrix();
        Scanner scan = new Scanner(transMatrix);
        String line = scan.nextLine();
        String[] str_array = line.split(" ");
        assert (str_array.length == 2);
        this.number_states = Integer.parseInt(str_array[0]);
        this.number_transitions = Integer.parseInt(str_array[1]);
        while (scan.hasNext()) {
            line = scan.nextLine();
            str_array = line.split(" ");
            ArrayList<Integer> transition = new ArrayList<Integer>();
            transition.add(Integer.parseInt(str_array[0]));
            transition.add(Integer.parseInt(str_array[1]));
            this.transition_states.add(transition);
            String[] transitionValue = String.join((CharSequence)"", Arrays.copyOfRange(str_array, 2, str_array.length)).replace("{", "").replace("}", "").split("\\|");
            int i = 0;
            while (i < transitionValue.length) {
                String rfPart = transitionValue[i];
                rfPart = rfPart.replaceAll("\\s+", "");
                Pattern pattern = Pattern.compile("(\\([-]?[0-9]+\\))");
                Matcher m = pattern.matcher(rfPart);
                transitionValue[i] = m.replaceAll("$1*");
                ++i;
            }
            String trans = "(" + transitionValue[0] + ")";
            if (transitionValue.length > 1) {
                trans = String.valueOf(trans) + "/(" + transitionValue[1] + ")";
            }
            trans = trans.replace(")*)", "))");
            this.model_parameters.add(trans);
        }
    }

    public int getNumberOfTransitions() {
        return this.number_transitions;
    }

    public int getNumberOfStates() {
        return this.number_states;
    }

    public ArrayList<ArrayList<Integer>> getTransitionStates() {
        return this.transition_states;
    }

    public ArrayList<String> getModelParameters() {
        return this.model_parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(String.format("Number of states: %d, Number of transition: %d\n", this.number_states, this.number_transitions));
        int i = 0;
        while (i < this.transition_states.size()) {
            sb.append(String.valueOf(this.transition_states.get(i).toString()) + "\n");
            sb.append(String.valueOf(this.model_parameters.get(i).toString()) + "\n");
            ++i;
        }
        return sb.toString();
    }
}

