/*
 * Decompiled with CFR 0.152.
 */
package ePMC_ExtractComponents;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class ParseComments {
    String modelFile;
    String repoFile;
    StringBuilder repository = new StringBuilder();

    public ParseComments(String mf, String rf) {
        this.modelFile = mf;
        this.repoFile = rf;
        try {
            FileReader frModel = new FileReader(this.modelFile);
            BufferedReader brModel = new BufferedReader(frModel);
            String line = null;
            while ((line = brModel.readLine()) != null) {
                if (!(line = line.trim()).startsWith("///")) continue;
                line = line.substring(3, line.length()).trim();
                String[] parts = line.split(":");
                String compID = parts[0].trim();
                parts = parts[1].split("[(]");
                String component = parts[0].trim();
                parts[1] = parts[1].replace("(", "");
                parts[1] = parts[1].replace(")", "");
                String[] parameters = parts[1].split(",");
                System.out.println("%---- Component " + component + compID + " ----");
                System.out.println("%---- parameter values ----");
                int i = 0;
                while (i < parameters.length) {
                    System.out.println(String.valueOf(parameters[i].trim()) + " = 0.5;");
                    ++i;
                }
                System.out.println("%---- Component Formula ----");
                String definition = this.getComponent(component, parameters.length);
                String funcDef = definition.split(":")[0];
                String parmList = funcDef.substring(funcDef.indexOf("(") + 1, funcDef.indexOf(")"));
                String[] defParameters = parmList.split(",");
                String[] functions = definition.split(":")[1].split(",");
                ArrayList<String> variables = new ArrayList<String>();
                int i2 = 0;
                while (i2 < functions.length) {
                    variables.add(functions[i2].split("=")[0].trim());
                    ++i2;
                }
                i2 = 0;
                while (i2 < functions.length) {
                    StringBuilder newFunction = new StringBuilder();
                    int start = functions[i2].indexOf(61);
                    String left = functions[i2].substring(0, start).trim();
                    newFunction.append(left);
                    newFunction.append(" = ");
                    String partial = null;
                    Boolean found = false;
                    int j = ++start;
                    while (j < functions[i2].length()) {
                        found = false;
                        partial = functions[i2].substring(j, functions[i2].length());
                        int k = 0;
                        while (k < defParameters.length) {
                            if (this.isParam(defParameters[k], partial).booleanValue()) {
                                found = true;
                                newFunction.append(parameters[k]);
                                j += defParameters[k].length() - 1;
                                break;
                            }
                            ++k;
                        }
                        if (!found.booleanValue()) {
                            k = 0;
                            while (k < variables.size()) {
                                if (this.isParam(variables.get(k).toString(), partial).booleanValue()) {
                                    found = true;
                                    newFunction.append(variables.get(k) + compID);
                                    j += variables.get(k).toString().length() - 1;
                                    break;
                                }
                                ++k;
                            }
                        }
                        if (!found.booleanValue()) {
                            newFunction.append(partial.charAt(0));
                        }
                        ++j;
                    }
                    String[] out = newFunction.toString().split("=");
                    System.out.println(String.valueOf(out[0].trim()) + compID + " = " + out[1] + ";");
                    ++i2;
                }
                System.out.println("%------------------------------------------------");
            }
            brModel.close();
            frModel.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Boolean isParam(String param, String formula) {
        if (formula.length() < param.length()) {
            return false;
        }
        if (formula.length() == param.length()) {
            if (formula.startsWith(param)) {
                return true;
            }
            return false;
        }
        if (!Character.isLetterOrDigit(formula.charAt(param.length())) && formula.charAt(param.length()) != '_') {
            if (formula.startsWith(param)) {
                return true;
            }
            return false;
        }
        return false;
    }

    private String getComponent(String name, Integer pCount) {
        try {
            FileReader frRepo = new FileReader(this.repoFile);
            BufferedReader brRepo = new BufferedReader(frRepo);
            String def = "";
            StringBuilder line = new StringBuilder();
            String temp = null;
            while ((temp = brRepo.readLine()) != null) {
                line.setLength(0);
                line.append(temp.trim());
                if (!temp.trim().startsWith(String.valueOf(name) + "(")) continue;
                while (!line.toString().endsWith(";")) {
                    temp = brRepo.readLine();
                    if (temp == null) break;
                    line.append(temp.trim());
                }
                def = line.toString().substring(0, line.indexOf(":"));
                String[] split = def.split(",");
                if (split.length == pCount) break;
            }
            brRepo.close();
            frRepo.close();
            String outLine = line.toString().trim();
            if (outLine.endsWith(";")) {
                outLine = outLine.substring(0, outLine.length() - 1);
            }
            return outLine;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

