dtmc

// Server A, running two instances of tier 1 and 1 instance of tier 2
// VIRTUALIZED_2_1
// - pA = probability that server does not fail
// - pVMA = probability that VM does not fail

const double pA;
const double pVMA;

const int N1A=2;
const int N2A=1;

module ServerA
  sA: [0..2] init 0;
  doneA: bool init false;

  [] sA=0 & stage=1 -> pA:(sA'=1) + (1-pA):(sA'=2);

  // sA=1 server alive
  // sA=2 server failed

  [] sA>0 & !doneA & (i1A=N1A) & (i2A=N2A) -> 1:(doneA'=true);
  [] sA>0 & doneA -> true; 
endmodule 

module FirstTierA
  i1A: [0..N1A] init 0;    // index VM
  n1A: [0..N1A] init N1A;  // VMs left operational at the end of the period

  // server alive, but VMs can fail independently
  [] i1A<N1A & sA=1 -> pVMA:(i1A'=i1A+1) + (1-pVMA):(i1A'=i1A+1)&(n1A'=n1A-1);

  // server failed
  [] i1A=0 & sA=2 -> 1:(i1A'=N1A)&(n1A'=0);

  // done
  [] i1A=N1A -> true;
endmodule

module SecondTierA
  i2A: [0..N2A] init 0;   // index VM
  n2A: [0..N2A] init N2A;  // VMs left operational at the end of the period

  // server alive, but VMs can fail independently
  [] i2A<N2A & sA=1 -> pVMA:(i2A'=i2A+1) + (1-pVMA):(i2A'=i2A+1)&(n2A'=n2A-1);

  // server failed
  [] i2A=0 & sA=2 -> 1:(i2A'=N2A)&(n2A'=0);

  // done
  [] i2A=N2A -> true;
endmodule

// ==================================================

// Server B, running two instances of tier 1 and 1 instance of tier 2
// VIRTUALIZED_2_1
// - pB = probability that server does not fail
// - pVMB = probability that VM does not fail

const double pB;
const double pVMB;

const int N1B=2;
const int N2B=1;

module ServerB
  sB: [0..2] init 0;
  doneB: bool init false;

  [] sB=0 & stage=2 -> pB:(sB'=1) + (1-pB):(sB'=2);

  // sB=1 server alive
  // sB=2 server failed

  [] sB>0 & !doneB & (i1B=N1B) & (i2B=N2B) -> 1:(doneB'=true);
  [] sB>0 & doneB -> true; 
endmodule 

module FirstTierB
  i1B: [0..N1B] init 0;    // index VM
  n1B: [0..N1B] init N1B;  // VMs left operational at the end of the period

  // server alive, but VMs can fail independently
  [] i1B<N1B & sB=1 -> pVMB:(i1B'=i1B+1) + (1-pVMB):(i1B'=i1B+1)&(n1B'=n1B-1);

  // server failed
  [] i1B=0 & sB=2 -> 1:(i1B'=N1B)&(n1B'=0);

  // done
  [] i1B=N1B -> true;
endmodule

module SecondTierB
  i2B: [0..N2B] init 0;   // index VM
  n2B: [0..N2B] init N2B;  // VMs left operational at the end of the period

  // server alive, but VMs can fail independently
  [] i2B<N2B & sB=1 -> pVMB:(i2B'=i2B+1) + (1-pVMB):(i2B'=i2B+1)&(n2B'=n2B-1);

  // server failed
  [] i2B=0 & sB=2 -> 1:(i2B'=N2B)&(n2B'=0);

  // done
  [] i2B=N2B -> true;
endmodule

// ==================================================

// Server C, running one instance of tier 2 and 1 instance of tier 3
// VIRTUALIZED_1_1
// - pC = probability that server does not fail
// - pVMC = probability that VM does not fail

const double pC;
const double pVMC;

const int N1C=1;
const int N2C=1;

module ServerC
  sC: [0..2] init 0;
  doneC: bool init false;

  [] sC=0 & stage=3 -> pC:(sC'=1) + (1-pC):(sC'=2);

  // sC=1 server alive
  // sC=2 server failed

  [] sC>0 & !doneC & (i1C=N1C) & (i2C=N2C) -> 1:(doneC'=true);
  [] sC>0 & doneC -> true; 
endmodule 

module FirstTierC
  i1C: [0..N1C] init 0;    // index VM
  n1C: [0..N1C] init N1C;  // VMs left operational at the end of the period

  // server alive, but VMs can fail independently
  [] i1C<N1C & sC=1 -> pVMC:(i1C'=i1C+1) + (1-pVMC):(i1C'=i1C+1)&(n1C'=n1C-1);

  // server failed
  [] i1C=0 & sC=2 -> 1:(i1C'=N1C)&(n1C'=0);

  // done
  [] i1C=N1C -> true;
endmodule

module SecondTierC
  i2C: [0..N2C] init 0;   // index VM
  n2C: [0..N2C] init N2C;  // VMs left operational at the end of the period

  // server alive, but VMs can fail independently
  [] i2C<N2C & sC=1 -> pVMC:(i2C'=i2C+1) + (1-pVMC):(i2C'=i2C+1)&(n2C'=n2C-1);

  // server failed
  [] i2C=0 & sC=2 -> 1:(i2C'=N2C)&(n2C'=0);

  // done
  [] i2C=N2C -> true;
endmodule

// ==================================================

// Server D, running one instance of tier 2 and 1 instance of tier 3
// VIRTUALIZED_1_1
// - pD = probability that server does not fail
// - pVMD = probability that VM does not fail

const double pD;
const double pVMD;

const int N1D=1;
const int N2D=1;

module ServerD
  sD: [0..2] init 0;
  doneD: bool init false;

  [] sD=0 & stage=4 -> pD:(sD'=1) + (1-pD):(sD'=2);

  // sD=1 server alive
  // sD=2 server failed

  [] sD>0 & !doneD & (i1D=N1D) & (i2D=N2D) -> 1:(doneD'=true);
  [] sD>0 & doneD -> true; 
endmodule 

module FirstTierD
  i1D: [0..N1D] init 0;    // index VM
  n1D: [0..N1D] init N1D;  // VMs left operational at the end of the period

  // server alive, but VMs can fail independently
  [] i1D<N1D & sD=1 -> pVMD:(i1D'=i1D+1) + (1-pVMD):(i1D'=i1D+1)&(n1D'=n1D-1);

  // server failed
  [] i1D=0 & sD=2 -> 1:(i1D'=N1D)&(n1D'=0);

  // done
  [] i1D=N1D -> true;
endmodule

module SecondTierD
  i2D: [0..N2D] init 0;   // index VM
  n2D: [0..N2D] init N2D;  // VMs left operational at the end of the period

  // server alive, but VMs can fail independently
  [] i2D<N2D & sD=1 -> pVMD:(i2D'=i2D+1) + (1-pVMD):(i2D'=i2D+1)&(n2D'=n2D-1);

  // server failed
  [] i2D=0 & sD=2 -> 1:(i2D'=N2D)&(n2D'=0);

  // done
  [] i2D=N2D -> true;
endmodule

// ==================================================

// System tier instances are as follows:
// - Tier1: n1=n1A+n1B
// - Tier2: n2=n2A+n2B+n1C+n1D
// - Tier3: n3=n2C+n2D
//
// Properties to verify: 
// - Pfail: P=?[F done & fail] 
// - Pspf:  P=?[F done & succ] 

module System
  stage :[1..5] init 1;
  done: bool init false; 
  fail: bool init false;
  spf: bool init false;

  [] stage=1 & doneA -> 1:(stage'=2);
  [] stage=2 & doneB -> 1:(stage'=3);
  [] stage=3 & doneC -> 1:(stage'=4);
  [] stage=4 & doneD -> 1:(stage'=5);
  [] stage=5 & !done -> 1:(done'=true)&
                          (fail'=(n1A+n1B=0|n2A+n2B+n1C+n1D=0|n2C+n2D=0))&
                          (spf'=(n1A+n1B>0&n2A+n2B+n1C+n1D>0&n2C+n2D>0&(n1A+n1B=1|n2A+n2B+n1C+n1D=1|n2C+n2D=1)));
  [] done -> true;
endmodule

