dtmc

/// A: VIRTUALIZED-M_1_1(pA,pdA,pmA,rA,pVMA)
/// B: VIRTUALIZED-M_1_1(pB,pdB,pmB,rB,pVMB)
/// C: BASIC_1(pC)
/// D: BASIC_1(pD)

const double p11A;
const double p10A;
const double p01A;
const double p00A;
const double p11B;
const double p10B;
const double p01B;
const double p00B;
const double p1C;
const double p0C;
const double p1D;
const double p0D;

module System
  tier1: [0..2] init 2;
  tier2: [0..2] init 2;
  tier3: [0..2] init 2;
  stage: [1..5] init 1;
  done: bool init false;
  fail: bool init false;
  spf: bool init false;

  [] stage=1 -> p11A:(stage'=2) + p10A:(stage'=2)&(tier2'=1) + p01A:(stage'=2)&(tier1'=1) + p00A:(stage'=2)&(tier1'=1)&(tier2'=1);

  [] stage=2&tier1=2&tier2=2 -> p11B:(stage'=3) + p10B:(stage'=3)&(tier2'=1) + p01B:(stage'=3)&(tier1'=1) + p00B:(stage'=3)&(tier1'=1)&(tier2'=1);
  [] stage=2&tier1=2&tier2=1 -> p11B:(stage'=3) + (p10B+p00B):(stage'=5)&(fail'=true) + p01B:(stage'=3)&(tier1'=1);
  [] stage=2&tier1=1&tier2=2 -> p11B:(stage'=3) + p10B:(stage'=3)&(tier2'=1) + (p01B+p00B):(stage'=5)&(fail'=true);
  [] stage=2&tier1=1&tier2=1 -> p11B:(stage'=3) + (1-p11B):(stage'=5)&(fail'=true);

  [] stage=3&tier1=2&tier2=2 -> p1C:(stage'=4) + p0C:(stage'=4)&(tier3'=1);
  [] stage=3&(tier1!=2|tier2!=2) -> p1C:(stage'=5)&(spf'=true) + p0C:(stage'=4)&(tier3'=1);

  [] stage=4&tier3=2 -> p1D:(stage'=5) + p0D:(stage'=5)&(spf'=true);
  [] stage=4&tier3=1 -> p1D:(stage'=5)&(spf'=true) + p0D:(stage'=5)&(fail'=true);

  [] stage=5 -> 1:(done'=true);
endmodule



