dtmc

/// A: VIRTUALIZED-M_2_1(pA,pdA,pmA,rA,pVMA)
/// B: VIRTUALIZED-M_2_1(pB,pdB,pmB,rB,pVMB)
/// C: VIRTUALIZED-M_1_1(pC,pdC,pmC,rC,pVMC)
/// D: VIRTUALIZED-M_1_1(pD,pdD,pmD,rD,pVMD)

const double p21A;
const double p20A;
const double p11A;
const double p10A;
const double p01A;
const double p00A;
const double p21B;
const double p20B;
const double p11B;
const double p10B;
const double p01B;
const double p00B;
const double p11C;
const double p10C;
const double p01C;
const double p00C;
const double p11D;
const double p10D;
const double p01D;
const double p00D;

module System
  tier1: [0..4] init 4;
  tier2: [0..4] init 4;
  tier3: [0..2] init 2;
  stage: [1..5] init 1;
  done: bool init false;
  fail: bool init false;
  spf: bool init false;

  [] stage=1 -> p21A:(stage'=2) + p20A:(stage'=2)&(tier2'=3) + 
                p11A:(stage'=2)&(tier1'=3) + p10A:(stage'=2)&(tier1'=3)&(tier2'=3) + 
                p01A:(stage'=2)&(tier1'=2) + p00A:(stage'=2)&(tier1'=2)&(tier2'=3);

  [] stage=2&tier1>2 -> p21B:(stage'=3) + p20B:(stage'=3)&(tier2'=tier2-1) + 
                        p11B:(stage'=3)&(tier1'=tier1-1) + p10B:(stage'=3)&(tier1'=tier1-1)&(tier2'=tier2-1) + 
                        p01B:(stage'=3)&(tier1'=tier1-2) + p00B:(stage'=3)&(tier1'=tier1-2)&(tier2'=tier2-1);
  [] stage=2&tier1=2 -> p21B:(stage'=3) + p20B:(stage'=3)&(tier2'=tier2-1) + 
                        p11B:(stage'=3)&(tier1'=tier1-1) + p10B:(stage'=3)&(tier1'=tier1-1)&(tier2'=tier2-1) +
                        (p01B+p00B):(stage'=5)&(fail'=true);

  [] stage=3&tier1>1 -> p11C:(stage'=4) + p10C:(stage'=4)&(tier3'=1) + p01C:(stage'=4)&(tier2'=tier2-1) + p00C:(stage'=4)&(tier2'=tier2-1)&(tier3'=1);
  [] stage=3&tier1=1 -> p11C:(stage'=5)&(spf'=true) + p10C:(stage'=4)&(tier3'=1) + p01C:(stage'=4)&(tier2'=tier2-1) + p00C:(stage'=4)&(tier2'=tier2-1)&(tier3'=1); 

  //[] stage=4&tier1>1&tier2>2&tier3=2 -> (p11D+p01D):(stage'=5) + (p10D+p00D):(stage'=5)&(spf'=true);
  //[] stage=4&tier1>1&tier2=2&tier3=2 -> p11D:(stage'=5) + (1-p11D):(stage'=5)&(spf'=true);
  //[] stage=4&tier2>1&tier3=1 -> (p11D+p01D):(stage'=5)&(spf'=true) + (p10D+p00D):(stage'=5)&(fail'=true);
  //[] stage=4&tier2=1&tier3>1 -> (p11D+p10D):(stage'=5)&(spf'=true) + (p01D+p00D):(stage'=5)&(fail'=true);
  //[] stage=4&tier2=1&tier3=1 -> p11D:(stage'=5)&(spf'=true) + (1-p11D):(stage'=5)&(fail'=true);

  [] stage=4 -> p11D:(stage'=5)&(spf'=(tier1=1|tier2=1|tier3=1)) + // failure not possible in this case
                p10D:(stage'=5)&(spf'=(tier3=2))&(fail'=(tier3=1)) + // failure if tier 3 was already left with a single instance; spf otherwise (due to tier 3)
                p01D:(stage'=5)&(spf'=tier2>1&(tier1=1|tier2=2|tier3=1))&(fail'=(tier2=1)) + // failure possible if tier 2 was already left with a single instance
                p00D:(stage'=5)&(spf'=tier2>1&tier3>1&(tier1=1|tier2=2|tier3=2))&(fail'=(tier2=1|tier3=1));

  [] stage=5 -> 1:(done'=true);
endmodule



