/*
 * Decompiled with CFR 0.152.
 */
package veracity;

import application.model.ExperimentData;
import application.model.Settings;
import confidenceIntervalCalculation.ConfidenceInterval;
import eFACT.Substitution;
import eFACT.ePMC;
import framework.FactFramework;
import inputOutput.Time;
import java.io.IOException;
import logging.FACTLogger;
import mathEngine.MatLabEngine;
import parametricModelChecking.OperatingSystem;
import parametricModelChecking.PrismParametricModelChecker;

public class Execute {
    private ExperimentData data = null;
    private FACTLogger flog = new FACTLogger();
    ePMC epmc = new ePMC();
    FactFramework fact;
    int type = 0;

    public Execute(ExperimentData _data, FACTLogger _flog, ePMC _epmc, int _type) {
        this.data = _data;
        this.flog = _flog;
        this.epmc = _epmc;
        this.type = _type;
    }

    public String run(MatLabEngine e) {
        this.flog.add("\n\n***********Run called***********\n\n");
        this.data.running = true;
        this.data.timer = new Time();
        FactFramework fact = this.data.fact;
        Settings settings = new Settings();
        settings.read();
        if (settings.get("PRISMLocation") != null) {
            ExperimentData.PRISMLOCATION = settings.get("PRISMLocation");
        }
        fact.setPpmc(new PrismParametricModelChecker(ExperimentData.PRISMLOCATION, OperatingSystem.MAC));
        fact.setMathsEngine(e);
        this.data.populateFACT();
        if (this.type == 0) {
            this.data.fInput.ciResults.clear();
            fact.resetSimultaneousConfidenceIntervalCalculator(this.data.fInput);
            this.data.flog.add("Prism is attempting parametric model checking");
            this.data.fInput.algebraicExpression = fact.getPpmc().modelCheck(this.data.fInput.model, this.data.fInput.property, this.data.flog);
        } else {
            Substitution sub = new Substitution();
            try {
                this.epmc.executeEPMC();
                int i = 0;
                while (i < ePMC.epmcVariables.size()) {
                    this.epmc.findValVar("testModel.pm", ePMC.epmcVariables.get(i));
                    ++i;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                this.epmc.intermediateFormula("ePMCoutput.m");
                this.epmc.mainFormulas("ePMCoutput.m");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            sub.equation_substitution(this.epmc);
            this.data.fInput.ciResults.clear();
            fact.resetSimultaneousConfidenceIntervalCalculator(this.data.fInput);
            this.data.flog.add("\nePMC is attempting\n");
            this.data.flog.add("\n" + this.epmc.invokedTool + "\n");
            this.data.flog.add("Short Expression is: \n" + this.epmc.mainFormula);
            this.data.flog.add("\nFull Expression is: \n" + this.epmc.fullMainFormula);
            this.data.fInput.algebraicExpression = this.epmc.getAlgebraicExpression(this.epmc.getMainFormula());
        }
        fact.nextStepCalculateConfidenceInterval(this.data.fInput);
        ConfidenceInterval ci = fact.getLastComputedCI();
        String result = fact.getLastComputedCI().toString();
        this.data.flog.add(result);
        this.data.timer.stop();
        this.data.flog.add("Time to calculate: " + this.data.fInput.timing.toString() + "s");
        String sPoly = this.data.fInput.algebraicExpression.poly;
        if (sPoly.length() == 0) {
            this.data.flog.add("Prism failed to return a polynomial");
            this.data.running = false;
            return "";
        }
        this.data.flog.add("Model checking complete");
        this.data.flog.add("-----------------------------------------------------");
        this.data.flog.add("Polynomial sent to Matlab:");
        this.data.flog.add(sPoly);
        this.data.flog.add("Calculated in " + this.data.timer + " seconds");
        this.data.flog.add("-----------------------------------------------------");
        this.data.flog.add("Hill Climbing Max Iterations: " + this.data.fInput.config.MAX_ITERATIONS);
        return result;
    }

    public void invokePrism() {
        this.data.fInput.ciResults.clear();
        this.fact.resetSimultaneousConfidenceIntervalCalculator(this.data.fInput);
        this.data.flog.add("Prism is attempting parametric model checking");
        this.data.fInput.algebraicExpression = this.fact.getPpmc().modelCheck(this.data.fInput.model, this.data.fInput.property, this.data.flog);
    }

    public void invokePMC() {
        Substitution sub = new Substitution();
        this.epmc.epmcFilesDelete();
        this.epmc.epmcArrayClear();
        try {
            this.epmc.executeEPMC();
            int i = 0;
            while (i < ePMC.epmcVariables.size()) {
                this.epmc.findValVar("testModel.pm", ePMC.epmcVariables.get(i));
                ++i;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            this.epmc.intermediateFormula("ePMCoutput.m");
            this.epmc.mainFormulas("ePMCoutput.m");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        sub.equation_substitution(this.epmc);
        this.data.fInput.ciResults.clear();
        this.fact.resetSimultaneousConfidenceIntervalCalculator(this.data.fInput);
        this.data.flog.add("\nePMC is attempting\n");
        this.data.flog.add("\n" + this.epmc.invokedTool + "\n");
        this.data.flog.add("Short Expression is: \n" + this.epmc.mainFormula);
        this.data.flog.add("\nFull Expression is: \n" + this.epmc.fullMainFormula);
        this.data.fInput.algebraicExpression = this.epmc.getAlgebraicExpression(this.epmc.getMainFormula());
    }
}

