/*
 * Decompiled with CFR 0.152.
 */
package testingHeuristic;

import java.util.Hashtable;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import testingHeuristic.Parameter;
import testingHeuristic.Requirement;

public class TestHeuristic {
    private static double violationMarginEpsilon = 0.85;

    private double[] computeImportance(String property, int nComponents, Hashtable<String, Parameter> parameters) {
        double[] componentImportance = new double[nComponents];
        int i = 0;
        while (i < nComponents) {
            componentImportance[i] = 0.0;
            ++i;
        }
        Argument[] arguments = new Argument[parameters.size()];
        int i2 = 0;
        for (String paramName2 : parameters.keySet()) {
            arguments[i2++] = new Argument(String.valueOf(paramName2) + " = " + parameters.get((Object)paramName2).value, new PrimitiveElement[0]);
        }
        System.out.println("  -- Importance factors for property " + property);
        parameters.forEach((paramName, param) -> {
            String derivProperty = "der(" + property + "," + paramName + ")";
            Expression e = new Expression(derivProperty, (PrimitiveElement[])arguments);
            double importance = Math.abs(e.calculate());
            int n = param.componentID;
            dArray[n] = componentImportance[n] + importance;
            System.out.println("     " + paramName + " has importance " + importance + " (added to component " + (param.componentID + 1) + ")");
        });
        return componentImportance;
    }

    public int[] computeObservations(Requirement[] requirements, double[] costs, Hashtable<String, Parameter> parameters, int budget, boolean firstRound, boolean uniformTesting) {
        if (firstRound) {
            System.out.println("** Requirements not checked in round 1");
            return this.computeUniformObservations(costs, budget);
        }
        int nSatisfiedRequirements = 0;
        int worstRequirementIndex = -1;
        double worstViolationMargin = 1.0;
        System.out.println("** Checking requirements");
        int i = 0;
        while (i < requirements.length) {
            Requirement req = requirements[i];
            if (req.belowThreshold && req.upperBound <= req.threshold || !req.belowThreshold && req.lowerBound >= req.threshold) {
                System.out.println("  -- Requirement " + req.originalReq + " is satisfied: [" + req.lowerBound + "," + req.upperBound + "] is " + (req.belowThreshold ? "below" : "above") + " " + req.threshold);
                req.satisfied = true;
                ++nSatisfiedRequirements;
            } else {
                double margin;
                if (req.belowThreshold && req.lowerBound >= req.threshold || !req.belowThreshold && req.upperBound <= req.threshold) {
                    System.out.println("  -- Requirement " + req.originalReq + " is violated: [" + req.lowerBound + "," + req.upperBound + "] is not " + (req.belowThreshold ? "below" : "above") + " " + req.threshold);
                    System.out.println("** Further testing is not required: the set of requirements as a whole is violated");
                    return null;
                }
                System.out.println("  -- Requirement " + req.originalReq + " is undecidable: " + req.threshold + " is inside [" + req.lowerBound + "," + req.upperBound + "]");
                double d1 = req.upperBound - req.threshold;
                double d2 = req.threshold - req.lowerBound;
                double d = margin = req.belowThreshold ? d2 / d1 : d1 / d2;
                if (margin < 1.0 - violationMarginEpsilon && margin < worstViolationMargin) {
                    worstViolationMargin = margin;
                    worstRequirementIndex = i;
                }
            }
            ++i;
        }
        if (nSatisfiedRequirements == requirements.length) {
            System.out.println("** Further testing is not required: all requirements are satisfied");
            return null;
        }
        if (uniformTesting) {
            return this.computeUniformObservations(costs, budget);
        }
        int nComponents = costs.length;
        double[] componentImportance = new double[nComponents];
        int i2 = 0;
        while (i2 < nComponents) {
            componentImportance[i2] = 0.0;
            ++i2;
        }
        if (worstRequirementIndex != -1) {
            double[] importance = this.computeImportance(requirements[worstRequirementIndex].property, nComponents, parameters);
            int j = 0;
            while (j < nComponents) {
                int n = j;
                componentImportance[n] = componentImportance[n] + importance[j];
                ++j;
            }
        } else {
            i2 = 0;
            while (i2 < requirements.length) {
                Requirement req = requirements[i2];
                if (!req.satisfied) {
                    double[] importance = this.computeImportance(req.property, nComponents, parameters);
                    double d1 = req.upperBound - req.threshold;
                    double d2 = req.threshold - req.lowerBound;
                    double diff = Math.abs(d1 - d2);
                    if (diff < 1.0E-6) {
                        diff = 1.0E-6;
                    }
                    double weight = (d1 + d2) / diff;
                    int j = 0;
                    while (j < nComponents) {
                        int n = j;
                        componentImportance[n] = componentImportance[n] + weight * importance[j];
                        ++j;
                    }
                }
                ++i2;
            }
        }
        double totalImportance = 0.0;
        int[] newObservations = new int[nComponents];
        int i3 = 0;
        while (i3 < nComponents) {
            totalImportance += componentImportance[i3];
            ++i3;
        }
        i3 = 0;
        while (i3 < nComponents) {
            double budgetForThisComponent = (double)budget * componentImportance[i3] / totalImportance;
            newObservations[i3] = (int)(budgetForThisComponent / costs[i3]);
            ++i3;
        }
        return newObservations;
    }

    public int[] computeUniformObservations(double[] costs, double budget) {
        int nComponents = costs.length;
        int[] newObservations = new int[nComponents];
        int i = 0;
        while (i < nComponents) {
            newObservations[i] = (int)(budget / ((double)nComponents * costs[i]));
            ++i;
        }
        return newObservations;
    }
}

