/*
 * Decompiled with CFR 0.152.
 */
package parametricModelChecking;

import inputOutput.FileUtils;
import java.io.File;
import logging.FACTLogger;
import parametricModelChecking.AlgebraicExpression;
import parametricModelChecking.OperatingSystem;
import parametricModelChecking.ParametricProbabilisticModel;
import parametricModelChecking.ParametricProbabilisticModelChecker;
import parametricModelChecking.Property;

public class PrismParametricModelChecker
implements ParametricProbabilisticModelChecker {
    private static final String tempModelFile = "modelprism";
    private static final String tempPropertyFile = "prismtempproperty1";
    private String prismExeFile;
    private OperatingSystem os;

    public PrismParametricModelChecker(String executableLocation, OperatingSystem os) {
        this.prismExeFile = executableLocation;
        String operatingSystem = System.getProperty("os.name");
        this.os = operatingSystem.toLowerCase().startsWith("win") ? OperatingSystem.WINDOWS : OperatingSystem.MAC;
    }

    private String executeMacPrism(ParametricProbabilisticModel m, Property p, FACTLogger flog) {
        int rightCurlyBracket;
        File modelFile = FileUtils.writeTemporaryTextFile(tempModelFile, m.getModel());
        File propertyFile = FileUtils.writeTemporaryTextFile(tempPropertyFile, p.getProperty());
        String paramList = "";
        for (String parm : m.getParams().keySet()) {
            paramList = String.valueOf(paramList) + parm + "=" + m.getParams().get(parm) + ",";
        }
        paramList = paramList.substring(0, paramList.lastIndexOf(44));
        paramList = String.valueOf(modelFile.getAbsolutePath()) + " " + propertyFile.getAbsolutePath() + " -param " + paramList;
        String modelCheckerOutput = FileUtils.execute(this.prismExeFile, paramList, flog);
        int leftCurlyBracket = modelCheckerOutput.lastIndexOf(123);
        if (leftCurlyBracket < (rightCurlyBracket = modelCheckerOutput.lastIndexOf(125)) && leftCurlyBracket >= 0 && rightCurlyBracket >= 0) {
            String poly = modelCheckerOutput.substring(leftCurlyBracket + 1, rightCurlyBracket - 1);
            return poly;
        }
        return "";
    }

    private String executeWinPrism(ParametricProbabilisticModel m, Property p, FACTLogger flog) {
        int rightCurlyBracket;
        File modelFile = FileUtils.writeTemporaryTextFile(tempModelFile, m.getModel());
        File propertyFile = FileUtils.writeTemporaryTextFile(tempPropertyFile, p.getProperty());
        String paramList = "";
        for (String parm : m.getParams().keySet()) {
            paramList = String.valueOf(paramList) + parm + "=" + m.getParams().get(parm) + ",";
        }
        paramList = paramList.substring(0, paramList.lastIndexOf(44));
        paramList = String.valueOf(modelFile.getAbsolutePath()) + " " + propertyFile.getAbsolutePath() + " -param " + paramList;
        String modelCheckerOutput = FileUtils.executeWinBatch(this.prismExeFile, paramList, flog);
        int leftCurlyBracket = modelCheckerOutput.lastIndexOf(123);
        if (leftCurlyBracket < (rightCurlyBracket = modelCheckerOutput.lastIndexOf(125)) && leftCurlyBracket >= 0 && rightCurlyBracket >= 0) {
            String poly = modelCheckerOutput.substring(leftCurlyBracket + 1, rightCurlyBracket - 1);
            return poly;
        }
        return "";
    }

    @Override
    public AlgebraicExpression modelCheck(ParametricProbabilisticModel m, Property p, FACTLogger flog) {
        if (this.os == OperatingSystem.MAC) {
            String ae = this.executeMacPrism(m, p, flog);
            AlgebraicExpression a = new AlgebraicExpression(ae);
            return a;
        }
        if (this.os == OperatingSystem.WINDOWS) {
            String ae = this.executeWinPrism(m, p, flog);
            AlgebraicExpression a = new AlgebraicExpression(ae);
            return a;
        }
        return null;
    }
}

