/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import matlabcontrol.Configuration;
import matlabcontrol.JMIWrapperRemote;
import matlabcontrol.LocalHostRMIHelper;
import matlabcontrol.MatlabClassLoaderHelper;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabConnector;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;
import matlabcontrol.MatlabProxyFactoryOptions;
import matlabcontrol.MatlabSessionImpl;
import matlabcontrol.ProxyFactory;
import matlabcontrol.RemoteMatlabProxy;
import matlabcontrol.RequestReceiver;

class RemoteMatlabProxyFactory
implements ProxyFactory {
    private final MatlabProxyFactoryOptions _options;
    private final CopyOnWriteArrayList<RemoteRequestReceiver> _receivers = new CopyOnWriteArrayList();
    static final long RECEIVER_CHECK_PERIOD = 1000L;
    private volatile Registry _registry = null;

    public RemoteMatlabProxyFactory(MatlabProxyFactoryOptions options) {
        this._options = options;
    }

    @Override
    public MatlabProxyFactory.Request requestProxy(MatlabProxyFactory.RequestCallback requestCallback) throws MatlabConnectionException {
        RemoteRequest request;
        RemoteIdentifier proxyID = new RemoteIdentifier();
        this.initRegistry(false);
        RemoteRequestReceiver receiver = new RemoteRequestReceiver(requestCallback, proxyID, Configuration.getClassPathAsRMICodebase(), Configuration.getClassPathAsCanonicalPaths());
        this._receivers.add(receiver);
        try {
            this._registry.bind(receiver.getReceiverID(), LocalHostRMIHelper.exportObject(receiver));
        }
        catch (RemoteException ex) {
            this._receivers.remove(receiver);
            throw new MatlabConnectionException("Could not bind proxy receiver to the RMI registry", ex);
        }
        catch (AlreadyBoundException ex) {
            this._receivers.remove(receiver);
            throw new MatlabConnectionException("Could not bind proxy receiver to the RMI registry", ex);
        }
        RequestMaintainer maintainer = new RequestMaintainer(receiver);
        try {
            if (this._options.getUsePreviouslyControlledSession() && MatlabSessionImpl.connectToRunningSession(receiver.getReceiverID(), this._options.getPort())) {
                request = new RemoteRequest(proxyID, null, receiver, maintainer);
            } else {
                Process process = this.createProcess(receiver);
                request = new RemoteRequest(proxyID, process, receiver, maintainer);
            }
        }
        catch (MatlabConnectionException e) {
            maintainer.shutdown();
            receiver.shutdown();
            throw e;
        }
        return request;
    }

    @Override
    public MatlabProxy getProxy() throws MatlabConnectionException {
        GetProxyRequestCallback callback = new GetProxyRequestCallback();
        MatlabProxyFactory.Request request = this.requestProxy(callback);
        try {
            block5: {
                try {
                    Thread.sleep(this._options.getProxyTimeout());
                }
                catch (InterruptedException e) {
                    if (callback.getProxy() != null) break block5;
                    throw new MatlabConnectionException("Thread was interrupted while waiting for MATLAB proxy", e);
                }
            }
            if (callback.getProxy() == null) {
                throw new MatlabConnectionException("MATLAB proxy could not be created in " + this._options.getProxyTimeout() + " milliseconds");
            }
            return callback.getProxy();
        }
        catch (MatlabConnectionException e) {
            request.cancel();
            throw e;
        }
    }

    private synchronized void initRegistry(boolean force) throws MatlabConnectionException {
        if (this._registry == null || force) {
            try {
                this._registry = LocalHostRMIHelper.createRegistry(this._options.getPort());
            }
            catch (Exception e) {
                try {
                    this._registry = LocalHostRMIHelper.getRegistry(this._options.getPort());
                }
                catch (Exception ex) {
                    throw new MatlabConnectionException("Could not create or connect to the RMI registry", ex);
                }
            }
        }
    }

    private Process createProcess(RemoteRequestReceiver receiver) throws MatlabConnectionException {
        ArrayList<String> processArguments = new ArrayList<String>();
        if (this._options.getMatlabLocation() != null) {
            processArguments.add(this._options.getMatlabLocation());
        } else {
            processArguments.add(Configuration.getMatlabLocation());
        }
        if (this._options.getHidden()) {
            if (Configuration.isWindows()) {
                processArguments.add("-automation");
            } else {
                processArguments.add("-nosplash");
                processArguments.add("-nodesktop");
            }
        } else if (!Configuration.isWindows()) {
            processArguments.add("-desktop");
        }
        if (this._options.getLicenseFile() != null) {
            processArguments.add("-c");
            processArguments.add(this._options.getLicenseFile());
        }
        if (this._options.getLogFile() != null) {
            processArguments.add("-logfile");
            processArguments.add(this._options.getLogFile());
        }
        if (this._options.getJavaDebugger() != null) {
            processArguments.add("-jdb");
            processArguments.add(this._options.getJavaDebugger().toString());
        }
        if (this._options.getUseSingleComputationalThread()) {
            processArguments.add("-singleCompThread");
        }
        processArguments.add("-r");
        String codeLocation = Configuration.getSupportCodeLocation();
        String runArg = "javaaddpath '" + codeLocation + "'; " + MatlabClassLoaderHelper.class.getName() + ".configureClassLoading(); " + "javarmpath '" + codeLocation + "'; " + MatlabConnector.class.getName() + ".connectFromMatlab('" + receiver.getReceiverID() + "', " + this._options.getPort() + ");";
        processArguments.add(runArg);
        ProcessBuilder builder = new ProcessBuilder(processArguments);
        builder.directory(this._options.getStartingDirectory());
        try {
            Process process = builder.start();
            if (this._options.getHidden() && !Configuration.isWindows()) {
                new ProcessStreamDrainer(process.getInputStream(), "Input").start();
                new ProcessStreamDrainer(process.getErrorStream(), "Error").start();
            }
            return process;
        }
        catch (IOException e) {
            String errorMsg = "Could not launch MATLAB. This is likely caused by MATLAB not being in a known location or on a known path. MATLAB's location can be explicitly provided by using " + MatlabProxyFactoryOptions.Builder.class.getCanonicalName() + "'s setMatlabLocation(...) method.\n" + "OS: " + Configuration.getOperatingSystem() + "\n" + "Command: " + builder.command() + "\n" + "Environment: " + builder.environment();
            throw new MatlabConnectionException(errorMsg, e);
        }
    }

    private static class RemoteRequest
    implements MatlabProxyFactory.Request {
        private final MatlabProxy.Identifier _proxyID;
        private final Process _process;
        private final RemoteRequestReceiver _receiver;
        private final RequestMaintainer _maintainer;
        private boolean _isCancelled = false;

        private RemoteRequest(MatlabProxy.Identifier proxyID, Process process, RemoteRequestReceiver receiver, RequestMaintainer maintainer) {
            this._proxyID = proxyID;
            this._process = process;
            this._receiver = receiver;
            this._maintainer = maintainer;
        }

        @Override
        public MatlabProxy.Identifier getProxyIdentifer() {
            return this._proxyID;
        }

        @Override
        public synchronized boolean cancel() {
            if (!this._isCancelled) {
                boolean success;
                this._maintainer.shutdown();
                if (!this.isCompleted()) {
                    if (this._process != null) {
                        this._process.destroy();
                    }
                    success = this._receiver.shutdown();
                } else {
                    success = false;
                }
                this._isCancelled = success;
            }
            return this._isCancelled;
        }

        @Override
        public synchronized boolean isCancelled() {
            return this._isCancelled;
        }

        @Override
        public boolean isCompleted() {
            return this._receiver.hasReceivedJMIWrapper();
        }
    }

    private static final class RemoteIdentifier
    implements MatlabProxy.Identifier {
        private final UUID _id = UUID.randomUUID();

        private RemoteIdentifier() {
        }

        @Override
        public boolean equals(Object other) {
            boolean equals = other instanceof RemoteIdentifier ? ((RemoteIdentifier)other)._id.equals(this._id) : false;
            return equals;
        }

        @Override
        public int hashCode() {
            return this._id.hashCode();
        }

        public String toString() {
            return "PROXY_REMOTE_" + this._id;
        }

        String getUUIDString() {
            return this._id.toString();
        }
    }

    private static class GetProxyRequestCallback
    implements MatlabProxyFactory.RequestCallback {
        private final Thread _requestingThread = Thread.currentThread();
        private volatile MatlabProxy _proxy;

        @Override
        public void proxyCreated(MatlabProxy proxy) {
            this._proxy = proxy;
            this._requestingThread.interrupt();
        }

        public MatlabProxy getProxy() {
            return this._proxy;
        }
    }

    private class RequestMaintainer {
        private final Timer _timer;

        RequestMaintainer(final RemoteRequestReceiver receiver) {
            this._timer = new Timer("MLC Request Maintainer " + receiver.getReceiverID());
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        RemoteMatlabProxyFactory.this._registry.lookup(receiver.getReceiverID());
                    }
                    catch (NotBoundException e) {
                        try {
                            UnicastRemoteObject.unexportObject(receiver, true);
                        }
                        catch (NoSuchObjectException ex) {
                            // empty catch block
                        }
                        try {
                            RemoteMatlabProxyFactory.this._registry.bind(receiver.getReceiverID(), LocalHostRMIHelper.exportObject(receiver));
                        }
                        catch (RemoteException ex) {
                        }
                        catch (AlreadyBoundException ex) {}
                    }
                    catch (RemoteException e) {
                        try {
                            RemoteMatlabProxyFactory.this.initRegistry(true);
                            try {
                                UnicastRemoteObject.unexportObject(receiver, true);
                            }
                            catch (NoSuchObjectException ex) {
                                // empty catch block
                            }
                            try {
                                RemoteMatlabProxyFactory.this._registry.bind(receiver.getReceiverID(), LocalHostRMIHelper.exportObject(receiver));
                            }
                            catch (RemoteException ex) {
                            }
                            catch (AlreadyBoundException ex) {}
                        }
                        catch (MatlabConnectionException matlabConnectionException) {
                            // empty catch block
                        }
                    }
                    if (receiver.hasReceivedJMIWrapper()) {
                        RequestMaintainer.this._timer.cancel();
                    }
                }
            }, 1000L, 1000L);
        }

        void shutdown() {
            this._timer.cancel();
        }
    }

    private class RemoteRequestReceiver
    implements RequestReceiver {
        private final MatlabProxyFactory.RequestCallback _requestCallback;
        private final RemoteIdentifier _proxyID;
        private final String _codebase;
        private final String[] _canonicalPaths;
        private final String _receiverID;
        private volatile boolean _receivedJMIWrapper = false;

        public RemoteRequestReceiver(MatlabProxyFactory.RequestCallback requestCallback, RemoteIdentifier proxyID, String codebase, String[] canonicalPaths) {
            this._requestCallback = requestCallback;
            this._proxyID = proxyID;
            this._codebase = codebase;
            this._canonicalPaths = canonicalPaths;
            this._receiverID = "PROXY_RECEIVER_" + proxyID.getUUIDString();
        }

        @Override
        public void receiveJMIWrapper(JMIWrapperRemote jmiWrapper, boolean existingSession) {
            RemoteMatlabProxyFactory.this._receivers.remove(this);
            RemoteMatlabProxy proxy = new RemoteMatlabProxy(jmiWrapper, this, this._proxyID, existingSession);
            proxy.init();
            this._receivedJMIWrapper = true;
            this._requestCallback.proxyCreated(proxy);
        }

        @Override
        public String getReceiverID() {
            return this._receiverID;
        }

        public boolean shutdown() {
            boolean success;
            RemoteMatlabProxyFactory.this._receivers.remove(this);
            try {
                success = UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException e) {
                success = true;
            }
            return success;
        }

        public boolean hasReceivedJMIWrapper() {
            return this._receivedJMIWrapper;
        }

        @Override
        public String getClassPathAsRMICodebase() throws RemoteException {
            return this._codebase;
        }

        @Override
        public String[] getClassPathAsCanonicalPaths() throws RemoteException {
            return this._canonicalPaths;
        }
    }

    private static class ProcessStreamDrainer
    extends Thread {
        private final InputStream _stream;

        private ProcessStreamDrainer(InputStream stream, String type) {
            this._stream = stream;
            this.setDaemon(true);
            this.setName("ProcessStreamDrainer - " + type);
        }

        @Override
        public void run() {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this._stream));
                while (in.readLine() != null) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

