/*
 * Decompiled with CFR 0.152.
 */
package mathEngine;

import confidenceIntervalCalculation.ConfidenceInterval;
import confidenceIntervalCalculation.SimultaneousConfidenceIntervalCalculator;
import eFACT.ePMC;
import java.util.ArrayList;
import mathEngine.MathsEngine;
import mathEngine.MathsResult;
import mathEngine.MinMaxResult;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;
import matlabcontrol.MatlabProxyFactoryOptions;
import observations.StateParameterObservation;
import observations.TransitionParameter;
import parametricModelChecking.AlgebraicExpression;

public class MatLabEngine
implements MathsEngine {
    ePMC epmc = null;
    private MatlabProxyFactory matLabFactory;
    private MatlabProxy proxy;

    public MatLabEngine(ePMC epmc_) {
        this.epmc = epmc_;
        if (this.matLabFactory == null) {
            MatlabProxyFactoryOptions options = new MatlabProxyFactoryOptions.Builder().setHidden(true).setProxyTimeout(30000L).setUsePreviouslyControlledSession(true).build();
            this.matLabFactory = new MatlabProxyFactory(options);
            try {
                this.proxy = this.matLabFactory.getProxy();
            }
            catch (MatlabConnectionException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public MathsResult computeResult(AlgebraicExpression ae, SimultaneousConfidenceIntervalCalculator scic) {
        try {
            ArrayList<TransitionParameter> parameters = new ArrayList<TransitionParameter>();
            for (TransitionParameter tp : scic.getTransitionParameters()) {
                parameters.add(tp);
            }
            String varDefinition = "clear all";
            String var2 = "clear all";
            String element = "";
            String element_val = "";
            String requirement = "";
            String F = "\nF = [";
            String F1 = "";
            String F2 = "\nF = [";
            String undefinedVar = "\n";
            String additional_constraints = " ";
            String lhs = "";
            String rhs = "";
            String rmin = "\noptimize(F,Rmin,options)";
            String rmax = "\noptimize(F,Rmax,options)";
            String settingCommand = "\n options = sdpsettings('solver','bmibnb')";
            boolean x = true;
            String eq = "\n";
            for (TransitionParameter tp : parameters) {
                varDefinition = String.valueOf(varDefinition) + "\n" + tp.getLabel() + " = sdpvar(1,1)";
                ConfidenceInterval ci = scic.getConfidenceInterval(tp);
                F = String.valueOf(F) + "\n" + ci.getLowerBound() + "<=" + tp.getLabel() + "<=" + ci.getUpperBound() + ",";
            }
            for (StateParameterObservation sp : scic.stateParameterObservations()) {
                int nParameters = sp.getTransitionParameters().length;
                if (nParameters <= 1) continue;
                TransitionParameter[] transitionParameterArray = sp.getTransitionParameters();
                int n = transitionParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TransitionParameter tp = transitionParameterArray[n2];
                    eq = String.valueOf(eq) + tp.getLabel() + "+";
                    ++n2;
                }
                eq = eq.substring(0, eq.length() - 1);
                eq = String.valueOf(eq) + "==1.0,";
            }
            F = F.substring(0, F.length() - 1);
            if (this.epmc.intermediateFormula.size() > 0) {
                x = false;
                int j = 0;
                while (j < ePMC.nonExitVar.size()) {
                    undefinedVar = String.valueOf(undefinedVar) + "\n" + ePMC.nonExitVar.get(j);
                    ++j;
                }
                this.proxy.eval(String.valueOf(varDefinition) + undefinedVar + F + "];");
                int ii = 0;
                while (ii < this.epmc.intermediateFormula.size()) {
                    element = this.epmc.intermediateFormula.get(ii).replaceAll("\\s", "");
                    element_val = this.epmc.intermediateFormula.get(ii).replaceAll("\\s", "");
                    element = element.substring(0, element.indexOf("="));
                    element_val = element_val.substring(element_val.indexOf("=") + 1);
                    additional_constraints = " ";
                    if (ae.toString().contains(element) || ePMC.epmcFragmentEquations.contains(element)) {
                        var2 = String.valueOf(var2) + "\n" + element + " = sdpvar(1,1)";
                        this.proxy.eval("\n" + element + " = sdpvar(1,1) \n");
                        requirement = "\nRmin = " + element_val + "\n" + "Rmax = " + "-(Rmin)";
                        this.proxy.eval(String.valueOf(requirement) + settingCommand + rmin);
                        Object[] returnArgumentsMin = this.proxy.returningEval("double(Rmin)", 1);
                        Object minArgument = returnArgumentsMin[0];
                        double min = ((double[])minArgument)[0];
                        this.proxy.eval(rmax);
                        Object[] returnArgumentsMax = this.proxy.returningEval("double(Rmax)", 1);
                        Object maxArgument = returnArgumentsMax[0];
                        double max = ((double[])maxArgument)[0] * -1.0;
                        if (max == -0.0) {
                            max = 0.0;
                        }
                        if (min > max) {
                            min = max = min;
                        }
                        rhs = String.valueOf(Double.toString(min)) + "<=";
                        lhs = "<=" + Double.toString(max);
                        if (max == min) {
                            rhs = "";
                            lhs = "==" + Double.toString(max);
                        }
                        additional_constraints = String.valueOf(additional_constraints) + "\n," + rhs + element + lhs;
                        F1 = "\nF = F + [ " + rhs + element + lhs + " ]";
                        F2 = String.valueOf(F2) + rhs + element + lhs + ",\n";
                        this.proxy.eval(F1);
                    }
                    ++ii;
                }
            }
            requirement = "\nRmin = " + ae.getPolynomial() + "\n" + "Rmax = " + "-(Rmin)";
            if (x) {
                eq = eq.substring(0, eq.length() - 1);
                this.proxy.eval(String.valueOf(varDefinition) + undefinedVar + F + "," + eq + "];" + requirement + settingCommand + rmin);
            } else {
                F2 = F2.substring(0, F2.length() - 2);
                requirement = "\nRmin = " + ae.getPolynomial() + "\n" + "Rmax = " + "-(Rmin)";
                this.proxy.eval(String.valueOf(var2) + F2 + "];" + requirement + settingCommand + rmin);
            }
            Object[] returnArgumentsMin = this.proxy.returningEval("double(Rmin)", 1);
            Object minArgument = returnArgumentsMin[0];
            double min = ((double[])minArgument)[0];
            this.proxy.eval(rmax);
            Object[] returnArgumentsMax = this.proxy.returningEval("double(Rmax)", 1);
            Object maxArgument = returnArgumentsMax[0];
            double max = ((double[])maxArgument)[0];
            return new MinMaxResult(min, max);
        }
        catch (MatlabInvocationException error) {
            error.printStackTrace();
            return new MinMaxResult();
        }
    }

    @Override
    public void stop() {
        this.proxy.disconnect();
    }
}

