/*
 * Decompiled with CFR 0.152.
 */
package application.model;

import application.model.ExperimentData;
import application.model.Settings;
import eFACT.ePMC;
import framework.FactFramework;
import inputOutput.Time;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Label;
import mathEngine.MatLabEngine;
import parametricModelChecking.OperatingSystem;
import parametricModelChecking.PrismParametricModelChecker;

public class FactExecution {
    public ExperimentData data = null;
    private Service<Void> backgroundThread;
    private Service<Void> builderThread;
    public Label lbStatus;
    ePMC epmc = null;
    static float minCI = Float.MAX_VALUE;
    static float maxCI = -1.4E-45f;

    public FactExecution(ExperimentData _data) {
        this.data = _data;
    }

    public double roundToSignificantFigures(double num, int n, boolean rdown) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = rdown ? Math.round(num * magnitude - 0.5) : Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public void run() {
        this.data.flog.newLog();
        this.data.flog.add("Run called");
        this.data.running = true;
        minCI = Float.MAX_VALUE;
        maxCI = Float.MIN_VALUE;
        this.data.timer = new Time();
        final FactFramework fact = this.data.fact;
        Settings settings = new Settings();
        settings.read();
        if (settings.get("PRISMLocation") != null) {
            ExperimentData.PRISMLOCATION = settings.get("PRISMLocation");
        }
        fact.setPpmc(new PrismParametricModelChecker(ExperimentData.PRISMLOCATION, OperatingSystem.MAC));
        this.data.populateFACT();
        this.builderThread = new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        (this).FactExecution.this.data.fInput.ciResults.clear();
                        fact.resetSimultaneousConfidenceIntervalCalculator((this).FactExecution.this.data.fInput);
                        (this).FactExecution.this.data.flog.add("Prism is attempting parametric model checking");
                        (this).FactExecution.this.data.fInput.algebraicExpression = fact.getPpmc().modelCheck((this).FactExecution.this.data.fInput.model, (this).FactExecution.this.data.fInput.property, (this).FactExecution.this.data.flog);
                        return null;
                    }
                };
            }
        };
        this.backgroundThread = new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        fact.nextStepCalculateConfidenceInterval((this).FactExecution.this.data.fInput);
                        return null;
                    }
                };
            }
        };
        this.backgroundThread.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent workerStateEvent) {
                throw new Error("Unresolved compilation problems: \n\tThe method addChartData(double, double, int) is undefined for the type ExperimentData\n\tThe method addChartData(double, double, int) is undefined for the type ExperimentData\n");
            }
        });
        this.builderThread.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                FactExecution.this.data.timer.stop();
                String sPoly = FactExecution.this.data.fInput.algebraicExpression.poly;
                if (sPoly.length() == 0) {
                    FactExecution.this.data.flog.add("Prism failed to return a polynomial");
                    FactExecution.this.lbStatus.setText("Error: Model checking failed to return a polynomial");
                    FactExecution.this.data.running = false;
                    return;
                }
                FactExecution.this.lbStatus.setText("Model checking complete");
                FactExecution.this.data.flog.add("-----------------------------------------------------");
                FactExecution.this.data.flog.add("Polynomial sent to Matlab:");
                FactExecution.this.data.flog.add(sPoly);
                FactExecution.this.data.flog.add("Calculated in " + FactExecution.this.data.timer + " seconds");
                FactExecution.this.data.flog.add("-----------------------------------------------------");
                FactExecution.this.data.flog.add("Hill Climbing Max Iterations: " + FactExecution.this.data.fInput.config.MAX_ITERATIONS);
                fact.setMathsEngine(new MatLabEngine(FactExecution.this.epmc));
                if (FactExecution.this.data.fInput.hasNextAlpha()) {
                    FactExecution.this.backgroundThread.restart();
                }
            }
        });
        this.builderThread.restart();
    }
}

