/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.view.AboutController;
import application.view.MainViewController;
import application.view.RootController;
import java.io.IOException;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class Main
extends Application {
    private Stage primaryStage;
    private BorderPane rootLayout;
    private MainViewController controller;

    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.primaryStage.setTitle("FACT");
        System.setProperty("logFilename", "logs/l4j.txt");
        try {
            FXMLLoader loader = new FXMLLoader(Main.class.getResource("view/RootLayout.fxml"));
            this.rootLayout = (BorderPane)loader.load();
            Scene scene = new Scene((Parent)this.rootLayout);
            primaryStage.setScene(scene);
            primaryStage.show();
            primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    Main.this.closeDown();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showMainView();
    }

    public void closeDown() {
        this.controller.data.fact.terminate();
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public void showMainView() {
        try {
            FXMLLoader loader = new FXMLLoader(Main.class.getResource("view/MainView.fxml"));
            AnchorPane overviewPage = (AnchorPane)loader.load();
            this.initRootLayout();
            this.rootLayout.setCenter((Node)overviewPage);
            this.controller = (MainViewController)loader.getController();
            this.controller.setMainApp(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initRootLayout() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("view/RootLayout.fxml"));
            this.rootLayout = (BorderPane)loader.load();
            Scene scene = new Scene((Parent)this.rootLayout);
            this.primaryStage.setScene(scene);
            RootController controller = (RootController)loader.getController();
            controller.setMainApp(this);
            this.primaryStage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showAboutDialog() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("view/About.fxml"));
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle("About FACT");
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.primaryStage);
            dialogStage.setResizable(false);
            Scene scene = new Scene((Parent)page);
            dialogStage.setScene(scene);
            AboutController controller = (AboutController)loader.getController();
            controller.setDialogStage(dialogStage);
            dialogStage.showAndWait();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    public void preferences() {
        this.controller.showPreferencesDialog();
    }

    public void saveResults() {
        this.controller.saveResults();
    }
}

