/*
 * Decompiled with CFR 0.152.
 */
package veracity;

import application.model.ExperimentData;
import application.model.Settings;
import eFACT.ePMC;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Scanner;
import logging.FACTLogger;
import mathEngine.MatLabEngine;
import testingHeuristic.Parameter;
import testingHeuristic.Requirement;
import testingHeuristic.Requirements;
import testingHeuristic.TestHeuristic;
import veracity.Execute;
import veracity.setUpExperiment;

public class mainVERACITY {
    private static FACTLogger flog = new FACTLogger();
    private static int roundBudget = 5000;
    private static int budget = 50000;
    private static String observationScript = null;
    private static boolean useUniform = false;
    private static boolean skipSatisfiedReqs = true;
    static ePMC epmc = new ePMC();
    static TestHeuristic heuristic = new TestHeuristic();
    public static List<String> constVal = new ArrayList<String>();
    private static Scanner sc = new Scanner(System.in);

    public static void main(String[] args) throws Exception {
        String skipSatisfiedReqsString;
        String budgetString;
        flog.newLog();
        if (args.length < 3) {
            System.err.println("Incorrect syntax - expected 3 parameters: VERACITYT \"modelfile.pm\" \"requirementFile.pctl\" confidenceLevel\n");
            System.exit(1);
        }
        String[] arg = new String[]{"Model Path: ", "PCTL Path: ", "Confidence Level: "};
        int argCounter = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(String.valueOf(arg[argCounter]) + s);
            ++argCounter;
            ++n2;
        }
        ExperimentData data = new ExperimentData(flog);
        File fModel = new File(args[0]);
        data.loadModel(fModel);
        setUpExperiment setup = new setUpExperiment(data.getModelCode());
        int type = 0;
        epmc.deletFile("testModel.pm");
        epmc.deletFile("testProp.pctl");
        if (mainVERACITY.modelType(args[0]) == 1) {
            type = 1;
            String originalModel = mainVERACITY.getOriginalModel(args[0]);
            epmc.saveFile("testModel.pm", originalModel);
        }
        Settings settings = new Settings();
        settings.read();
        String roundBudgetString = settings.get("testingRoundBudget");
        if (roundBudgetString != null) {
            roundBudget = Integer.parseInt(roundBudgetString);
        }
        if ((budgetString = settings.get("testingBudget")) != null) {
            budget = Integer.parseInt(budgetString);
        }
        observationScript = settings.get("NewObservationScriptLocation");
        String useUniformString = settings.get("useUniform");
        if (useUniformString != null) {
            useUniform = useUniformString.equals("true");
        }
        if ((skipSatisfiedReqsString = settings.get("skipSatisfiedReqs")) != null) {
            skipSatisfiedReqs = skipSatisfiedReqsString.equals("true");
        }
        System.out.println("\n**** Using " + (useUniform ? "uniform" : "targeted") + " additional testing, " + (skipSatisfiedReqs ? "skippinq" : "analysing") + " properties for satisfied requirements");
        double[] cost = new double[setup.getParam().size()];
        int i = 0;
        while (i < setup.getParam().size()) {
            cost[i] = setup.getParam().get(i).getCost();
            ++i;
        }
        Hashtable<String, Parameter> parameters = new Hashtable<String, Parameter>();
        int i2 = 0;
        while (i2 < setup.getParam().size()) {
            int a = 0;
            while (a < setup.getParam().get(i2).getObservations().size()) {
                double division = (double)setup.getParam().get(i2).getObservations().get(a).intValue() / (double)setup.getParam().get(i2).getTotalObservations();
                parameters.put(setup.getParam().get(i2).getNames().get(a), new Parameter(division, setup.getParam().get(i2).getComponentID() - 1));
                ++a;
            }
            ++i2;
        }
        Requirements reqs = new Requirements(args[1]);
        float confidence = Float.valueOf(args[2].trim()).floatValue();
        data.setconfidenceValue(Float.valueOf(confidence), Float.valueOf(confidence), Float.valueOf(1.0f));
        MatLabEngine engine = new MatLabEngine(epmc);
        boolean firstRound = true;
        int roundCounter = 1;
        while (true) {
            System.out.println("\n**** Round " + roundCounter + " ****");
            System.out.println("** Parameters for the round:");
            for (String key : parameters.keySet()) {
                System.out.println("  -- " + key + " with estimate value " + ((Parameter)parameters.get((Object)key)).value + " from component " + (parameters.get((Object)key).componentID + 1));
            }
            System.out.println("** Computing confidence intervals:");
            for (Requirement req : reqs.getRequirements()) {
                if (mainVERACITY.modelType(args[0]) == 1) {
                    epmc.deletFile("testProp.pctl");
                    epmc.epmcArrayClear();
                    epmc.saveFile("testProp.pctl", req.propertyPCTL);
                }
                if (!skipSatisfiedReqs || !req.satisfied) {
                    data.setEvalProp(req.propertyPCTL);
                    Execute fe = new Execute(data, flog, epmc, type);
                    String result = fe.run(engine);
                    String interval = result.substring(result.indexOf(91) + 1);
                    String lowerBound = interval.substring(0, interval.indexOf(44));
                    String upperBound = interval.substring(result.indexOf(44), interval.indexOf(93));
                    req.lowerBound = Double.parseDouble(lowerBound);
                    req.upperBound = Double.parseDouble(upperBound);
                    req.property = data.fInput.algebraicExpression.toString();
                    if (mainVERACITY.modelType(args[0]) == 1) {
                        req.property = mainVERACITY.epmc.fullMainFormula;
                        req.property = mainVERACITY.findReplace(req.property, constVal);
                    }
                    System.out.println("  -- Property: " + req.property);
                    System.out.println("     Result: " + result);
                    continue;
                }
                System.out.println("  -- Unchanged property: " + req.property);
                System.out.println("     Latest result: [" + req.lowerBound + "," + req.upperBound + "]");
            }
            int[] nAdditionalObservations = heuristic.computeObservations(reqs.getTheRequirements(), cost, parameters, roundBudget, firstRound, useUniform);
            firstRound = false;
            if (nAdditionalObservations == null) {
                System.out.println("Completed session with budget " + (roundCounter - 1) * roundBudget);
                break;
            }
            if (budget <= roundCounter * roundBudget) {
                System.out.println("Could not complete session before exhausting budget " + budget);
                break;
            }
            System.out.println("** Additional observations are required");
            int i3 = 0;
            while (i3 < nAdditionalObservations.length) {
                System.out.println("  -- Additional observations required for component " + (i3 + 1) + ": " + nAdditionalObservations[i3]);
                ++i3;
            }
            mainVERACITY.updateModel(data, nAdditionalObservations, parameters);
            ++roundCounter;
        }
        data.fact.terminate();
        engine.stop();
        sc.close();
        System.out.println("\nRun is completed!");
        System.exit(1);
    }

    private static void updateModel(ExperimentData data, int[] nAdditionalObservations, Hashtable<String, Parameter> parameters) throws Exception {
        String[] lines = data.getModelCode().split("\\r?\\n");
        String updatedModel = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith("param")) {
                int i;
                line = line.replaceAll(";", " ;");
                String[] atoms = line.trim().split("\\s+");
                int componentIdx = 0;
                while (!atoms[componentIdx].equals("component")) {
                    ++componentIdx;
                }
                int componentID = Integer.parseInt(atoms[componentIdx + 2]) - 1;
                int observationsIdx = 0;
                while (!atoms[observationsIdx].equals("observations")) {
                    ++observationsIdx;
                }
                int nObservations = componentIdx - observationsIdx - 3;
                int[] newObservations = new int[nObservations];
                if (nAdditionalObservations[componentID] > 0) {
                    if (observationScript == null) {
                        System.out.print(">> Provide " + nAdditionalObservations[componentID] + " additional observations for " + atoms[1] + " (" + nObservations + " transitions) : ");
                        i = 0;
                        while (i < nObservations) {
                            newObservations[i] = sc.nextInt();
                            ++i;
                        }
                    } else {
                        mainVERACITY.runObservationGenerator(newObservations, Integer.toString(nAdditionalObservations[componentID]), atoms[1]);
                        System.out.print(">> Obtained " + nAdditionalObservations[componentID] + " additional observations for " + atoms[1] + ": ");
                        i = 0;
                        while (i < nObservations) {
                            System.out.print(String.valueOf(newObservations[i]) + " ");
                            ++i;
                        }
                        System.out.println();
                    }
                } else {
                    System.out.println(">> No additional observations required for " + atoms[1]);
                    i = 0;
                    while (i < nObservations) {
                        newObservations[i] = 0;
                        ++i;
                    }
                }
                String newLine = "";
                int i2 = 0;
                while (i2 < observationsIdx + 2) {
                    newLine = String.valueOf(newLine) + atoms[i2] + " ";
                    ++i2;
                }
                int[] totalObs = new int[nObservations];
                int i3 = 0;
                while (i3 < nObservations) {
                    totalObs[i3] = Integer.parseInt(atoms[observationsIdx + 2 + i3]) + newObservations[i3];
                    newLine = String.valueOf(newLine) + totalObs[i3] + " ";
                    ++i3;
                }
                mainVERACITY.updateParameterEstimate(parameters, atoms[1], totalObs);
                newLine = String.valueOf(newLine) + "; ";
                i3 = componentIdx;
                while (i3 < atoms.length) {
                    newLine = String.valueOf(newLine) + atoms[i3] + " ";
                    ++i3;
                }
                updatedModel = String.valueOf(updatedModel) + newLine + "\n";
                System.out.println("  -- " + newLine);
            } else {
                updatedModel = String.valueOf(updatedModel) + line + "\n";
            }
            ++n2;
        }
        data.setModel(updatedModel);
    }

    private static void runObservationGenerator(int[] obs, String nObs, String param) throws Exception {
        String[] commandAndArguments = new String[]{observationScript, nObs, param};
        System.out.println("** Running '" + observationScript + " " + nObs + " " + param + "'");
        ProcessBuilder pb = new ProcessBuilder(commandAndArguments);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String response = reader.readLine();
        reader.close();
        String[] atoms = response.trim().split("\\s+");
        int i = 0;
        while (i < obs.length) {
            obs[i] = Integer.parseInt(atoms[i]);
            ++i;
        }
    }

    private static void updateParameterEstimate(Hashtable<String, Parameter> parameters, String paramPrefix, int[] obs) {
        double totalObs = 0.0;
        int i = 0;
        while (i < obs.length) {
            totalObs += (double)obs[i];
            ++i;
        }
        i = 0;
        while (i < obs.length) {
            double estimate;
            String paramName = String.valueOf(paramPrefix) + Integer.toString(i + 1);
            parameters.get((Object)paramName).value = estimate = (double)obs[i] / totalObs;
            ++i;
        }
    }

    public static int modelType(String model) {
        int x = 0;
        File file = new File(model);
        String s = "\\s*+//efact";
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().toLowerCase();
                if (line.matches("(?!//efact)([a-z0-9]|/{2})$")) break;
                if (!line.matches(s)) continue;
                x = 1;
                break;
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("An error has occured in class: " + e.getClass());
        }
        return x;
    }

    public static String getOriginalModel(String input) throws Exception {
        String line;
        String model = "";
        BufferedReader l = new BufferedReader(new FileReader(input));
        while ((line = l.readLine()) != null) {
            if (line.startsWith("param")) {
                String param = line.substring(line.indexOf("param") + 5, line.indexOf(":")).replaceAll("\\s+", "");
                String n = line.substring(line.indexOf("=") + 1, line.indexOf(";")).replaceAll("\\s+", " ").trim();
                String[] temp = n.split("\\D");
                int i = 1;
                while (i <= temp.length) {
                    model = String.valueOf(model) + "\nconst double " + param + i + ";";
                    ++i;
                }
            } else {
                model = String.valueOf(model) + "\n" + line;
            }
            if (!line.startsWith("const double") || !line.contains("=")) continue;
            line = line.substring(line.indexOf("double") + 6, line.indexOf(";")).trim();
            constVal.add(line);
        }
        return model;
    }

    public static String findReplace(String exp, List<String> val) {
        String result = "";
        String param = "";
        String value = "";
        int i = 0;
        while (i < val.size()) {
            param = val.get(i).substring(0, val.get(i).indexOf("=")).trim();
            value = val.get(i).substring(val.get(i).indexOf("=") + 1).trim();
            exp = exp.replaceAll(param, value);
            ++i;
        }
        result = exp;
        return result;
    }
}

