/*
 * Decompiled with CFR 0.152.
 */
package parametricModelChecking;

import confidenceIntervalCalculation.Interval;
import java.util.ArrayList;
import java.util.HashMap;
import observations.StateParameterObservation;
import observations.TransitionParameter;

public abstract class ParametricProbabilisticModel {
    private HashMap<String, Interval> params;
    private String model;

    public ParametricProbabilisticModel(String model) {
        this.model = model;
        this.params = new HashMap();
    }

    public HashMap<String, Interval> getParams() {
        return this.params;
    }

    public void addParameter(String name, Interval interval) {
        this.params.put(name, interval);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setParameters(ArrayList<StateParameterObservation> observations) {
        this.params = new HashMap();
        for (StateParameterObservation sp : observations) {
            TransitionParameter[] transitionParameterArray = sp.getTransitionParameters();
            int n = transitionParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransitionParameter tp = transitionParameterArray[n2];
                this.addParameter(tp.getLabel(), new Interval(0.0, 0.999));
                ++n2;
            }
        }
    }
}

