/*
 * Decompiled with CFR 0.152.
 */
package mathEngine;

import confidenceIntervalCalculation.ConfidenceInterval;
import confidenceIntervalCalculation.SimultaneousConfidenceIntervalCalculator;
import java.util.ArrayList;
import logging.FACTLogger;
import mathEngine.MathsEngine;
import mathEngine.MathsResult;
import mathEngine.MinMaxResult;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;
import matlabcontrol.MatlabProxyFactoryOptions;
import observations.StateParameterObservation;
import observations.TransitionParameter;
import parametricModelChecking.AlgebraicExpression;

public class MatLabEngine
implements MathsEngine {
    public FACTLogger flog = new FACTLogger();
    private static MatlabProxyFactory matLabFactory;
    private static MatlabProxy proxy;

    public MatLabEngine(FACTLogger flog) {
        if (matLabFactory == null) {
            this.flog = flog;
            MatlabProxyFactoryOptions options = new MatlabProxyFactoryOptions.Builder().setHidden(true).setProxyTimeout(30000L).setUsePreviouslyControlledSession(true).build();
            matLabFactory = new MatlabProxyFactory(options);
            try {
                proxy = matLabFactory.getProxy();
            }
            catch (MatlabConnectionException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public MathsResult computeResult(AlgebraicExpression ae, SimultaneousConfidenceIntervalCalculator scic) {
        try {
            ArrayList<TransitionParameter> parameters = new ArrayList<TransitionParameter>();
            for (TransitionParameter tp : scic.getTransitionParameters()) {
                parameters.add(tp);
            }
            String varDefinition = "clear all";
            String F = "\nF = [";
            String rmin = "\noptimize(F,Rmin,options)";
            String rmax = "\noptimize(F,Rmax,options)";
            for (TransitionParameter tp : parameters) {
                varDefinition = String.valueOf(varDefinition) + "\n" + tp.getLabel() + " = sdpvar(1,1)";
                ConfidenceInterval ci = scic.getConfidenceInterval(tp);
                F = String.valueOf(F) + "\n" + ci.getLowerBound() + "<=" + tp.getLabel() + "<=" + ci.getUpperBound() + ",";
            }
            for (StateParameterObservation sp : scic.stateParameterObservations()) {
                int nParameters = sp.getTransitionParameters().length;
                if (nParameters <= 1) continue;
                String eq = "\n";
                TransitionParameter[] transitionParameterArray = sp.getTransitionParameters();
                int n = transitionParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TransitionParameter tp = transitionParameterArray[n2];
                    eq = String.valueOf(eq) + tp.getLabel() + "+";
                    ++n2;
                }
                eq = eq.substring(0, eq.length() - 1);
                eq = String.valueOf(eq) + "==1.0,";
                F = String.valueOf(F) + eq;
            }
            F = String.valueOf(F.substring(0, F.length() - 1)) + "];";
            String requirement = "\nRmin = " + ae.getPolynomial() + "\n" + "Rmax = " + "-(" + ae.getPolynomial() + ")";
            String command = "\noptions = sdpsettings('solver','BMIBNB')";
            this.flog.add("\n&&&&&&&&&&& MATLAB CODE &&&&&&&&&&&\n");
            this.flog.add(String.valueOf(varDefinition) + F + requirement + command + rmin);
            proxy.eval(String.valueOf(varDefinition) + F + requirement + command + rmin);
            Object[] returnArgumentsMin = proxy.returningEval("double(Rmin)", 1);
            Object minArgument = returnArgumentsMin[0];
            double min = ((double[])minArgument)[0];
            proxy.eval(rmax);
            this.flog.add("double(Rmin)\n" + rmax + "\ndouble(Rmax)");
            Object[] returnArgumentsMax = proxy.returningEval("double(Rmax)", 1);
            Object maxArgument = returnArgumentsMax[0];
            double max = ((double[])maxArgument)[0];
            this.flog.add("\n&&&&&&&&&&& &&&&&&&&&&& &&&&&&&&&&&\n");
            return new MinMaxResult(min, max);
        }
        catch (MatlabInvocationException error) {
            error.printStackTrace();
            return new MinMaxResult();
        }
    }

    @Override
    public void stop() {
    }
}

