/*
 * Decompiled with CFR 0.152.
 */
package inputOutput;

import confidenceIntervalCalculation.AlphaStartEndStep;
import confidenceIntervalCalculation.ConfidenceInterval;
import inputOutput.Config;
import inputOutput.Time;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import observations.ObservationCount;
import observations.StateParameterObservation;
import observations.TransitionParameter;
import parametricModelChecking.AlgebraicExpression;
import parametricModelChecking.ParametricProbabilisticModel;
import parametricModelChecking.Property;

public class FactInput {
    public String description;
    public AlgebraicExpression algebraicExpression = null;
    public ParametricProbabilisticModel model = null;
    public AlphaStartEndStep alphaStartEndStep;
    public Config config;
    public ArrayList<StateParameterObservation> observations = new ArrayList();
    public Property property = null;
    public Time timing;
    public ArrayList<ConfidenceInterval> ciResults;

    public boolean hasNextAlpha() {
        return this.alphaStartEndStep.hasNext();
    }

    public FactInput() {
        this.config = new Config();
        this.ciResults = new ArrayList();
    }

    public String toString() {
        return "FactInput: " + this.description;
    }

    public static Queue<FactInput> readFactInputFromOriginalFile(String inputFileLocationAndName) {
        LinkedList<FactInput> factinputs = new LinkedList<FactInput>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(inputFileLocationAndName));
            String line = null;
            while ((line = reader.readLine()) != null) {
                AlphaStartEndStep alphas;
                FactInput factInput = new FactInput();
                String description = "";
                while (line.contains(";")) {
                    description = String.valueOf(description) + line;
                    line = reader.readLine();
                }
                factInput.description = description;
                factInput.algebraicExpression = new AlgebraicExpression(line);
                String[] tokens = reader.readLine().split(" ");
                factInput.alphaStartEndStep = alphas = new AlphaStartEndStep(Double.parseDouble(tokens[0]), Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2]));
                while ((line = reader.readLine()) != null && !line.contains("END")) {
                    tokens = line.split(" ");
                    String parameterName = tokens[0];
                    int numberOfParameters = Integer.parseInt(tokens[1]);
                    int totalNumberOfObservations = Integer.parseInt(tokens[2]);
                    StateParameterObservation stateParameterObservation = new StateParameterObservation();
                    int i = 1;
                    while (i <= numberOfParameters) {
                        ObservationCount oc = new ObservationCount();
                        oc.totalObservationCountForStateParameter = totalNumberOfObservations;
                        oc.transitionObservationCount = Integer.parseInt(reader.readLine());
                        stateParameterObservation.addObservation(new TransitionParameter(String.valueOf(parameterName) + i), oc);
                        ++i;
                    }
                    factInput.observations.add(stateParameterObservation);
                }
                factinputs.add(factInput);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return factinputs;
    }

    public void resetObservations() {
        this.observations = new ArrayList();
    }

    public void modelReset() {
        this.model = null;
    }
}

