/*
 * Decompiled with CFR 0.152.
 */
package framework;

import confidenceIntervalCalculation.Interval;
import framework.FactFramework;
import inputOutput.FactInput;
import inputOutput.FileUtils;
import java.io.IOException;
import java.util.Queue;
import logging.FACTLogger;
import mathEngine.MatLabEngine;
import parametricModelChecking.OperatingSystem;
import parametricModelChecking.PrismDTMCModel;
import parametricModelChecking.PrismPCTLProperty;
import parametricModelChecking.PrismParametricModelChecker;

public class FactTestProgram {
    public static String webInputFileLocation = "/Users/kjohnson/Desktop/fact/test/original/input/originalInput.txt";
    public static String prismExecutable = "/Applications/prism4.4/bin/prism";
    public static FACTLogger flog = new FACTLogger();

    public static void testModelChecker() {
        PrismParametricModelChecker prism = new PrismParametricModelChecker(prismExecutable, OperatingSystem.MAC);
        PrismDTMCModel model = null;
        try {
            model = new PrismDTMCModel("/Users/kjohnson/prism-4.3/bin/brp-param.pm");
            model.addParameter("kFail", new Interval(0.01, 0.02));
            model.addParameter("lFail", new Interval(0.01, 0.02));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrismPCTLProperty property = new PrismPCTLProperty();
        try {
            property.setProperty(FileUtils.readTextFileContents("/Users/kjohnson/prism-4.3/bin/p1.pctl"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FACTLogger flog = null;
        prism.modelCheck(model, property, flog);
    }

    public static void main(String[] args) {
        FactFramework fact = new FactFramework();
        Queue<FactInput> q = FactInput.readFactInputFromOriginalFile(webInputFileLocation);
        FactInput fi = q.poll();
        System.out.println("Analysing: " + fi.algebraicExpression);
        fact.setMathsEngine(new MatLabEngine(flog));
        fact.calculateConfidenceInterval(fi);
        System.out.println("Done.");
    }
}

