/*
 * Decompiled with CFR 0.152.
 */
package framework;

import confidenceIntervalCalculation.Alpha;
import confidenceIntervalCalculation.AlphaStartEndStep;
import confidenceIntervalCalculation.ConfidenceInterval;
import confidenceIntervalCalculation.ConfidenceIntervalCalculationEngine;
import confidenceIntervalCalculation.ConfidenceIntervalCalculationEngineImplementation;
import confidenceIntervalCalculation.Proposition2;
import confidenceIntervalCalculation.SimultaneousConfidenceIntervalCalculator;
import inputOutput.FactInput;
import inputOutput.Time;
import logging.FACTLogger;
import mathEngine.MatLabEngine;
import mathEngine.MathsEngine;
import parametricModelChecking.ParametricProbabilisticModelChecker;

public class FactFramework {
    public static FACTLogger flog = new FACTLogger();
    private ParametricProbabilisticModelChecker ppmc;
    private SimultaneousConfidenceIntervalCalculator scic;
    private MathsEngine mathsEngine;
    private ConfidenceIntervalCalculationEngine cice;
    private ConfidenceInterval _lastComputedCI;

    public void terminate() {
        if (this.mathsEngine != null) {
            this.mathsEngine.stop();
        }
    }

    public void nextStepCalculateConfidenceInterval(FactInput input) {
        AlphaStartEndStep alphas = input.alphaStartEndStep;
        if (alphas.hasNext()) {
            Alpha anAlpha = alphas.next();
            input.timing = new Time();
            ConfidenceInterval ci = this.cice.confidenceIntervalSynthesiser(input.config, this.scic, this.mathsEngine, input.algebraicExpression, anAlpha);
            input.timing.stop();
            input.ciResults.add(ci);
            this._lastComputedCI = ci;
        } else {
            this._lastComputedCI = null;
        }
    }

    public void resetSimultaneousConfidenceIntervalCalculator(FactInput input) {
        this.scic = new Proposition2(input.observations);
    }

    public void calculateConfidenceInterval(FactInput input) {
        if (input.observations.size() <= 1) {
            throw new IllegalArgumentException("Not observations have been input.");
        }
        this.scic = new Proposition2(input.observations);
        this.mathsEngine = new MatLabEngine(flog);
        AlphaStartEndStep alphas = input.alphaStartEndStep;
        while (alphas.hasNext()) {
            Alpha anAlpha = alphas.next();
            Time timing = new Time();
            ConfidenceInterval ci = this.cice.confidenceIntervalSynthesiser(input.config, this.scic, this.mathsEngine, input.algebraicExpression, anAlpha);
            timing.stop();
            input.ciResults.add(ci);
            this._lastComputedCI = ci;
        }
        this.mathsEngine.stop();
    }

    public FactFramework(ParametricProbabilisticModelChecker ppmc, SimultaneousConfidenceIntervalCalculator scic, MathsEngine mathsEngine, ConfidenceIntervalCalculationEngine cice) {
        this.setPpmc(ppmc);
        this.setScic(scic);
        this.setMathsEngine(mathsEngine);
        this.setCice(cice);
    }

    public FactFramework() {
        this.cice = new ConfidenceIntervalCalculationEngineImplementation();
        this._lastComputedCI = null;
    }

    public ParametricProbabilisticModelChecker getPpmc() {
        return this.ppmc;
    }

    public void setPpmc(ParametricProbabilisticModelChecker ppmc) {
        this.ppmc = ppmc;
    }

    public SimultaneousConfidenceIntervalCalculator getScic() {
        return this.scic;
    }

    public void setScic(SimultaneousConfidenceIntervalCalculator scic) {
        this.scic = scic;
    }

    public MathsEngine getMathsEngine() {
        return this.mathsEngine;
    }

    public void setMathsEngine(MathsEngine mathsEngine) {
        this.mathsEngine = mathsEngine;
    }

    public ConfidenceIntervalCalculationEngine getCice() {
        return this.cice;
    }

    public void setCice(ConfidenceIntervalCalculationEngine cice) {
        this.cice = cice;
    }

    public ConfidenceInterval getLastComputedCI() {
        return this._lastComputedCI;
    }
}

