/*
 * Decompiled with CFR 0.152.
 */
package epmc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import parametricModelChecking.AlgebraicExpression;

public class ePMC {
    List<Integer> linesNumber = new ArrayList<Integer>();
    List<Integer> linesNumber1 = new ArrayList<Integer>();
    public List<String> intermediateFormula = new ArrayList<String>();
    List<String> mainFormula = new ArrayList<String>();
    List<String> paramVals = new ArrayList<String>();

    public static void executeEPMC() throws Exception {
        System.out.println("** Runn");
        String command = "./ePMC-Prism.sh testModel.pm testProp.pctl ePMCoutput.m";
        System.out.println("Command is " + command);
        Process proc = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String line = "";
        while ((line = reader.readLine()) != null) {
            System.out.print(String.valueOf(line) + "\n");
        }
        proc.waitFor();
        System.out.println("** Stop ");
    }

    public void saveFile(String name, String data) {
        try {
            File file = new File(name);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(data);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void intermediateFormulaLines(String outputFile) {
        File file = new File(outputFile);
        String word1 = "%---- Component Formula ----";
        String word2 = "%------------------------------------------------";
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        int i = 0;
        int j = 0;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.contains(word1)) {
                this.linesNumber.add(i + 1);
            } else if (line.contains(word2)) {
                this.linesNumber.add(j - 1);
            }
            if (line.contains("%PrismPMC2Matlab v 1.0")) break;
            ++i;
            ++j;
        }
        scanner.close();
    }

    public void intermediateFormula(String outputFile) throws IOException {
        this.intermediateFormulaLines(outputFile);
        File file = new File(outputFile);
        Scanner scanner = null;
        String s = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        int i = 0;
        int j = 0;
        int a = 0;
        while (scanner.hasNextLine()) {
            if (i == this.linesNumber.get(a)) {
                j = this.linesNumber.get(a);
                while (j <= this.linesNumber.get(a + 1)) {
                    s = Files.readAllLines(Paths.get(outputFile, new String[0])).get(j).replace(";", "");
                    this.intermediateFormula.add(s);
                    ++j;
                }
                if (a + 2 < this.linesNumber.size()) {
                    a += 2;
                }
            }
            scanner.nextLine();
            ++i;
        }
        scanner.close();
    }

    public void mainFormulas(String outputFile) {
        File file = new File(outputFile);
        String word1 = "%PrismPMC2Matlab v 1.0";
        String word2 = "%Complete";
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        block2: while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.contains(word1)) continue;
            while (!line.contains(word2)) {
                line = scanner.nextLine();
                if (line.contains(word2)) continue block2;
                line = line.substring(line.indexOf("=") + 1);
                this.mainFormula.add(line);
            }
        }
        scanner.close();
    }

    public void paramLine(String outputFile) {
        File file = new File(outputFile);
        String word1 = "% ---- Prism Model Parameters ----";
        String word2 = "% --------------------------------";
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        int i = 0;
        int j = 0;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.contains(word1)) {
                this.linesNumber1.add(i + 1);
            } else if (line.contains(word2)) {
                this.linesNumber1.add(j - 1);
            }
            if (line.contains("%PrismPMC2Matlab v 1.0")) break;
            ++i;
            ++j;
        }
        scanner.close();
    }

    public void paramVal(String outputFile) throws IOException {
        this.linesNumber1.clear();
        this.paramVals.clear();
        File file = new File(outputFile);
        if (file.exists()) {
            this.paramLine(outputFile);
            Scanner scanner = null;
            String s = null;
            try {
                scanner = new Scanner(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            int i = 0;
            int j = 0;
            int a = 0;
            while (scanner.hasNextLine()) {
                if (++i == this.linesNumber1.get(a)) {
                    j = this.linesNumber1.get(a);
                    while (j <= this.linesNumber1.get(a + 1)) {
                        s = Files.readAllLines(Paths.get(outputFile, new String[0])).get(j).replace(";", "");
                        this.paramVals.add(s);
                        ++j;
                    }
                    if (a + 2 < this.linesNumber1.size()) {
                        a += 2;
                    }
                }
                scanner.nextLine();
            }
            scanner.close();
        }
    }

    public void getEquationsLines() {
        int i = 0;
        while (i < this.linesNumber.size()) {
            System.out.println(this.linesNumber.get(i));
            ++i;
        }
    }

    public void getAllIntermediateFormula() {
        int i = 0;
        while (i < this.intermediateFormula.size()) {
            System.out.println(this.intermediateFormula.get(i));
            ++i;
        }
    }

    public String getIntermediateFormula(int index) {
        return this.intermediateFormula.get(index);
    }

    public void getAllMainFormula() {
        int i = 0;
        while (i < this.mainFormula.size()) {
            System.out.println(this.mainFormula.get(i));
            ++i;
        }
    }

    public String getMainFormula(int index) {
        return this.mainFormula.get(index);
    }

    public AlgebraicExpression getAlgebraicExpression(String ae) {
        AlgebraicExpression a = new AlgebraicExpression(ae);
        return a;
    }

    public String getParaVals() {
        String s = "";
        if (this.paramVals.size() != 0) {
            int i = 0;
            while (i < this.paramVals.size()) {
                s = String.valueOf(s) + this.paramVals.get(i) + " ;\n";
                ++i;
            }
        }
        return s;
    }

    public void epmcFilesDelete() {
        File fmodel = new File("testModel.pm");
        File fprop = new File("testProp.pctl");
        File fePMCoutput = new File("ePMCoutput.m");
        if (fmodel.exists()) {
            fmodel.delete();
        }
        if (fprop.exists()) {
            fprop.delete();
        }
        if (fePMCoutput.exists()) {
            fePMCoutput.delete();
        }
    }

    public void equation_substitution() {
        String element = null;
        String element_val = null;
        String finalequ = null;
        int i = 0;
        while (i < this.intermediateFormula.size()) {
            element = this.intermediateFormula.get(i).replaceAll("\\s", "");
            element_val = this.intermediateFormula.get(i).replaceAll("\\s", "");
            element = element.substring(0, element.indexOf("="));
            element_val = element_val.substring(element_val.indexOf("=") + 1);
            int j = 0;
            while (j < this.mainFormula.size()) {
                finalequ = this.mainFormula.get(j);
                finalequ = finalequ.replace(element, "(" + element_val + ")");
                this.mainFormula.set(j, finalequ);
                ++j;
            }
            ++i;
        }
    }
}

