/*
 * Decompiled with CFR 0.152.
 */
package confidenceIntervalCalculation;

import confidenceIntervalCalculation.Alpha;
import confidenceIntervalCalculation.ConfidenceInterval;
import confidenceIntervalCalculation.SimultaneousConfidenceIntervalCalculator;
import confidenceIntervalCalculation.StatisticsConversion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import observations.StateParameterObservation;
import observations.TransitionParameter;

public class Proposition2
implements SimultaneousConfidenceIntervalCalculator {
    private int nStateParameters;
    private HashMap<TransitionParameter, ConfidenceInterval> parameterCIs = new HashMap();
    private ArrayList<StateParameterObservation> observations;

    public Proposition2(ArrayList<StateParameterObservation> observations) {
        this.observations = observations;
        ArrayList<TransitionParameter> tps = new ArrayList<TransitionParameter>();
        for (StateParameterObservation spo : observations) {
            TransitionParameter[] transitionParameterArray = spo.getTransitionParameters();
            int n = transitionParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransitionParameter tp = transitionParameterArray[n2];
                this.parameterCIs.put(tp, new ConfidenceInterval());
                tps.add(tp);
                ++n2;
            }
        }
        this.nStateParameters = this.observations.size();
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(Alpha confidence, double parameter, double observations) {
        double oneMinusAlpha = 1.0 - confidence.alphaValue;
        double zscore = StatisticsConversion.calculateOneSidedZscore(1.0 - oneMinusAlpha / 2.0);
        double firstpart = parameter + zscore * zscore / (2.0 * observations);
        double secondtpart = zscore * zscore * Math.sqrt((parameter * (1.0 - parameter) + zscore * zscore / (4.0 * observations)) / observations);
        double denom = 1.0 + zscore * zscore / observations;
        double lowerBound = (firstpart - secondtpart) / denom;
        double upperBound = (firstpart + secondtpart) / denom;
        if (lowerBound < 0.0) {
            lowerBound = 0.0;
        }
        if (upperBound > 1.0) {
            upperBound = 1.0;
        }
        return new ConfidenceInterval(lowerBound, upperBound, confidence);
    }

    @Override
    public void initialiseParameterConfidenceIntervals(Alpha alpha) {
        for (TransitionParameter tp : this.parameterCIs.keySet()) {
            ConfidenceInterval ci = new ConfidenceInterval();
            ci.setMinusAlpha(Math.pow(alpha.alphaValue, 1.0 / (double)this.nStateParameters));
            this.parameterCIs.put(tp, ci);
        }
    }

    @Override
    public ArrayList<StateParameterObservation> stateParameterObservations() {
        return this.observations;
    }

    @Override
    public ArrayList<TransitionParameter> getTransitionParameters() {
        ArrayList<TransitionParameter> gtps = new ArrayList<TransitionParameter>();
        for (TransitionParameter tp : this.parameterCIs.keySet()) {
            gtps.add(tp);
        }
        Collections.sort(gtps);
        return gtps;
    }

    @Override
    public ConfidenceInterval getConfidenceInterval(TransitionParameter tp) {
        return this.parameterCIs.get(tp);
    }

    @Override
    public void updateSimultaneousConfidenceIntervals(Alpha alpha) {
        for (StateParameterObservation obs : this.observations) {
            TransitionParameter[] transitionParameterArray = obs.getTransitionParameters();
            int n = transitionParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransitionParameter tp = transitionParameterArray[n2];
                int totalStateParameterObservationCount = obs.observerations.get((Object)tp).totalObservationCountForStateParameter;
                int transitionObservationCount = obs.observerations.get((Object)tp).transitionObservationCount;
                double observationRatio = (double)transitionObservationCount / (double)totalStateParameterObservationCount;
                ConfidenceInterval ci = this.parameterCIs.get(tp);
                ci = this.computeConfidenceInterval(ci.minusAlpha, observationRatio, totalStateParameterObservationCount);
                this.parameterCIs.put(tp, ci);
                ++n2;
            }
        }
    }
}

