/*
 * Decompiled with CFR 0.152.
 */
package confidenceIntervalCalculation;

import confidenceIntervalCalculation.Alpha;
import confidenceIntervalCalculation.ConfidenceInterval;
import confidenceIntervalCalculation.ConfidenceIntervalCalculationEngine;
import confidenceIntervalCalculation.SimultaneousConfidenceIntervalCalculator;
import heuristic.HillClimbingOptimisationMethod;
import inputOutput.Config;
import mathEngine.MathsEngine;
import mathEngine.MinMaxResult;
import parametricModelChecking.AlgebraicExpression;

public class ConfidenceIntervalCalculationEngineImplementation
implements ConfidenceIntervalCalculationEngine {
    @Override
    public ConfidenceInterval confidenceIntervalSynthesiser(Config config, SimultaneousConfidenceIntervalCalculator scic, MathsEngine mathsEngine, AlgebraicExpression e, Alpha alpha) {
        HillClimbingOptimisationMethod hillClimbing = new HillClimbingOptimisationMethod();
        scic.initialiseParameterConfidenceIntervals(alpha);
        MinMaxResult bestResult = new MinMaxResult();
        int iterationsWithoutImprovement = 0;
        boolean nIterations = false;
        int hillClimbingCount = 0;
        do {
            if (hillClimbingCount < config.MAX_ITERATIONS) {
                System.out.println("Hill climbing count: " + ++hillClimbingCount + " of " + config.MAX_ITERATIONS + " iterations.");
                hillClimbing.optimise(scic);
            }
            scic.updateSimultaneousConfidenceIntervals(alpha);
            if (mathsEngine == null) {
                throw new IllegalArgumentException("Maths engine cannot be null!");
            }
            MinMaxResult minMaxResult = (MinMaxResult)mathsEngine.computeResult(e, scic);
            if (minMaxResult.compareTo(bestResult) < 0) {
                bestResult = minMaxResult;
                iterationsWithoutImprovement = 0;
                continue;
            }
            ++iterationsWithoutImprovement;
        } while (scic.stateParameterObservations().size() > 1 && hillClimbingCount < config.MAX_ITERATIONS);
        return new ConfidenceInterval(bestResult.getMin(), bestResult.getMax(), alpha);
    }
}

