/*
 * Decompiled with CFR 0.152.
 */
package casestudies;

import confidenceIntervalCalculation.AlphaStartEndStep;
import confidenceIntervalCalculation.ConfidenceInterval;
import framework.FactFramework;
import inputOutput.FactInput;
import inputOutput.FileUtils;
import java.io.IOException;
import logging.FACTLogger;
import mathEngine.MatLabEngine;
import mathEngine.SimulatedMathsEngine;
import parametricModelChecking.OperatingSystem;
import parametricModelChecking.PrismDTMCModel;
import parametricModelChecking.PrismPCTLProperty;
import parametricModelChecking.PrismParametricModelChecker;

public abstract class CaseStudy {
    public FactFramework fact;
    public FactInput factInput;
    public static boolean MATLAB_ON = true;
    public static FACTLogger flog = new FACTLogger();
    public static String PRISMLOCATION = "/Applications/prism4.4/bin/prism";

    public void checkEngine() {
        if (this.fact.getMathsEngine() == null) {
            if (MATLAB_ON) {
                this.fact.setMathsEngine(new MatLabEngine(flog));
            } else {
                this.fact.setMathsEngine(new SimulatedMathsEngine());
            }
        }
    }

    public ConfidenceInterval run() {
        if (this.factInput.algebraicExpression == null) {
            this.modelCheck();
        }
        this.checkEngine();
        this.fact.calculateConfidenceInterval(this.factInput);
        return this.fact.getLastComputedCI();
    }

    public void modelCheck() {
        System.out.println("Prism is attempting parametric model checking");
        FACTLogger flog = null;
        this.factInput.algebraicExpression = this.fact.getPpmc().modelCheck(this.factInput.model, this.factInput.property, flog);
    }

    public CaseStudy(String modelFileLocation, String propertyFileLocation) {
        this.initialiseFactFramework();
        this.factInput = new FactInput();
        try {
            this.factInput.model = new PrismDTMCModel();
            this.factInput.model.setModel(FileUtils.readTextFileContents(modelFileLocation));
            this.factInput.property = new PrismPCTLProperty();
            this.factInput.property.setProperty(FileUtils.readTextFileContents(propertyFileLocation));
        }
        catch (IOException e) {
            System.out.println("Error caught in case study");
        }
        this.factInput.alphaStartEndStep = new AlphaStartEndStep(0.97, 0.99, 0.01);
    }

    public void initialiseFactFramework() {
        this.fact = new FactFramework();
        this.fact.setPpmc(new PrismParametricModelChecker(PRISMLOCATION, OperatingSystem.MAC));
    }
}

