/*
 * Decompiled with CFR 0.152.
 */
package application.view;

import application.Main;
import application.model.ExperimentData;
import application.model.FactExecution;
import application.model.ModelProperty;
import application.model.Settings;
import application.view.AnalysisParams;
import application.view.PrefController;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import logging.FACTLogger;

public class MainViewController {
    @FXML
    private Label lbStatus;
    @FXML
    private TextArea txtModel;
    @FXML
    private TableView<ModelProperty> tblProperties;
    @FXML
    private TableColumn<ModelProperty, String> propertyDetailColumn;
    @FXML
    private TableColumn<ModelProperty, String> propertyActionColumn;
    @FXML
    public LineChart<Number, Number> chtOutput;
    @FXML
    private Button btnLoadModel;
    @FXML
    private Button btnSaveModel;
    @FXML
    private Button btnLoadProperties;
    @FXML
    private Button btnAddProperty;
    @FXML
    private Button btnSaveProps;
    public Main mainApp;
    public static FACTLogger flog = new FACTLogger();
    public ExperimentData data = new ExperimentData(flog);
    public static Settings settings = new Settings();

    public MainViewController() {
        this.data.output.setValue("");
        ExperimentData.mVC = this;
    }

    @FXML
    private void initialize() {
        this.lbStatus.setText("Status: Initializing");
        this.txtModel.setText(this.data.getModelCode());
        this.propertyDetailColumn.setCellValueFactory(cellData -> ((ModelProperty)cellData.getValue()).detailProperty());
        this.propertyDetailColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.chtOutput.getData().add(this.data.chartSeries0);
        this.chtOutput.getData().add(this.data.chartSeries1);
        this.setContextMenu();
    }

    @FXML
    private void handleLoadModelButtonAction(ActionEvent event) {
        this.lbStatus.setText("Loading Model ...");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Model File");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Model", new String[]{"*.pm"})});
        File file = fileChooser.showOpenDialog((Window)this.mainApp.getPrimaryStage());
        if (file != null) {
            if (file.length() < 5120L) {
                this.data.loadModel(file);
                this.txtModel.setText(this.data.getModelCode());
                this.btnSaveModel.setDisable(false);
                this.lbStatus.setText(this.data.getStatus());
            } else {
                this.lbStatus.setText("Model file exceeds 5K");
            }
        } else {
            this.lbStatus.setText("Cancelled");
        }
    }

    @FXML
    private void handleSaveModelButtonAction(ActionEvent event) {
        this.lbStatus.setText("Saving Model ...");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Model File");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Model", new String[]{"*.pm"})});
        File file = fileChooser.showSaveDialog((Window)this.mainApp.getPrimaryStage());
        if (file != null) {
            this.data.setModel(this.txtModel.getText());
            this.data.saveModel(file);
            this.btnSaveModel.setDisable(true);
            this.lbStatus.setText(this.data.getStatus());
        } else {
            this.lbStatus.setText("Cancelled");
        }
    }

    @FXML
    private void handleSavePropertyButtonAction(ActionEvent event) {
        this.lbStatus.setText("Saving Properties ...");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Property File");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Property", new String[]{"*.pctl"})});
        File file = fileChooser.showSaveDialog((Window)this.mainApp.getPrimaryStage());
        if (file != null) {
            this.data.saveProps(file);
            this.btnSaveProps.setDisable(true);
            this.lbStatus.setText(this.data.getStatus());
        } else {
            this.lbStatus.setText("Cancelled");
        }
    }

    @FXML
    private void handleLoadPropertiesButtonAction(ActionEvent event) {
        this.lbStatus.setText("Loading Properties ...");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Properties File");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Property", new String[]{"*.pctl"})});
        File file = fileChooser.showOpenDialog((Window)this.mainApp.getPrimaryStage());
        if (file != null) {
            if (file.length() < 1024L) {
                this.data.loadProps(file);
                this.btnSaveProps.setDisable(false);
                this.lbStatus.setText(this.data.getStatus());
            } else {
                this.lbStatus.setText("Property file exceeds 1K");
            }
        } else {
            this.lbStatus.setText("Cancelled");
        }
    }

    @FXML
    private void handleModelChanged() {
        this.btnSaveModel.setDisable(false);
    }

    public void setMainApp(Main mainApp) {
        this.mainApp = mainApp;
        this.tblProperties.setItems(this.data.getPropertyData());
    }

    public void saveResults() {
        this.lbStatus.setText("Saving Results ...");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save results");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Results", new String[]{"*.csv"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
        File file = fileChooser.showSaveDialog((Window)this.mainApp.getPrimaryStage());
        if (file != null) {
            this.data.exportResults(file);
            this.lbStatus.setText(this.data.getStatus());
            this.data.resultsUnsaved = false;
        } else {
            this.lbStatus.setText("Cancelled");
        }
    }

    public void showPreferencesDialog() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("view/Preferences.fxml"));
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle("Preferences");
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.mainApp.getPrimaryStage());
            dialogStage.setResizable(false);
            Scene scene = new Scene((Parent)page);
            dialogStage.setScene(scene);
            PrefController controller = (PrefController)loader.getController();
            controller.settings = settings;
            controller.setDialogStage(dialogStage);
            dialogStage.showAndWait();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handlePropertyEdit(TableColumn.CellEditEvent<ModelProperty, String> t) {
        ((ModelProperty)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDetail((String)t.getNewValue());
        this.btnSaveProps.setDisable(false);
    }

    @FXML
    private void handleProperyAddButtonAction(ActionEvent event) {
        this.data.getPropertyData().add((Object)new ModelProperty("<new property>"));
        int listSize = this.data.getPropertyData().size() - 1;
        this.tblProperties.requestFocus();
        this.tblProperties.getSelectionModel().select(listSize);
        this.tblProperties.getFocusModel().focus(listSize);
    }

    private void setContextMenu() {
        this.tblProperties.setRowFactory((Callback)new Callback<TableView<ModelProperty>, TableRow<ModelProperty>>(){

            public TableRow<ModelProperty> call(TableView<ModelProperty> tableView) {
                final TableRow row = new TableRow();
                ContextMenu rowMenu = new ContextMenu();
                MenuItem evalItem = new MenuItem("Evaluate");
                evalItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        Boolean retVal;
                        if ((this).MainViewController.this.data.resultsUnsaved.booleanValue()) {
                            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                            alert.setTitle("Confirmation Dialog");
                            alert.setHeaderText("Unsaved results.");
                            alert.setContentText("You have unsaved results from the previous experiment\n click OK to continue.");
                            Optional result = alert.showAndWait();
                            if (result.get() != ButtonType.OK) {
                                return;
                            }
                        }
                        if ((retVal = MainViewController.this.showAnalysisDialog()).booleanValue()) {
                            (this).MainViewController.this.data.setEvalProp(((ModelProperty)row.getItem()).detailProperty().getValue());
                            (this).MainViewController.this.data.clearChartData();
                            (this).MainViewController.this.chtOutput.setAnimated(false);
                            (this).MainViewController.this.data.setModel(MainViewController.this.txtModel.getText());
                            MainViewController.this.lbStatus.setText("Evaluating: " + ((ModelProperty)row.getItem()).detailProperty().getValue());
                            FactExecution fe = new FactExecution((this).MainViewController.this.data);
                            (this).MainViewController.this.data.graphXMin = Float.valueOf((float)((double)((this).MainViewController.this.data.cnfLower.floatValue() - 1.0f) / 100.0));
                            (this).MainViewController.this.data.graphXMax = Float.valueOf((float)((double)((this).MainViewController.this.data.cnfUpper.floatValue() + 1.0f) / 100.0));
                            NumberAxis nx = (NumberAxis)(this).MainViewController.this.chtOutput.getXAxis();
                            nx.setLowerBound((double)(this).MainViewController.this.data.graphXMin.floatValue());
                            nx.setUpperBound((double)(this).MainViewController.this.data.graphXMax.floatValue());
                            nx.setTickUnit(0.005);
                            nx.setMinorTickCount(2);
                            NumberAxis ny = (NumberAxis)(this).MainViewController.this.chtOutput.getYAxis();
                            ny.setLowerBound(0.0);
                            ny.setUpperBound(1.0);
                            ny.setTickUnit(0.25);
                            ny.setMinorTickCount(5);
                            fe.lbStatus = MainViewController.this.lbStatus;
                            String s = settings.get("hillClimbingMax");
                            (this).MainViewController.this.data.fInput.config.MAX_ITERATIONS = Integer.parseInt(s);
                            fe.run();
                            MainViewController.this.lbStatus.setText((this).MainViewController.this.data.output.get());
                        }
                    }
                });
                MenuItem removeItem = new MenuItem("Delete");
                removeItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        MainViewController.this.lbStatus.setText("Deleting");
                        MainViewController.this.tblProperties.getItems().remove(row.getItem());
                        MainViewController.this.lbStatus.setText("Done");
                    }
                });
                rowMenu.getItems().addAll((Object[])new MenuItem[]{evalItem, removeItem});
                row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)row.itemProperty())).then((Object)rowMenu).otherwise(null));
                return row;
            }
        });
    }

    public Boolean showAnalysisDialog() {
        Boolean retVal = false;
        if (this.data.running.booleanValue()) {
            return false;
        }
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("view/AnalysisParams.fxml"));
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle("Analysis Parameters");
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.mainApp.getPrimaryStage());
            dialogStage.setResizable(false);
            Scene scene = new Scene((Parent)page);
            dialogStage.setScene(scene);
            AnalysisParams controller = (AnalysisParams)loader.getController();
            controller.setDialogStage(dialogStage);
            controller.settings = settings;
            controller.loadSettings();
            dialogStage.showAndWait();
            if (controller.isOkClicked()) {
                this.data.setconfidenceValue(controller.getAlphaL(), controller.getAlphaU(), controller.getAlphaS());
                Integer iLCI = Math.round(controller.getAlphaL().floatValue());
                Integer iUCI = Math.round(controller.getAlphaU().floatValue());
                settings.add("lowerCI", iLCI.toString());
                settings.add("upperCI", iUCI.toString());
                settings.add("stepCI", controller.getAlphaS().toString());
                settings.add("hillClimbingMax", controller.getHillClimbingMax().toString());
                settings.write();
                retVal = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public void setStatus(String msg) {
        this.lbStatus.setText(msg);
    }
}

