/*
 * Decompiled with CFR 0.152.
 */
package application.view;

import application.model.Settings;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;

public class AnalysisParams {
    private Stage dialogStage;
    private boolean okClicked = false;
    @FXML
    private Button btnOK;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnFile;
    @FXML
    private TextField txtCIUpper;
    @FXML
    private TextField txtCILower;
    @FXML
    private TextField txtCIStep;
    @FXML
    private TextField txtHillClimbing;
    @FXML
    private Label lblStatus;
    private Float alphaL;
    private Float alphaU;
    private Float alphaS;
    private Integer HillClimbingMax;
    public Settings settings;

    public Float getAlphaL() {
        return this.alphaL;
    }

    public Float getAlphaU() {
        return this.alphaU;
    }

    public Float getAlphaS() {
        return this.alphaS;
    }

    public Integer getHillClimbingMax() {
        return this.HillClimbingMax;
    }

    @FXML
    private void initialize() {
    }

    public void setDialogStage(Stage dialogStage) {
        this.dialogStage = dialogStage;
    }

    public boolean isOkClicked() {
        return this.okClicked;
    }

    @FXML
    private void handleOk() {
        this.okClicked = true;
        if (this.txtCIUpper.getText().equals("")) {
            this.lblStatus.setText("Invalid Interval");
            return;
        }
        if (this.txtCILower.getText().equals("")) {
            this.lblStatus.setText("Invalid Interval");
            return;
        }
        this.alphaU = Float.valueOf(Float.parseFloat(this.txtCIUpper.getText()));
        this.alphaL = Float.valueOf(Float.parseFloat(this.txtCILower.getText()));
        this.alphaS = Float.valueOf(Float.parseFloat(this.txtCIStep.getText()));
        if (this.alphaU.floatValue() <= this.alphaL.floatValue()) {
            this.lblStatus.setText("Lower bound must be less than upper bound");
            return;
        }
        if (this.alphaU.floatValue() < 85.0f || this.alphaL.floatValue() < 85.0f) {
            this.lblStatus.setText("Minimum confidence = 85%");
            return;
        }
        this.HillClimbingMax = Integer.parseInt(this.txtHillClimbing.getText());
        this.dialogStage.close();
    }

    @FXML
    private void handleNumberL(KeyEvent evt) {
        String character = evt.getCharacter();
        String valid = "0123456789";
        this.lblStatus.setText("");
        if (!valid.contains(character)) {
            evt.consume();
            this.lblStatus.setText("Numbers only");
            return;
        }
        String s = String.valueOf(this.txtCILower.getText()) + character;
        if (!this.validateCI(s).booleanValue()) {
            evt.consume();
            this.lblStatus.setText("Invalid Interval");
        }
    }

    @FXML
    private void handleNumberU(KeyEvent evt) {
        String character = evt.getCharacter();
        String valid = "0123456789";
        this.lblStatus.setText("");
        if (!valid.contains(character)) {
            evt.consume();
            this.lblStatus.setText("Numbers only");
            return;
        }
        String s = String.valueOf(this.txtCIUpper.getText()) + character;
        if (!this.validateCI(s).booleanValue()) {
            evt.consume();
            this.lblStatus.setText("Invalid Interval");
        }
    }

    @FXML
    private void handleNumberS(KeyEvent evt) {
        String character = evt.getCharacter();
        String valid = "0123456789.";
        this.lblStatus.setText("");
        if (!valid.contains(character)) {
            evt.consume();
            this.lblStatus.setText("Numbers only");
            return;
        }
        String s = String.valueOf(this.txtCIStep.getText()) + character;
        if (!this.validateCI(s).booleanValue()) {
            evt.consume();
            this.lblStatus.setText("Invalid Interval");
        }
    }

    @FXML
    private void handleNumberHC(KeyEvent evt) {
        String character = evt.getCharacter();
        String valid = "0123456789";
        this.lblStatus.setText("");
        if (!valid.contains(character)) {
            evt.consume();
            this.lblStatus.setText("Numbers only");
            return;
        }
        String s = String.valueOf(this.txtCIStep.getText()) + character;
        if (!this.validateHC(s).booleanValue()) {
            evt.consume();
            this.lblStatus.setText("Invalid Limit");
        }
    }

    private Boolean validateHC(String s) {
        try {
            Float v = Float.valueOf(Float.parseFloat(s));
            if (v.floatValue() > 99.0f) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Boolean validateCI(String s) {
        try {
            Float v = Float.valueOf(Float.parseFloat(s));
            if (v.floatValue() > 99.0f) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @FXML
    private void handleCancel() {
        this.okClicked = false;
        this.dialogStage.close();
    }

    public void loadSettings() {
        this.settings.read();
        if (this.settings.get("lowerCI") != null) {
            this.txtCILower.setText(this.settings.get("lowerCI"));
        }
        if (this.settings.get("upperCI") != null) {
            this.txtCIUpper.setText(this.settings.get("upperCI"));
        }
        if (this.settings.get("stepCI") != null) {
            this.txtCIStep.setText(this.settings.get("stepCI"));
        }
        if (this.settings.get("hillClimbingMax") != null) {
            this.txtHillClimbing.setText(this.settings.get("hillClimbingMax"));
        }
    }
}

