/*
 * Decompiled with CFR 0.152.
 */
package confidenceIntervalCalculation;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.special.Erf;

public class StatisticsConversion {
    private static NormalDistribution dist = new NormalDistribution();

    static {
        dist = new NormalDistribution();
    }

    public static double calculatePvalue(double aZValue) {
        double lPvalue = 0.0;
        lPvalue = Erf.erf(aZValue /= Math.sqrt(2.0));
        return lPvalue;
    }

    public static double cumulativeProbability(double aZValue) {
        double lQuantile = 0.5;
        lQuantile = dist.cumulativeProbability(aZValue);
        return lQuantile;
    }

    public static double cumulativeProbability(double aLowerZValue, double aHigherZValue) {
        double lQuantile = 0.5;
        lQuantile = dist.cumulativeProbability(aLowerZValue, aHigherZValue);
        return lQuantile;
    }

    public static double inverseCumulativeProbability(double aProbability) {
        double lZscore = 0.0;
        lZscore = dist.inverseCumulativeProbability(aProbability);
        return lZscore;
    }

    private static double calculateZscore(double aQuantile) {
        double zero = 0.0;
        double one = 1.0;
        double half = 0.5;
        double split1 = 0.425;
        double split2 = 5.0;
        double const1 = 0.180625;
        double const2 = 1.6;
        double[] a = new double[]{3.3871327179, 50.434271938, 159.29113202, 59.10937472};
        double[] b = new double[]{0.0, 17.895169469, 78.757757664, 67.2};
        double[] c = new double[]{1.4234372777, 2.75681539, 1.3067284816, 0.17023821103};
        double[] d = new double[]{0.0, 0.7370016425, 0.12021132975};
        double[] e = new double[]{6.657905115, 3.081226386, 0.42868294337, 0.017337203997};
        double[] f = new double[]{0.0, 0.24197894225, 0.012258202635};
        double q = aQuantile - half;
        if (Math.abs(q) <= split1) {
            double r = const1 - q * q;
            double ret = q * (((a[3] * r + a[2]) * r + a[1]) * r + a[0]) / (((b[3] * r + b[2]) * r + b[1]) * r + one);
            return ret;
        }
        double r = q < zero ? aQuantile : one - aQuantile;
        if (r <= zero) {
            return zero;
        }
        double ret = (r = Math.sqrt(-Math.log(r))) <= split2 ? (((c[3] * (r -= const2) + c[2]) * r + c[1]) * r + c[0]) / ((d[2] * r + d[1]) * r + one) : (((e[3] * (r -= split2) + e[2]) * r + e[1]) * r + e[0]) / ((f[2] * r + f[1]) * r + one);
        if (q < zero) {
            ret = -ret;
        }
        return ret;
    }

    public static double calculateOneSidedZscore(double aQuantile) {
        return StatisticsConversion.calculateZscore(aQuantile);
    }

    public static double calculateTwoSidedZscore(double aQuantile) {
        double p = aQuantile;
        p = 1.0 - (1.0 - p) / 2.0;
        return StatisticsConversion.calculateZscore(p);
    }
}

