/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.mathcollection.Coefficients;
import org.mariuszgromada.math.mxparser.mathcollection.Evaluate;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;

public final class SpecialFunctions {
    private static final double EI_DBL_EPSILON = Math.ulp(1.0);
    private static final double EI_EPSILON = 10.0 * EI_DBL_EPSILON;

    public static double exponentialIntegralEi(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x < -5.0) {
            return SpecialFunctions.continuedFractionEi(x);
        }
        if (x == 0.0) {
            return -1.7976931348623157E308;
        }
        if (x < 6.8) {
            return SpecialFunctions.powerSeriesEi(x);
        }
        if (x < 50.0) {
            return SpecialFunctions.argumentAdditionSeriesEi(x);
        }
        return SpecialFunctions.continuedFractionEi(x);
    }

    private static double continuedFractionEi(double x) {
        double Am1 = 1.0;
        double A0 = 0.0;
        double Bm1 = 0.0;
        double B0 = 1.0;
        double a = Math.exp(x);
        double b = -x + 1.0;
        double Ap1 = b * A0 + a * Am1;
        double Bp1 = b * B0 + a * Bm1;
        int j = 1;
        a = 1.0;
        while (Math.abs(Ap1 * B0 - A0 * Bp1) > EI_EPSILON * Math.abs(A0 * Bp1)) {
            if (Math.abs(Bp1) > 1.0) {
                Am1 = A0 / Bp1;
                A0 = Ap1 / Bp1;
                Bm1 = B0 / Bp1;
                B0 = 1.0;
            } else {
                Am1 = A0;
                A0 = Ap1;
                Bm1 = B0;
                B0 = Bp1;
            }
            a = -j * j;
            Ap1 = (b += 2.0) * A0 + a * Am1;
            Bp1 = b * B0 + a * Bm1;
            ++j;
        }
        return -Ap1 / Bp1;
    }

    private static double powerSeriesEi(double x) {
        double xn = -x;
        double Sn = -x;
        double Sm1 = 0.0;
        double hsum = 1.0;
        double g = 0.5772156649015329;
        double y = 1.0;
        double factorial = 1.0;
        if (x == 0.0) {
            return -1.7976931348623157E308;
        }
        while (Math.abs(Sn - Sm1) > EI_EPSILON * Math.abs(Sm1)) {
            Sm1 = Sn;
            Sn += (hsum += 1.0 / y) * (xn *= -x) / (factorial *= (y += 1.0));
        }
        return 0.5772156649015329 + Math.log(Math.abs(x)) - Math.exp(x) * Sn;
    }

    private static double argumentAdditionSeriesEi(double x) {
        int k = (int)(x + 0.5);
        int j = 0;
        double xx = k;
        double dx = x - xx;
        double xxj = xx;
        double edx = Math.exp(dx);
        double Sm = 1.0;
        double Sn = (edx - 1.0) / xxj;
        double term = Double.MAX_VALUE;
        double factorial = 1.0;
        double dxj = 1.0;
        while (Math.abs(term) > EI_EPSILON * Math.abs(Sn)) {
            term = factorial * (edx * (Sm += (dxj *= -dx) / (factorial *= (double)(++j))) - 1.0) / (xxj *= xx);
            Sn += term;
        }
        return Coefficients.EI[k - 7] + Sn * Math.exp(xx);
    }

    public static final double logarithmicIntegralLi(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 2.0) {
            return 1.045163780117493;
        }
        return SpecialFunctions.exponentialIntegralEi(MathFunctions.ln(x));
    }

    public static final double offsetLogarithmicIntegralLi(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return -1.045163780117493;
        }
        return SpecialFunctions.logarithmicIntegralLi(x) - 1.045163780117493;
    }

    public static final double erf(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return -1.0;
        }
        return SpecialFunctions.erfImp(x, false);
    }

    public static final double erfc(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 1.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 2.0;
        }
        return SpecialFunctions.erfImp(x, true);
    }

    public static final double erfInv(double x) {
        double s;
        double q;
        double p;
        if (x == 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (x <= -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x < 0.0) {
            p = -x;
            q = 1.0 - p;
            s = -1.0;
        } else {
            p = x;
            q = 1.0 - x;
            s = 1.0;
        }
        return SpecialFunctions.erfInvImpl(p, q, s);
    }

    private static final double erfImp(double z, boolean invert) {
        double result;
        if (z < 0.0) {
            if (!invert) {
                return -SpecialFunctions.erfImp(-z, false);
            }
            if (z < -0.5) {
                return 2.0 - SpecialFunctions.erfImp(-z, true);
            }
            return 1.0 + SpecialFunctions.erfImp(-z, false);
        }
        if (z < 0.5) {
            result = z < 1.0E-10 ? z * 1.125 + z * 0.0033791670955125737 : z * 1.125 + z * Evaluate.polynomial(z, Coefficients.erfImpAn) / Evaluate.polynomial(z, Coefficients.erfImpAd);
        } else if (z < 110.0 || z < 110.0 && invert) {
            double b;
            double r;
            boolean bl = invert = !invert;
            if (z < 0.75) {
                r = Evaluate.polynomial(z - 0.5, Coefficients.erfImpBn) / Evaluate.polynomial(z - 0.5, Coefficients.erfImpBd);
                b = 0.3440242111682892;
            } else if (z < 1.25) {
                r = Evaluate.polynomial(z - 0.75, Coefficients.erfImpCn) / Evaluate.polynomial(z - 0.75, Coefficients.erfImpCd);
                b = 0.4199909269809723;
            } else if (z < 2.25) {
                r = Evaluate.polynomial(z - 1.25, Coefficients.erfImpDn) / Evaluate.polynomial(z - 1.25, Coefficients.erfImpDd);
                b = 0.4898625f;
            } else if (z < 3.5) {
                r = Evaluate.polynomial(z - 2.25, Coefficients.erfImpEn) / Evaluate.polynomial(z - 2.25, Coefficients.erfImpEd);
                b = 0.5317370891571045;
            } else if (z < 5.25) {
                r = Evaluate.polynomial(z - 3.5, Coefficients.erfImpFn) / Evaluate.polynomial(z - 3.5, Coefficients.erfImpFd);
                b = 0.5489973425865173;
            } else if (z < 8.0) {
                r = Evaluate.polynomial(z - 5.25, Coefficients.erfImpGn) / Evaluate.polynomial(z - 5.25, Coefficients.erfImpGd);
                b = 0.5571740865707397;
            } else if (z < 11.5) {
                r = Evaluate.polynomial(z - 8.0, Coefficients.erfImpHn) / Evaluate.polynomial(z - 8.0, Coefficients.erfImpHd);
                b = 0.5609807968139648;
            } else if (z < 17.0) {
                r = Evaluate.polynomial(z - 11.5, Coefficients.erfImpIn) / Evaluate.polynomial(z - 11.5, Coefficients.erfImpId);
                b = 0.5626493692398071;
            } else if (z < 24.0) {
                r = Evaluate.polynomial(z - 17.0, Coefficients.erfImpJn) / Evaluate.polynomial(z - 17.0, Coefficients.erfImpJd);
                b = 0.5634598135948181;
            } else if (z < 38.0) {
                r = Evaluate.polynomial(z - 24.0, Coefficients.erfImpKn) / Evaluate.polynomial(z - 24.0, Coefficients.erfImpKd);
                b = 0.5638477802276611;
            } else if (z < 60.0) {
                r = Evaluate.polynomial(z - 38.0, Coefficients.erfImpLn) / Evaluate.polynomial(z - 38.0, Coefficients.erfImpLd);
                b = 0.5640528202056885;
            } else if (z < 85.0) {
                r = Evaluate.polynomial(z - 60.0, Coefficients.erfImpMn) / Evaluate.polynomial(z - 60.0, Coefficients.erfImpMd);
                b = 0.5641309022903442;
            } else {
                r = Evaluate.polynomial(z - 85.0, Coefficients.erfImpNn) / Evaluate.polynomial(z - 85.0, Coefficients.erfImpNd);
                b = 0.5641584396362305;
            }
            double g = MathFunctions.exp(-z * z) / z;
            result = g * b + g * r;
        } else {
            result = 0.0;
            boolean bl = invert = !invert;
        }
        if (invert) {
            result = 1.0 - result;
        }
        return result;
    }

    public static final double erfcInv(double z) {
        double s;
        double p;
        double q;
        if (z <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (z >= 2.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (z > 1.0) {
            q = 2.0 - z;
            p = 1.0 - q;
            s = -1.0;
        } else {
            p = 1.0 - z;
            q = z;
            s = 1.0;
        }
        return SpecialFunctions.erfInvImpl(p, q, s);
    }

    private static final double erfInvImpl(double p, double q, double s) {
        double result;
        if (p <= 0.5) {
            float y = 0.089131474f;
            double g = p * (p + 10.0);
            double r = Evaluate.polynomial(p, Coefficients.ervInvImpAn) / Evaluate.polynomial(p, Coefficients.ervInvImpAd);
            result = g * 0.08913147449493408 + g * r;
        } else if (q >= 0.25) {
            float y = 2.2494812f;
            double g = MathFunctions.sqrt(-2.0 * MathFunctions.ln(q));
            double xs = q - 0.25;
            double r = Evaluate.polynomial(xs, Coefficients.ervInvImpBn) / Evaluate.polynomial(xs, Coefficients.ervInvImpBd);
            result = g / (2.249481201171875 + r);
        } else {
            double x = MathFunctions.sqrt(-MathFunctions.ln(q));
            if (x < 3.0) {
                float y = 0.80722046f;
                double xs = x - 1.125;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpCn) / Evaluate.polynomial(xs, Coefficients.ervInvImpCd);
                result = 0.807220458984375 * x + r * x;
            } else if (x < 6.0) {
                float y = 0.9399557f;
                double xs = x - 3.0;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpDn) / Evaluate.polynomial(xs, Coefficients.ervInvImpDd);
                result = 0.9399557113647461 * x + r * x;
            } else if (x < 18.0) {
                float y = 0.9836283f;
                double xs = x - 6.0;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpEn) / Evaluate.polynomial(xs, Coefficients.ervInvImpEd);
                result = 0.9836282730102539 * x + r * x;
            } else if (x < 44.0) {
                float y = 0.99714565f;
                double xs = x - 18.0;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpFn) / Evaluate.polynomial(xs, Coefficients.ervInvImpFd);
                result = 0.9971456527709961 * x + r * x;
            } else {
                float y = 0.9994135f;
                double xs = x - 44.0;
                double r = Evaluate.polynomial(xs, Coefficients.ervInvImpGn) / Evaluate.polynomial(xs, Coefficients.ervInvImpGd);
                result = 0.9994134902954102 * x + r * x;
            }
        }
        return s * result;
    }
}

