/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class HyperStarToPrism {
    public static void main(String[] args) {
        BufferedReader fileReader = null;
        BufferedWriter fileWriter = null;
        boolean append = true;
        String sTemplate = "";
        String sTemplateOut = "";
        if (args.length < 4) {
            System.out.println("Error - HyperStarToPrism inFile outFile moduleName moduleShortName append=true templateIn templateOut");
            System.exit(1);
        }
        String modName = args[2];
        String modShortName = args[3];
        System.out.println("HyperStart 2 Prism - Version 2.1");
        if (args.length > 4) {
            if (args[4].toLowerCase().charAt(0) == 'f') {
                append = false;
            }
            if (args.length > 5) {
                sTemplate = HyperStarToPrism.readTemplate(args[5]);
                sTemplateOut = args[6];
            }
        }
        Integer iBranches = 0;
        Integer[] iPhases = null;
        Double[] dLambda = null;
        Double[] dProb = null;
        try {
            fileReader = new BufferedReader(new FileReader(args[0]));
            fileReader.readLine();
            fileReader.readLine();
            iBranches = Integer.parseInt(fileReader.readLine());
            System.out.println("branches: " + iBranches);
            iPhases = new Integer[iBranches.intValue()];
            dLambda = new Double[iBranches.intValue()];
            dProb = new Double[iBranches.intValue()];
            fileReader.readLine();
            fileReader.readLine();
            int i = 0;
            while (i < iBranches) {
                iPhases[i] = Integer.parseInt(fileReader.readLine());
                System.out.println("phase [" + i + "]: " + iPhases[i]);
                ++i;
            }
            fileReader.readLine();
            fileReader.readLine();
            i = 0;
            while (i < iBranches) {
                dLambda[i] = Double.parseDouble(fileReader.readLine());
                System.out.println("lambda [" + i + "]: " + dLambda[i]);
                ++i;
            }
            fileReader.readLine();
            fileReader.readLine();
            i = 0;
            while (i < iBranches) {
                dProb[i] = Double.parseDouble(fileReader.readLine());
                System.out.println("prob [" + i + "]: " + dProb[i]);
                ++i;
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<branch> branches = new ArrayList<branch>();
        int i = 0;
        while (i < iBranches) {
            branch b = new branch();
            b.phases = iPhases[i];
            b.prob = dProb[i];
            b.lambda = dLambda[i];
            Boolean exists = false;
            int j = 0;
            while (j < branches.size()) {
                if (((branch)branches.get(j)).compare(b).booleanValue()) {
                    exists = true;
                    System.out.println("Pruning branch");
                    System.out.println("Prob Before: " + ((branch)branches.get((int)j)).prob);
                    ((branch)branches.get((int)j)).prob = ((branch)branches.get((int)j)).prob + b.prob;
                    System.out.println("Prob After: " + ((branch)branches.get((int)j)).prob);
                }
                ++j;
            }
            if (!exists.booleanValue()) {
                branches.add(b);
            }
            ++i;
        }
        System.out.println("Creating model from :");
        int j = 0;
        while (j < branches.size()) {
            System.out.print("Branch " + j + ":");
            int ph = ((branch)branches.get((int)j)).phases;
            double lm = ((branch)branches.get((int)j)).lambda;
            double prob = ((branch)branches.get((int)j)).prob;
            System.out.println(" Ph: " + ph + ", Lm: " + lm + ", Pr: " + prob);
            ++j;
        }
        HyperStarToPrism.updateTemplate(sTemplate, modShortName, branches.size(), sTemplateOut);
        try {
            fileWriter = new BufferedWriter(new FileWriter(args[1], append));
            fileWriter.write("\n// Hyperstar to PRISM - " + modName + " module.\n\n\n");
            i = 0;
            while (i < branches.size()) {
                fileWriter.write("const double rate_" + modShortName + (i + 1) + " = " + ((branch)branches.get((int)i)).lambda * 1000.0 + ";\n");
                ++i;
            }
            fileWriter.write("\n");
            i = 0;
            while (i < branches.size()) {
                fileWriter.write("const " + modShortName + "Stage" + (i + 1) + " = " + ((branch)branches.get((int)i)).phases + ";\n");
                ++i;
            }
            fileWriter.write("\n");
            fileWriter.write("module " + modName + "\n");
            String indent = "   ";
            String stateName = String.valueOf(modShortName) + "_i";
            fileWriter.write(String.valueOf(indent) + stateName + " : [0.." + branches.size() + "] init 0;\n");
            fileWriter.write(String.valueOf(indent) + "[" + modShortName + "Start] " + stateName + " = 0 ->\n");
            int i2 = 0;
            while (i2 < branches.size() - 1) {
                fileWriter.write(String.valueOf(indent) + indent + ((branch)branches.get((int)i2)).prob + " * instant : (" + stateName + "' = " + (i2 + 1) + ")+\n");
                ++i2;
            }
            fileWriter.write(String.valueOf(indent) + indent + ((branch)branches.get((int)(branches.size() - 1))).prob + " * instant : (" + stateName + "' = " + branches.size() + ");\n\n");
            i2 = 0;
            while (i2 < branches.size()) {
                fileWriter.write(String.valueOf(indent) + "[" + modShortName + (i2 + 1) + "] " + stateName + " = " + (i2 + 1) + " -> (" + stateName + "'=" + (i2 + 1) + ");\n");
                ++i2;
            }
            i2 = 0;
            while (i2 < branches.size()) {
                fileWriter.write(String.valueOf(indent) + "[fin" + modShortName + (i2 + 1) + "] " + stateName + " = " + (i2 + 1) + " -> (" + stateName + "'=0);\n");
                ++i2;
            }
            fileWriter.write("endmodule\n\n");
            fileWriter.write("module " + modName + "1\n");
            stateName = String.valueOf(modShortName) + "1_i";
            fileWriter.write(String.valueOf(indent) + stateName + " : [1.." + modShortName + "Stage1+1] init 1;\n");
            fileWriter.write(String.valueOf(indent) + "[" + modShortName + "1] " + stateName + "< " + modShortName + "Stage1 -> rate_" + modShortName + "1 : (" + stateName + "' = " + stateName + " + 1);\n");
            fileWriter.write(String.valueOf(indent) + "[fin" + modShortName + "1] " + stateName + " = " + modShortName + "Stage1 -> rate_" + modShortName + "1 : (" + stateName + "' = 1);\n");
            fileWriter.write("endmodule\n\n");
            String oldStateName = stateName;
            int i3 = 2;
            while (i3 <= branches.size()) {
                stateName = String.valueOf(modShortName) + i3 + "_i";
                fileWriter.write("module " + modName + i3 + " = " + modName + "1 [" + oldStateName + "=" + stateName + ", " + modShortName + "1=" + modShortName + i3 + ", fin" + modShortName + "1=fin" + modShortName + i3 + "," + modShortName + "Stage1=" + modShortName + "Stage" + i3 + ", rate_" + modShortName + "1=rate_" + modShortName + i3 + "] endmodule\n");
                ++i3;
            }
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static String readTemplate(String sFileName) {
        BufferedReader fileReader = null;
        String sReturn = "";
        try {
            fileReader = new BufferedReader(new FileReader(sFileName));
            String line = "";
            while ((line = fileReader.readLine()) != null) {
                sReturn = String.valueOf(sReturn) + line + "\n";
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sReturn;
    }

    static void updateTemplate(String sTemplate, String sModShortName, int Branches, String outFile) {
        BufferedWriter fileWriter = null;
        int start = 0;
        while (start >= 0) {
            start = sTemplate.indexOf("<#" + sModShortName + ">");
            if (start < 0) continue;
            int end = sTemplate.indexOf(10, start);
            String sLine = sTemplate.substring(start, end);
            String pre = sTemplate.substring(0, start);
            String post = sTemplate.substring(end);
            int i = 1;
            while (i <= Branches) {
                int from = sLine.indexOf(62);
                String newLine = "[fin" + sModShortName + i + "]" + sLine.substring(from + 1) + "\n";
                pre = String.valueOf(pre) + newLine;
                ++i;
            }
            sTemplate = String.valueOf(pre) + "\n" + post;
        }
        try {
            fileWriter = new BufferedWriter(new FileWriter(outFile, false));
            fileWriter.write(String.valueOf(sTemplate) + "\n");
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

