/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class GUIGroupedTableColumnModel
extends DefaultTableColumnModel
implements TableColumnModelListener {
    private DefaultTableColumnModel groupTableColumnModel;
    private ArrayList<Integer> lastColumn = new ArrayList();

    public GUIGroupedTableColumnModel() {
        this.groupTableColumnModel = new DefaultTableColumnModel();
    }

    public DefaultTableColumnModel getGroupTableColumnModel() {
        return this.groupTableColumnModel;
    }

    public void addColumnGroup(TableColumn tableColumn, ArrayList<TableColumn> arrayList) {
        this.groupTableColumnModel.addColumn(tableColumn);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.addColumn(arrayList.get(i));
        }
        this.lastColumn.add(new Integer(this.getColumnCount() - 1));
        this.updateGroups();
    }

    public void updateGroups() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            n2 += this.getColumn(i).getWidth();
            if (i != this.lastColumn.get(n)) continue;
            while (n < this.groupTableColumnModel.getColumnCount() && i == this.lastColumn.get(n)) {
                this.groupTableColumnModel.getColumn(n).setWidth(n2);
                n2 = 0;
                ++n;
            }
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    protected void fireColumnMarginChanged() {
        this.updateGroups();
        super.fireColumnMarginChanged();
    }

    public void clear() {
        while (this.getColumnCount() > 0) {
            this.removeColumn(this.getColumn(0));
        }
        while (this.groupTableColumnModel.getColumnCount() > 0) {
            this.groupTableColumnModel.removeColumn(this.groupTableColumnModel.getColumn(0));
        }
        this.lastColumn.clear();
    }
}

