/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import userinterface.util.PropertyException;
import userinterface.util.PropertyOwner;
import userinterface.util.SingleProperty;

public class BooleanProperty
extends SingleProperty {
    JPanel pan = new JPanel();
    JCheckBox renderer = new JCheckBox();

    public BooleanProperty(PropertyOwner propertyOwner, String string, boolean bl) {
        this(propertyOwner, string, bl, "");
    }

    public BooleanProperty(PropertyOwner propertyOwner, String string, boolean bl, String string2) {
        super(propertyOwner, string, new Boolean(bl), "", false, string2);
        this.pan.setLayout(new GridBagLayout());
        this.renderer.setBorder(null);
        this.pan.add(this.renderer);
    }

    public void setBoolValue(boolean bl) {
        try {
            this.setProperty(new Boolean(bl));
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }

    public boolean getBoolValue() {
        return (Boolean)this.getProperty();
    }

    @Override
    public void setProperty(Object object) throws PropertyException {
        if (!(object instanceof Boolean)) {
            if (object instanceof String) {
                if (object.toString().equals("true") || object.toString().equals("false")) {
                    super.setProperty(new Boolean(Boolean.getBoolean((String)object)));
                }
                return;
            }
            throw new PropertyException("Value must be of type Boolean");
        }
        super.setProperty(object);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.renderer != null) {
            this.renderer.setEnabled(bl);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.renderer.setOpaque(true);
        this.renderer.setSelected(this.getBoolValue());
        if (bl) {
            this.renderer.setForeground(jTable.getSelectionForeground());
            this.renderer.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setForeground(jTable.getForeground());
            this.renderer.setBackground(jTable.getBackground());
        }
        if (bl2) {
            this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.pan.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.pan.setBorder(new EmptyBorder(0, 2, 2, 1));
            this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
            this.pan.setBackground(UIManager.getColor("Table.focusCellBackground"));
        }
        if (!this.isEnabled()) {
            this.pan.setBackground(Color.lightGray);
            this.renderer.setEnabled(false);
        } else {
            this.renderer.setEnabled(true);
        }
        return this.pan;
    }

    @Override
    public Component getTableCellRendererComponentMulti(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3) {
        if (bl3) {
            return this.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        this.renderer.setOpaque(true);
        this.renderer.setSelected(this.getBoolValue());
        if (bl) {
            this.renderer.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setBackground(jTable.getBackground());
        }
        if (bl2) {
            this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.pan.setBackground(new Color(240, 240, 240));
            }
        } else {
            this.pan.setBorder(new EmptyBorder(0, 2, 2, 1));
            this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
            this.pan.setBackground(new Color(240, 240, 240));
        }
        return this.pan;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.renderer.setSelected(this.getBoolValue());
        this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
        this.pan.setBackground(UIManager.getColor("Table.focusCellBackground"));
        if (!this.isEnabled()) {
            this.pan.setBackground(Color.lightGray);
            this.renderer.setEnabled(false);
        } else {
            this.renderer.setEnabled(true);
        }
        return this.pan;
    }

    @Override
    public Component getTableCellEditorComponentMulti(JTable jTable, Object object, boolean bl, int n, int n2, boolean bl2) {
        if (bl2) {
            return this.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
        this.pan.setBackground(new Color(240, 240, 240));
        if (!this.isEnabled()) {
            this.pan.setBackground(Color.lightGray);
            this.renderer.setEnabled(false);
        } else {
            this.renderer.setEnabled(true);
        }
        return this.pan;
    }

    public Boolean getEditorValue() {
        return new Boolean(this.renderer.isSelected());
    }

    public void addListenerToEditor(ActionListener actionListener) {
        this.renderer.addActionListener(actionListener);
    }

    public void removeListenerFromEditor(ActionListener actionListener) {
        this.renderer.removeActionListener(actionListener);
    }
}

