/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator.networking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.PrismException;
import prism.PrismSettings;
import prism.Result;
import prism.ResultsCollection;
import prism.UndefinedConstants;
import settings.SettingException;
import simulator.SimulatorEngine;
import simulator.networking.SimulatorNetworkHandler;
import simulator.networking.SimulatorResultsFile;
import userinterface.GUIPrism;
import userinterface.SimulationInformation;
import userinterface.model.Style;
import userinterface.properties.GUIExperiment;
import userinterface.properties.GUIMultiProperties;
import userinterface.properties.GUIProperty;
import userinterface.simulator.networking.GUINetworkEditor;

public class GUISimulatorDistributionDialog
extends JDialog
implements Observer {
    private SimulatorNetworkHandler network;
    private File netFile;
    private SimulatorEngine simulator;
    private boolean isExperiment;
    private GUIMultiProperties properties;
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;
    private ArrayList props;
    private SimulationInformation info;
    private GUIExperiment expr;
    private UndefinedConstants undefinedConstants;
    private Thread experimentThread;
    private Expression experimentFormula;
    private boolean cancelled = false;
    private ArrayList propertyValues = null;
    private JTable propertyTable;
    private PropertyResultsTable propResultsModel;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton cancelButton;
    private JButton doneButton;
    private JButton editButton;
    private JRadioButton feedbackIterationsProgressRadio;
    private JRadioButton feedbackResultsProgressRadio;
    private JRadioButton feedbackResultsWhenFinishedRadio;
    private JRadioButton feedbackWhenFinishedRadio;
    private JTable hostsTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextField networkProfileField;
    private JScrollPane resultsScroller;
    private JButton startButton;
    private JButton stopButton;
    private JPanel summaryPanel;
    private JEditorPane summaryText;
    private JButton testButton;
    Style PLAIN_S = new Style(Color.black, 0);
    Style BOLD_S = new Style(Color.black, 1);

    public GUISimulatorDistributionDialog(Frame frame, SimulatorEngine simulatorEngine, boolean bl) {
        super(frame, bl);
        this.setTitle("PRISM Distributed Simulator");
        this.simulator = simulatorEngine;
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        SummaryEditorKit summaryEditorKit = new SummaryEditorKit();
        this.summaryText.setEditorKitForContentType("text/summary", summaryEditorKit);
        this.summaryText.setContentType("text/summary");
        this.summaryText.getDocument().putProperty("tabSize", new Integer(2));
        this.summaryText.setSelectionColor(Color.white);
        this.summaryText.setEnabled(false);
        TableColumn tableColumn = this.hostsTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(new ProgressBarRenderer());
    }

    public void show(GUIExperiment gUIExperiment, Thread thread, ModulesFile modulesFile, PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, Expression expression, SimulationInformation simulationInformation) throws PrismException {
        this.isExperiment = true;
        this.modulesFile = modulesFile;
        this.propertiesFile = propertiesFile;
        this.experimentFormula = expression;
        this.expr = gUIExperiment;
        this.info = simulationInformation;
        this.experimentThread = thread;
        this.undefinedConstants = undefinedConstants;
        PrismSettings prismSettings = GUIPrism.getGUI().getPrism().getSettings();
        this.netFile = prismSettings.getFile("simulator.networkFile");
        this.loadNetworkProfile(this.netFile);
        this.doHostTable();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("Experiment for property:\n\t" + expression.toString() + "\n");
        stringBuffer.append("Defined Model Constants:\n\t" + undefinedConstants.getMFConstantValues() + "\n");
        stringBuffer.append("Property Constant Ranges:\n\t" + gUIExperiment.getPFDefinedConstantsString() + "\n");
        stringBuffer.append("Total simulator iterations:\n\t" + simulationInformation.getNumSamples() + "\n");
        stringBuffer.append("Simulator max. path length:\n\t" + simulationInformation.getMaxPathLength() + "\n");
        stringBuffer.append("Initial state:\n\t" + simulationInformation.getInitialState().toString() + "\n");
        this.summaryText.setText(stringBuffer.toString());
        JLabel jLabel = new JLabel("No Results Display for Experiments");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jLabel.setAlignmentX(0.5f);
        jLabel.setEnabled(false);
        jPanel.add(jLabel);
        this.resultsScroller.setViewportView(jPanel);
        this.network.addObserver(this);
        super.show();
        if (!this.cancelled) {
            ResultsCollection resultsCollection = gUIExperiment.getResults();
            SimulatorResultsFile simulatorResultsFile = this.network.getResultsFile();
            if (this.propertyValues != null) {
                for (int i = 0; i < undefinedConstants.getNumPropertyIterations(); ++i) {
                    Values values = undefinedConstants.getMFConstantValues();
                    Values values2 = (Values)this.propertyValues.get(i);
                    double d = simulatorResultsFile.getResult(i);
                    Double d2 = d < 0.0 ? null : new Double(d);
                    resultsCollection.setResult(values, values2, d2);
                }
            }
        }
    }

    public void show(GUIMultiProperties gUIMultiProperties, ModulesFile modulesFile, PropertiesFile propertiesFile, ArrayList arrayList, SimulationInformation simulationInformation) throws PrismException {
        GUIProperty gUIProperty;
        int n;
        this.isExperiment = false;
        this.properties = gUIMultiProperties;
        this.modulesFile = modulesFile;
        this.propertiesFile = propertiesFile;
        this.props = arrayList;
        this.info = simulationInformation;
        PrismSettings prismSettings = GUIPrism.getGUI().getPrism().getSettings();
        this.netFile = prismSettings.getFile("simulator.networkFile");
        this.loadNetworkProfile(this.netFile);
        this.doHostTable();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("Verifying " + arrayList.size() + (arrayList.size() == 1 ? " property:\n" : " properties:\n"));
        String string = "";
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n) instanceof GUIProperty) {
                gUIProperty = (GUIProperty)arrayList.get(n);
                stringBuffer.append("\t" + gUIProperty.getProperty().toString() + "\n");
                string = gUIProperty.getConstantsString();
                continue;
            }
            stringBuffer.append("form" + arrayList.get(n).getClass().toString());
        }
        stringBuffer.append("Total simulator iterations:\n\t" + simulationInformation.getNumSamples() + "\n");
        stringBuffer.append("Simulator max. path length:\n\t" + simulationInformation.getMaxPathLength() + "\n");
        stringBuffer.append("Initial state:\n\t" + simulationInformation.getInitialState().toString() + "\n");
        this.summaryText.setText(stringBuffer.toString());
        this.propResultsModel = new PropertyResultsTable();
        this.propertyTable = new JTable(this.propResultsModel);
        this.resultsScroller.setViewportView(this.propertyTable);
        super.show();
        if (!this.cancelled) {
            for (n = 0; n < arrayList.size(); ++n) {
                gUIProperty = (GUIProperty)arrayList.get(n);
                double d = this.network.getResultsFile().getResult(n);
                if (!(d >= 0.0)) continue;
                gUIProperty.setResult(new Result(d));
                gUIProperty.setMethodString("Distributed Simulation");
                gUIProperty.setConstants(this.undefinedConstants.getMFConstantValues(), this.undefinedConstants.getPFConstantValues());
            }
        }
    }

    private void loadNetworkProfile(File file) throws PrismException {
        if (this.network != null) {
            this.network.deleteObserver(this);
        }
        this.network = new SimulatorNetworkHandler();
        this.network.addObserver(this);
        this.network.getResultsFile().addObserver(this);
        if (file != null) {
            try {
                this.network.loadNetworkFromXML(file);
            }
            catch (PrismException prismException) {
                try {
                    this.network.setName("No Profile Loaded");
                }
                catch (SettingException settingException) {}
            }
        } else {
            try {
                this.network.setName("No Profile Loaded");
            }
            catch (SettingException settingException) {
                // empty catch block
            }
        }
        this.networkProfileField.setText(this.network.getName());
    }

    private void doHostTable() {
        this.hostsTable.setModel(this.network);
        this.hostsTable.repaint();
        this.hostsTable.setFont(new Font("monospaced", 0, 12));
        TableColumn tableColumn = this.hostsTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(new ProgressBarRenderer());
    }

    private void doEnables() {
        int n = this.network.getState();
        this.editButton.setEnabled(n != 1);
        this.testButton.setEnabled(n != 1);
        this.feedbackIterationsProgressRadio.setEnabled(n != 1);
        this.feedbackResultsProgressRadio.setEnabled(n != 1);
        this.feedbackWhenFinishedRadio.setEnabled(n != 1);
        this.feedbackResultsWhenFinishedRadio.setEnabled(n != 1);
        this.startButton.setEnabled(n != 1);
        this.stopButton.setEnabled(n == 1);
        this.cancelButton.setEnabled(n != 1);
        this.doneButton.setEnabled(this.network.countIterationsDone() > 0 && n != 1);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.startButton = new JButton();
        this.stopButton = new JButton();
        this.doneButton = new JButton();
        this.cancelButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel12 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel4 = new JPanel();
        this.networkProfileField = new JTextField();
        this.jPanel6 = new JPanel();
        this.editButton = new JButton();
        this.testButton = new JButton();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.summaryPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.summaryText = new JEditorPane();
        this.jPanel9 = new JPanel();
        this.jPanel14 = new JPanel();
        this.feedbackIterationsProgressRadio = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jPanel5 = new JPanel();
        this.feedbackWhenFinishedRadio = new JRadioButton();
        this.jPanel10 = new JPanel();
        this.feedbackResultsProgressRadio = new JRadioButton();
        this.jPanel11 = new JPanel();
        this.resultsScroller = new JScrollPane();
        this.feedbackResultsWhenFinishedRadio = new JRadioButton();
        this.jPanel13 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel15 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.hostsTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.jPanel3.setLayout(new FlowLayout(2));
        this.startButton.setText("Start Networking");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulatorDistributionDialog.this.startButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.startButton);
        this.stopButton.setText("Stop Networking");
        this.stopButton.setPreferredSize(new Dimension(140, 25));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulatorDistributionDialog.this.stopButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.stopButton);
        this.doneButton.setText("Done");
        this.doneButton.setPreferredSize(new Dimension(75, 25));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulatorDistributionDialog.this.doneButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.doneButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulatorDistributionDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.jSplitPane1.setDividerLocation(290);
        this.jSplitPane1.setDividerSize(5);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setPreferredSize(new Dimension(900, 650));
        this.jPanel12.setLayout(new BoxLayout(this.jPanel12, 0));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Network Profile:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.networkProfileField.setEditable(false);
        this.networkProfileField.setMinimumSize(new Dimension(150, 19));
        this.networkProfileField.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.networkProfileField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.jPanel6, gridBagConstraints);
        this.editButton.setText("Change");
        this.editButton.setMinimumSize(new Dimension(82, 19));
        this.editButton.setPreferredSize(new Dimension(82, 19));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulatorDistributionDialog.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.editButton, gridBagConstraints);
        this.testButton.setText("Test");
        this.testButton.setMaximumSize(new Dimension(78, 25));
        this.testButton.setMinimumSize(new Dimension(78, 19));
        this.testButton.setPreferredSize(new Dimension(78, 19));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulatorDistributionDialog.this.testButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.testButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setLayout(new BorderLayout());
        this.jPanel8.setBorder(new TitledBorder(new EtchedBorder(), "Summary"));
        this.jPanel8.setPreferredSize(new Dimension(300, 110));
        this.summaryPanel.setLayout(new BorderLayout());
        this.summaryPanel.setBackground(new Color(255, 255, 255));
        this.summaryPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.summaryText.setEditable(false);
        this.summaryText.setMinimumSize(new Dimension(100, 21));
        this.summaryText.setPreferredSize(new Dimension(100, 21));
        this.jScrollPane2.setViewportView(this.summaryText);
        this.summaryPanel.add((Component)this.jScrollPane2, "Center");
        this.jPanel8.add((Component)this.summaryPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.jPanel2.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel12.add(this.jPanel2);
        this.jPanel14.setLayout(new GridBagLayout());
        this.feedbackIterationsProgressRadio.setSelected(true);
        this.feedbackIterationsProgressRadio.setText("Progressively");
        this.buttonGroup1.add(this.feedbackIterationsProgressRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel14.add((Component)this.feedbackIterationsProgressRadio, gridBagConstraints);
        this.jLabel2.setText("Hosts Update:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        this.jPanel14.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel5.setPreferredSize(new Dimension(30, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        this.jPanel14.add((Component)this.jPanel5, gridBagConstraints);
        this.feedbackWhenFinishedRadio.setText("When Finished");
        this.buttonGroup1.add(this.feedbackWhenFinishedRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel14.add((Component)this.feedbackWhenFinishedRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        this.jPanel14.add((Component)this.jPanel10, gridBagConstraints);
        this.feedbackResultsProgressRadio.setSelected(true);
        this.feedbackResultsProgressRadio.setText("Progressively");
        this.buttonGroup2.add(this.feedbackResultsProgressRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel14.add((Component)this.feedbackResultsProgressRadio, gridBagConstraints);
        this.jPanel11.setLayout(new BorderLayout());
        this.jPanel11.setBorder(new TitledBorder(new EtchedBorder(), "Results"));
        this.resultsScroller.setMaximumSize(null);
        this.resultsScroller.setPreferredSize(null);
        this.jPanel11.add((Component)this.resultsScroller, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel14.add((Component)this.jPanel11, gridBagConstraints);
        this.feedbackResultsWhenFinishedRadio.setText("When Finished");
        this.buttonGroup2.add(this.feedbackResultsWhenFinishedRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel14.add((Component)this.feedbackResultsWhenFinishedRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        this.jPanel14.add((Component)this.jPanel13, gridBagConstraints);
        this.jLabel3.setText("Results Update:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel14.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 5;
        this.jPanel14.add((Component)this.jPanel15, gridBagConstraints);
        this.jPanel12.add(this.jPanel14);
        this.jSplitPane1.setTopComponent(this.jPanel12);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new TitledBorder("SSH Hosts"));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.hostsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.hostsTable.setGridColor(new Color(204, 204, 204));
        this.jScrollPane1.setViewportView(this.hostsTable);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void testButtonActionPerformed(ActionEvent actionEvent) {
        this.network.doTesting();
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        try {
            GUINetworkEditor gUINetworkEditor = new GUINetworkEditor(null, this.network);
            this.hostsTable.repaint();
            this.netFile = gUINetworkEditor.getFile(null, this.netFile);
            this.loadNetworkProfile(this.netFile);
            this.doHostTable();
        }
        catch (PrismException prismException) {
            // empty catch block
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.hide();
    }

    private void doneButtonActionPerformed(ActionEvent actionEvent) {
        if (this.network.countIterationsDone() < this.info.getNumSamples()) {
            Object[] objectArray = new String[]{"Yes", "No", "Cancel"};
            int n = -1;
            n = JOptionPane.showOptionDialog(this, "Not enough iterations have been performed.\nDo you want to use the available data?\n(This may decrease the accuracy of the results)", "Question", 2, 3, null, objectArray, objectArray[0]);
            switch (n) {
                case 0: {
                    this.hide();
                    break;
                }
                case 1: {
                    this.cancelled = true;
                    this.hide();
                }
            }
        }
    }

    private void startButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.isExperiment) {
            try {
                ArrayList<Expression> arrayList = new ArrayList<Expression>();
                for (int i = 0; i < this.props.size(); ++i) {
                    GUIProperty gUIProperty = (GUIProperty)this.props.get(i);
                    arrayList.add(gUIProperty.getProperty());
                }
                System.out.println("doing 1");
                if (this.modulesFile == null) {
                    System.out.println("modulesfile is null");
                }
                if (this.propertiesFile == null) {
                    System.out.println("propertiesfile is null");
                }
                if (this.props == null) {
                    System.out.println("props is null");
                }
                if (this.info == null) {
                    System.out.println("info is null");
                }
                File file = File.createTempFile("binary" + System.currentTimeMillis(), ".bin");
                System.out.println("This is the file path: " + file.getPath());
                System.out.println("doing 2");
                this.network.doNetworking(this.info.getNumSamples(), this.info.getMaxPathLength(), file, this.feedbackIterationsProgressRadio.isSelected(), this.feedbackResultsProgressRadio.isSelected());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("ewrewoioewrrew" + exception.getMessage());
            }
        } else {
            try {
                File file = File.createTempFile("binary" + System.currentTimeMillis(), ".bin");
                System.out.println("This is the file path: " + file.getPath());
                this.network.doNetworking(this.info.getNumSamples(), this.info.getMaxPathLength(), file, this.feedbackIterationsProgressRadio.isSelected(), this.feedbackResultsProgressRadio.isSelected(), this.undefinedConstants.getMFConstantValues(), this.propertyValues, this.expr.getResults());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("ERROR 2 " + exception.getMessage());
            }
        }
    }

    private void stopButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.network.stopNetworking();
        }
        catch (PrismException prismException) {
            // empty catch block
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        this.doEnables();
        if (this.propResultsModel != null) {
            this.propResultsModel.updateTable();
        }
    }

    class PropertyResultsTable
    extends AbstractTableModel {
        String[][] data;

        public PropertyResultsTable() {
            this.data = new String[GUISimulatorDistributionDialog.this.props.size()][4];
            for (int i = 0; i < GUISimulatorDistributionDialog.this.props.size(); ++i) {
                this.data[i][0] = ((GUIProperty)GUISimulatorDistributionDialog.this.props.get(i)).getPropString();
                this.data[i][1] = "";
                this.data[i][2] = "";
                this.data[i][3] = "";
            }
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            if (GUISimulatorDistributionDialog.this.props != null) {
                return GUISimulatorDistributionDialog.this.props.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public void updateTable() {
            SimulatorResultsFile simulatorResultsFile = GUISimulatorDistributionDialog.this.network.getResultsFile();
            for (int i = 0; i < GUISimulatorDistributionDialog.this.props.size(); ++i) {
                this.data[i][1] = simulatorResultsFile.getSum(i) < 0.0 ? "" : "" + simulatorResultsFile.getSum(i);
                this.data[i][2] = simulatorResultsFile.getIterations(i) < 0 ? "" : "" + simulatorResultsFile.getIterations(i);
                this.data[i][3] = simulatorResultsFile.getResult(i) < 0.0 ? "?" : "" + simulatorResultsFile.getResult(i);
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Property";
                }
                case 1: {
                    return "Sum";
                }
                case 2: {
                    return "No. Samples";
                }
                case 3: {
                    return "Result";
                }
            }
            return "";
        }
    }

    class PepaView
    extends PlainView {
        private Matcher match;
        private Pattern pattern;

        public PepaView(Element element) {
            super(element);
            this.pattern = Pattern.compile("%.*");
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            super.paint(graphics, shape);
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            int n5 = this.findStartOfLine(n3, this.getDocument());
            int n6 = this.findEndOfLine(Math.max(n3, n4 - 1), this.getDocument());
            try {
                graphics.setColor(Color.green);
                Document document = this.getDocument();
                Segment segment = this.getLineBuffer();
                String string = document.getText(n5, n6 - n5);
                Style[] styleArray = this.highlight(string, n3 - n5, Math.max(0, n4 - n3 - 1));
                boolean bl = false;
                boolean bl2 = false;
                Object var14_15 = null;
                String string2 = GUISimulatorDistributionDialog.this.summaryText.getFont().getName();
                int n7 = GUISimulatorDistributionDialog.this.summaryText.getFont().getSize();
                for (int i = 0; i < styleArray.length; ++i) {
                    Style style = styleArray[i];
                    graphics.setColor(style.c);
                    graphics.setFont(new Font(string2, style.style, n7));
                    Segment segment2 = this.getLineBuffer();
                    document.getText(n3 + i, 1, segment2);
                    n = Utilities.drawTabbedText(segment2, n, n2, graphics, (TabExpander)this, n3 + i);
                }
                graphics.setColor(Color.black);
                graphics.setFont(new Font(string2, 0, n7));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return n;
        }

        @Override
        protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            int n5 = this.findStartOfLine(n3, this.getDocument());
            int n6 = this.findEndOfLine(Math.max(n3, n4 - 1), this.getDocument());
            try {
                graphics.setColor(Color.green);
                Document document = this.getDocument();
                Segment segment = this.getLineBuffer();
                String string = document.getText(n5, n6 - n5);
                Style[] styleArray = this.highlight(string, n3 - n5, Math.max(0, n4 - n3 - 1));
                boolean bl = false;
                boolean bl2 = false;
                Object var14_15 = null;
                String string2 = GUISimulatorDistributionDialog.this.summaryText.getFont().getName();
                int n7 = GUISimulatorDistributionDialog.this.summaryText.getFont().getSize();
                for (int i = 0; i < styleArray.length; ++i) {
                    Style style = styleArray[i];
                    graphics.setColor(style.c);
                    graphics.setFont(new Font(string2, style.style, n7));
                    Segment segment2 = this.getLineBuffer();
                    document.getText(n3 + i, 1, segment2);
                    n = Utilities.drawTabbedText(segment2, n, n2, graphics, (TabExpander)this, n3 + i);
                }
                graphics.setColor(Color.black);
                graphics.setFont(new Font(string2, 0, n7));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return n;
        }

        private synchronized Style[] highlight(String string, int n, int n2) {
            int n3;
            Style[] styleArray = new Style[string.length()];
            for (n3 = 0; n3 < styleArray.length; ++n3) {
                styleArray[n3] = GUISimulatorDistributionDialog.this.PLAIN_S;
            }
            n3 = string.indexOf(58);
            if (n3 != -1 && !string.startsWith("\t")) {
                for (int i = 0; i <= n3; ++i) {
                    styleArray[i] = GUISimulatorDistributionDialog.this.BOLD_S;
                }
            }
            Style[] styleArray2 = new Style[n2];
            for (int i = 0; i < styleArray2.length; ++i) {
                styleArray2[i] = styleArray[i + n];
            }
            return styleArray2;
        }

        private synchronized int findStartOfLine(int n, Document document) {
            int n2 = n;
            String string = "";
            try {
                string = document.getText(n2, 1);
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
            if (string.equals("\n") || --n2 < -1) {
                --n2;
            }
            while (!string.equals("\n") && n2 >= -1) {
                try {
                    string = document.getText(n2, 1);
                }
                catch (BadLocationException badLocationException) {
                    return 0;
                }
                --n2;
            }
            return n2 += 2;
        }

        private synchronized int findEndOfLine(int n, Document document) {
            int n2 = n;
            String string = "";
            try {
                string = document.getText(n2, 1);
            }
            catch (BadLocationException badLocationException) {
                return document.getLength();
            }
            ++n2;
            while (!string.equals("\n") && n2 <= document.getLength()) {
                try {
                    string = document.getText(n2, 1);
                }
                catch (BadLocationException badLocationException) {
                    return document.getLength() - 1;
                }
                ++n2;
            }
            return --n2;
        }
    }

    class SummaryContext
    extends StyleContext
    implements ViewFactory {
        public static final String COMMENT_D = "Single Line Comment";

        @Override
        public View create(Element element) {
            return new PepaView(element);
        }
    }

    class SummaryEditorKit
    extends DefaultEditorKit {
        private SummaryContext preferences;

        public SummaryContext getStylePreferences() {
            if (this.preferences == null) {
                this.preferences = new SummaryContext();
            }
            return this.preferences;
        }

        public void setStylePreferences(SummaryContext summaryContext) {
            this.preferences = summaryContext;
        }

        @Override
        public String getContentType() {
            return "text/summary";
        }

        @Override
        public Document createDefaultDocument() {
            return new PlainDocument();
        }

        @Override
        public final ViewFactory getViewFactory() {
            return this.getStylePreferences();
        }
    }

    class ProgressBarRenderer
    implements TableCellRenderer {
        ProgressBarRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof JProgressBar) {
                JProgressBar jProgressBar = new JProgressBar();
                if (bl) {
                    jProgressBar.setBackground(GUISimulatorDistributionDialog.this.hostsTable.getSelectionBackground());
                } else {
                    jProgressBar.setBackground(GUISimulatorDistributionDialog.this.hostsTable.getBackground());
                }
                return (JProgressBar)object;
            }
            return new JPanel();
        }
    }
}

