/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import parser.ast.Expression;
import parser.ast.ExpressionReward;
import parser.ast.PropertiesFile;
import prism.PrismException;
import simulator.SimulatorEngine;
import userinterface.properties.GUIProperty;
import userinterface.simulator.GUISimulator;

public class GUISimPathFormulaeList
extends JList {
    private GUISimulator guiSim;
    private SimulatorEngine engine;
    private DefaultListModel listModel;

    public GUISimPathFormulaeList(GUISimulator gUISimulator) {
        this.guiSim = gUISimulator;
        this.engine = gUISimulator.getPrism().getSimulator();
        this.listModel = new DefaultListModel();
        this.setModel(this.listModel);
        this.setCellRenderer(new SimPathFormulaRenderer());
    }

    public void clearList() {
        this.listModel.clear();
    }

    public void addRewardFormula(ExpressionReward expressionReward) {
        String string = expressionReward.getExpression().toString();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (!this.listModel.getElementAt(i).toString().equals(string)) continue;
            return;
        }
        long l = -1L;
        if (l <= 0L) {
            return;
        }
        int n = -1;
        SimPathFormula simPathFormula = new SimPathFormula(string, n);
        this.listModel.addElement(simPathFormula);
    }

    public void addProperty(Expression expression, PropertiesFile propertiesFile) {
        try {
            int n;
            String string = expression.toString();
            for (n = 0; n < this.listModel.getSize(); ++n) {
                if (!this.listModel.getElementAt(n).toString().equals(string)) continue;
                return;
            }
            n = this.engine.addProperty(expression, propertiesFile);
            SimPathFormula simPathFormula = new SimPathFormula(string, n);
            this.listModel.addElement(simPathFormula);
        }
        catch (PrismException prismException) {
            // empty catch block
        }
    }

    class BottomBorder
    implements Border {
        BottomBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
    }

    class SimPathFormulaRenderer
    extends JLabel
    implements ListCellRenderer {
        String lastText;

        public SimPathFormulaRenderer() {
            this.setOpaque(true);
            this.lastText = "Unknown";
        }

        @Override
        public String getToolTipText() {
            return this.lastText;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBorder(new BottomBorder());
            SimPathFormula simPathFormula = (SimPathFormula)object;
            this.setText(simPathFormula.toString());
            Object object2 = simPathFormula.getResult();
            if (object2 instanceof Boolean) {
                this.lastText = (Boolean)object2 != false ? "True" : "False";
                this.setIcon((Boolean)object2 != false ? GUIProperty.IMAGE_TICK : GUIProperty.IMAGE_CROSS);
            } else if (object2 != null) {
                this.lastText = object2.toString();
                this.setIcon(GUIProperty.IMAGE_NUMBER);
            } else {
                this.lastText = "Unknown";
                this.setIcon(GUIProperty.IMAGE_NOT_DONE);
            }
            this.setBackground(Color.white);
            this.repaint();
            return this;
        }
    }

    class SimPathFormula {
        String pathFormula;
        int pathFormulaIndex;

        public SimPathFormula(String string, int n) {
            this.pathFormula = string;
            this.pathFormulaIndex = n;
        }

        public String toString() {
            return this.pathFormula;
        }

        public Object getResult() {
            return GUISimPathFormulaeList.this.engine.queryProperty(this.pathFormulaIndex);
        }
    }
}

