/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import parser.ast.Expression;
import parser.ast.PropertiesFile;
import prism.PrismException;
import prism.PrismLangException;
import simulator.SimulatorEngine;
import userinterface.properties.GUIProperty;
import userinterface.simulator.GUISimulator;

public class GUISimLabelList
extends JList {
    private static final long serialVersionUID = 1L;
    private static final Color background = new Color(202, 225, 255);
    private GUISimulator sim;
    private SimulatorEngine engine;
    private DefaultListModel listModel;

    public GUISimLabelList(GUISimulator gUISimulator) {
        this.sim = gUISimulator;
        this.engine = gUISimulator.getPrism().getSimulator();
        this.listModel = new DefaultListModel();
        this.setModel(this.listModel);
        this.setCellRenderer(new SimLabelRenderer());
    }

    public void clearLabels() {
        this.listModel.clear();
    }

    public void addModelLabel(String string, Expression expression) {
        try {
            int n = this.engine.addLabel(expression);
            SimLabel simLabel = new SimLabel(string, n);
            this.listModel.addElement(simLabel);
        }
        catch (PrismLangException prismLangException) {
            // empty catch block
        }
    }

    public void addPropertyLabel(String string, Expression expression, PropertiesFile propertiesFile) {
        try {
            int n = this.engine.addLabel(expression, propertiesFile);
            SimLabel simLabel = new SimLabel(string, n);
            this.listModel.addElement(simLabel);
        }
        catch (PrismLangException prismLangException) {
            // empty catch block
        }
    }

    public void addDeadlockAndInit() {
        this.listModel.addElement(new InitSimLabel());
        this.listModel.addElement(new DeadlockSimLabel());
    }

    class BottomBorder
    implements Border {
        BottomBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
    }

    class SimLabelRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private String text;

        public SimLabelRenderer() {
            this.setOpaque(true);
            this.text = "Unknown";
        }

        @Override
        public String getToolTipText() {
            return this.text;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBorder(new BottomBorder());
            SimLabel simLabel = (SimLabel)object;
            this.setText(simLabel.toString());
            int n2 = GUISimLabelList.this.sim.isOldUpdate() ? simLabel.getResult(GUISimLabelList.this.sim.getOldUpdateStep()) : simLabel.getResult();
            switch (n2) {
                case 1: {
                    this.text = "True";
                    this.setIcon(GUIProperty.IMAGE_TICK);
                    break;
                }
                case 0: {
                    this.text = "False";
                    this.setIcon(GUIProperty.IMAGE_CROSS);
                    break;
                }
                default: {
                    this.text = "Unknown";
                    this.setIcon(GUIProperty.IMAGE_NOT_DONE);
                }
            }
            this.setBackground(bl ? background : Color.white);
            this.repaint();
            return this;
        }
    }

    class DeadlockSimLabel
    extends SimLabel {
        public DeadlockSimLabel() {
            super("deadlock", 0);
        }

        @Override
        public int getResult() {
            try {
                return GUISimLabelList.this.engine.queryIsDeadlock() ? 1 : 0;
            }
            catch (PrismException prismException) {
                return -1;
            }
        }

        @Override
        public int getResult(int n) {
            try {
                return GUISimLabelList.this.engine.queryIsDeadlock(n) ? 1 : 0;
            }
            catch (PrismException prismException) {
                return -1;
            }
        }
    }

    class InitSimLabel
    extends SimLabel {
        public InitSimLabel() {
            super("init", 0);
        }

        @Override
        public int getResult() {
            try {
                return GUISimLabelList.this.engine.queryIsInitial() ? 1 : 0;
            }
            catch (PrismLangException prismLangException) {
                return -1;
            }
        }

        @Override
        public int getResult(int n) {
            try {
                return GUISimLabelList.this.engine.queryIsInitial(n) ? 1 : 0;
            }
            catch (PrismLangException prismLangException) {
                return -1;
            }
        }
    }

    class SimLabel {
        private String name;
        private int index;

        public SimLabel(String string, int n) {
            this.name = string;
            this.index = n;
        }

        public String toString() {
            return this.name;
        }

        public int getResult() {
            try {
                boolean bl = GUISimLabelList.this.engine.queryLabel(this.index);
                return bl ? 1 : 0;
            }
            catch (PrismLangException prismLangException) {
                return -1;
            }
        }

        public int getResult(int n) {
            try {
                return GUISimLabelList.this.engine.queryLabel(this.index, n) ? 1 : 0;
            }
            catch (PrismLangException prismLangException) {
                return -1;
            }
        }
    }
}

