/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties.computation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import userinterface.properties.GUIMultiProperties;
import userinterface.properties.GUIPropConstantList;
import userinterface.properties.GUIPropLabelList;
import userinterface.properties.GUIPropertiesList;
import userinterface.util.GUIComputationEvent;

public class SavePropertiesThread
extends Thread {
    private GUIMultiProperties parent;
    private GUIPropertiesList propList;
    private GUIPropConstantList consList;
    private GUIPropLabelList labList;
    private File f;
    private Exception saveError;

    public SavePropertiesThread(GUIMultiProperties gUIMultiProperties, GUIPropertiesList gUIPropertiesList, GUIPropConstantList gUIPropConstantList, GUIPropLabelList gUIPropLabelList, File file) {
        this.parent = gUIMultiProperties;
        this.propList = gUIPropertiesList;
        this.consList = gUIPropConstantList;
        this.labList = gUIPropLabelList;
        this.f = file;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SavePropertiesThread.this.parent.startProgress();
                    SavePropertiesThread.this.parent.notifyEventListeners(new GUIComputationEvent(0, SavePropertiesThread.this.parent));
                    SavePropertiesThread.this.parent.setTaskBarText("Saving properties...");
                }
            });
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.f));
                printWriter.print(this.propList.toFileString(this.f, this.consList, this.labList));
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SavePropertiesThread.this.parent.stopProgress();
                        SavePropertiesThread.this.parent.notifyEventListeners(new GUIComputationEvent(2, SavePropertiesThread.this.parent));
                        SavePropertiesThread.this.parent.setTaskBarText("Saving properties... error.");
                        SavePropertiesThread.this.parent.error("Could not save to file \"" + SavePropertiesThread.this.f + "\"");
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SavePropertiesThread.this.parent.stopProgress();
                    SavePropertiesThread.this.parent.setTaskBarText("Saving properties... done.");
                    SavePropertiesThread.this.parent.notifyEventListeners(new GUIComputationEvent(1, SavePropertiesThread.this.parent));
                    SavePropertiesThread.this.parent.propertySaveSuccessful(SavePropertiesThread.this.f);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

