/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties.computation;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.Prism;
import prism.PrismException;
import userinterface.properties.GUIMultiProperties;
import userinterface.util.GUIComputationEvent;

public class LoadPropertiesThread
extends Thread {
    private GUIMultiProperties parent;
    private ModulesFile mf;
    private Prism pri;
    private File file;
    private PropertiesFile props = null;
    private boolean isInsert = false;
    private Exception ex;

    public LoadPropertiesThread(GUIMultiProperties gUIMultiProperties, ModulesFile modulesFile, File file) {
        this(gUIMultiProperties, modulesFile, file, false);
    }

    public LoadPropertiesThread(GUIMultiProperties gUIMultiProperties, ModulesFile modulesFile, File file, boolean bl) {
        this.parent = gUIMultiProperties;
        this.mf = modulesFile;
        this.file = file;
        this.pri = gUIMultiProperties.getPrism();
        this.isInsert = bl;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LoadPropertiesThread.this.parent.startProgress();
                    LoadPropertiesThread.this.parent.notifyEventListeners(new GUIComputationEvent(0, LoadPropertiesThread.this.parent));
                    LoadPropertiesThread.this.parent.setTaskBarText("Loading properties...");
                }
            });
            try {
                this.props = this.pri.parsePropertiesFile(this.mf, this.file, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LoadPropertiesThread.this.parent.stopProgress();
                        LoadPropertiesThread.this.parent.notifyEventListeners(new GUIComputationEvent(2, LoadPropertiesThread.this.parent));
                        LoadPropertiesThread.this.parent.setTaskBarText("Loading properties... error.");
                        LoadPropertiesThread.this.parent.error("Could not open file \"" + LoadPropertiesThread.this.file + "\"");
                    }
                });
                return;
            }
            catch (PrismException prismException) {
                this.ex = prismException;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LoadPropertiesThread.this.parent.stopProgress();
                        LoadPropertiesThread.this.parent.notifyEventListeners(new GUIComputationEvent(2, LoadPropertiesThread.this.parent));
                        LoadPropertiesThread.this.parent.setTaskBarText("Loading properties... error.");
                        LoadPropertiesThread.this.parent.error(LoadPropertiesThread.this.ex.getMessage());
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LoadPropertiesThread.this.parent.stopProgress();
                    LoadPropertiesThread.this.parent.setTaskBarText("Loading properties... done.");
                    LoadPropertiesThread.this.parent.notifyEventListeners(new GUIComputationEvent(1, LoadPropertiesThread.this.parent));
                    if (LoadPropertiesThread.this.isInsert) {
                        LoadPropertiesThread.this.parent.propertyInsertSuccessful(LoadPropertiesThread.this.props);
                    } else {
                        LoadPropertiesThread.this.parent.propertyLoadSuccessful(LoadPropertiesThread.this.props, LoadPropertiesThread.this.file);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

